/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import sun.nio.ch.EPollArrayWrapper;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

class EPollSelectorImpl
extends SelectorImpl {
    protected int fd0;
    protected int fd1;
    EPollArrayWrapper pollWrapper;
    private HashMap fdToKey;
    private boolean closed = false;
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;

    EPollSelectorImpl(SelectorProvider sp) {
        super(sp);
        int[] fdes = new int[2];
        IOUtil.initPipe(fdes, false);
        this.fd0 = fdes[0];
        this.fd1 = fdes[1];
        this.pollWrapper = new EPollArrayWrapper();
        this.pollWrapper.initInterrupt(this.fd0, this.fd1);
        this.fdToKey = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long timeout) throws IOException {
        Object object;
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            this.pollWrapper.poll(timeout);
            object = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.end();
            throw throwable;
        }
        this.end();
        this.processDeregisterQueue();
        int numKeysUpdated = this.updateSelectedKeys();
        if (this.pollWrapper.interrupted()) {
            this.pollWrapper.putEventOps(this.pollWrapper.interruptedIndex(), 0);
            object = this.interruptLock;
            synchronized (object) {
                this.pollWrapper.clearInterrupted();
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return numKeysUpdated;
    }

    private int updateSelectedKeys() {
        int entries = this.pollWrapper.updated;
        int numKeysUpdated = 0;
        for (int i = 0; i < entries; ++i) {
            int nextFD = this.pollWrapper.getDescriptor(i);
            SelectionKeyImpl ski = (SelectionKeyImpl)this.fdToKey.get(new Integer(nextFD));
            if (ski == null) continue;
            int rOps = this.pollWrapper.getEventOps(i);
            if (this.selectedKeys.contains(ski)) {
                if (!ski.channel.translateAndSetReadyOps(rOps, ski)) continue;
                ++numKeysUpdated;
                continue;
            }
            ski.channel.translateAndSetReadyOps(rOps, ski);
            if ((ski.nioReadyOps() & ski.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(ski);
            ++numKeysUpdated;
        }
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            Object object = this.interruptLock;
            synchronized (object) {
                this.interruptTriggered = true;
            }
            FileDispatcher.closeIntFD(this.fd0);
            FileDispatcher.closeIntFD(this.fd1);
            if (this.pollWrapper != null) {
                this.pollWrapper.closeEPollFD();
                this.pollWrapper = null;
                this.selectedKeys = null;
                Iterator i = this.keys.iterator();
                while (i.hasNext()) {
                    SelectionKeyImpl ski = (SelectionKeyImpl)i.next();
                    this.deregister(ski);
                    SelectableChannel selch = ski.channel();
                    if (!selch.isOpen() && !selch.isRegistered()) {
                        ((SelChImpl)((Object)selch)).kill();
                    }
                    i.remove();
                }
            }
            this.fd0 = -1;
            this.fd1 = -1;
        }
    }

    protected void implRegister(SelectionKeyImpl ski) {
        SelChImpl ch = ski.channel;
        this.fdToKey.put(ch.getFDVal(), ski);
        this.pollWrapper.add(ch);
        this.keys.add(ski);
    }

    protected void implDereg(SelectionKeyImpl ski) throws IOException {
        assert (ski.getIndex() >= 0);
        SelChImpl ch = ski.channel;
        int fd = ch.getFDVal();
        this.fdToKey.remove(new Integer(fd));
        this.pollWrapper.release(ch);
        ski.setIndex(-1);
        this.keys.remove(ski);
        this.selectedKeys.remove(ski);
        this.deregister(ski);
        SelectableChannel selch = ski.channel();
        if (!selch.isOpen() && !selch.isRegistered()) {
            ((SelChImpl)((Object)selch)).kill();
        }
    }

    void putEventOps(SelectionKeyImpl sk, int ops) {
        this.pollWrapper.setInterest(sk.channel, ops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    static {
        Util.load();
    }
}

