/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.CacheRequest;
import java.net.CookieHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.misc.RegexpPool;
import sun.net.NetworkClient;
import sun.net.ProgressSource;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.ParseUtil;
import sun.net.www.URLConnection;
import sun.net.www.http.ChunkedInputStream;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveStream;
import sun.net.www.http.PosterOutputStream;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetPropertyAction;

public class HttpClient
extends NetworkClient {
    protected boolean cachedHttpClient = false;
    private boolean inCache;
    protected CookieHandler cookieHandler;
    MessageHeader requests;
    PosterOutputStream poster = null;
    boolean failedOnce = false;
    private static RegexpPool nonProxyHostsPool = null;
    private static String nonProxyHostsSource = null;
    private static final int HTTP_CONTINUE = 100;
    static final int httpPortNumber = 80;
    protected boolean proxyDisabled;
    public boolean usingProxy = false;
    protected String host;
    protected int port;
    protected static KeepAliveCache kac = new KeepAliveCache();
    private static boolean keepAliveProp = true;
    private static boolean retryPostProp = true;
    volatile boolean keepingAlive = false;
    int keepAliveConnections = -1;
    int keepAliveTimeout = 0;
    private CacheRequest cacheRequest = null;
    protected URL url;
    public boolean reuse = false;

    protected int getDefaultPort() {
        return 80;
    }

    private static int getDefaultPort(String proto) {
        if ("http".equalsIgnoreCase(proto)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(proto)) {
            return 443;
        }
        return -1;
    }

    @Deprecated
    public static synchronized void resetProperties() {
    }

    int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public boolean getHttpKeepAliveSet() {
        return keepAliveProp;
    }

    protected HttpClient() {
    }

    private HttpClient(URL url) throws IOException {
        this(url, null, -1, false);
    }

    protected HttpClient(URL url, boolean proxyDisabled) throws IOException {
        this(url, null, -1, proxyDisabled);
    }

    public HttpClient(URL url, String proxyHost, int proxyPort) throws IOException {
        this(url, proxyHost, proxyPort, false);
    }

    protected HttpClient(URL url, Proxy p, int to) throws IOException {
        this.proxy = p == null ? Proxy.NO_PROXY : p;
        this.host = url.getHost();
        this.url = url;
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.setConnectTimeout(to);
        this.cookieHandler = (CookieHandler)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CookieHandler.getDefault();
            }
        });
        this.openServer();
    }

    protected static Proxy newHttpProxy(String proxyHost, int proxyPort, String proto) {
        if (proxyHost == null || proto == null) {
            return Proxy.NO_PROXY;
        }
        int pport = proxyPort < 0 ? HttpClient.getDefaultPort(proto) : proxyPort;
        InetSocketAddress saddr = InetSocketAddress.createUnresolved(proxyHost, pport);
        return new Proxy(Proxy.Type.HTTP, saddr);
    }

    private HttpClient(URL url, String proxyHost, int proxyPort, boolean proxyDisabled) throws IOException {
        this(url, proxyDisabled ? Proxy.NO_PROXY : HttpClient.newHttpProxy(proxyHost, proxyPort, "http"), -1);
    }

    public HttpClient(URL url, String proxyHost, int proxyPort, boolean proxyDisabled, int to) throws IOException {
        this(url, proxyDisabled ? Proxy.NO_PROXY : HttpClient.newHttpProxy(proxyHost, proxyPort, "http"), to);
    }

    public static HttpClient New(URL url) throws IOException {
        return HttpClient.New(url, Proxy.NO_PROXY, -1, true);
    }

    public static HttpClient New(URL url, boolean useCache) throws IOException {
        return HttpClient.New(url, Proxy.NO_PROXY, -1, useCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient New(URL url, Proxy p, int to, boolean useCache) throws IOException {
        if (p == null) {
            p = Proxy.NO_PROXY;
        }
        HttpClient ret = null;
        if (useCache && (ret = (HttpClient)kac.get(url, null)) != null) {
            if (ret.proxy != null && ret.proxy.equals(p) || ret.proxy == null && p == null) {
                HttpClient httpClient = ret;
                synchronized (httpClient) {
                    ret.cachedHttpClient = true;
                    assert (ret.inCache);
                    ret.inCache = false;
                }
            } else {
                ret.inCache = false;
                ret.closeServer();
                ret = null;
            }
        }
        if (ret == null) {
            ret = new HttpClient(url, p, to);
        } else {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                if (ret.proxy == Proxy.NO_PROXY || ret.proxy == null) {
                    security.checkConnect(InetAddress.getByName(url.getHost()).getHostAddress(), url.getPort());
                } else {
                    security.checkConnect(url.getHost(), url.getPort());
                }
            }
            ret.url = url;
        }
        return ret;
    }

    public static HttpClient New(URL url, Proxy p, int to) throws IOException {
        return HttpClient.New(url, p, to, true);
    }

    public static HttpClient New(URL url, String proxyHost, int proxyPort, boolean useCache) throws IOException {
        return HttpClient.New(url, HttpClient.newHttpProxy(proxyHost, proxyPort, "http"), -1, useCache);
    }

    public static HttpClient New(URL url, String proxyHost, int proxyPort, boolean useCache, int to) throws IOException {
        return HttpClient.New(url, HttpClient.newHttpProxy(proxyHost, proxyPort, "http"), to, useCache);
    }

    public void finished() {
        if (this.reuse) {
            return;
        }
        --this.keepAliveConnections;
        this.poster = null;
        if (this.keepAliveConnections > 0 && this.isKeepingAlive() && !this.serverOutput.checkError()) {
            this.putInKeepAliveCache();
        } else {
            this.closeServer();
        }
    }

    protected synchronized void putInKeepAliveCache() {
        if (this.inCache) {
            assert (false) : "Duplicate put to keep alive cache";
            return;
        }
        this.inCache = true;
        kac.put(this.url, null, this);
    }

    protected boolean isInKeepAliveCache() {
        return this.inCache;
    }

    public void closeIdleConnection() {
        HttpClient http = (HttpClient)kac.get(this.url, null);
        if (http != null) {
            http.closeServer();
        }
    }

    public void openServer(String server, int port) throws IOException {
        this.serverSocket = this.doConnect(server, port);
        try {
            this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()), false, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(encoding + " encoding not found");
        }
        this.serverSocket.setTcpNoDelay(true);
    }

    public boolean needsTunneling() {
        return false;
    }

    public boolean isCachedConnection() {
        return this.cachedHttpClient;
    }

    public void afterConnect() throws IOException, UnknownHostException {
    }

    private synchronized void privilegedOpenServer(final InetSocketAddress server) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    HttpClient.this.openServer(server.getHostName(), server.getPort());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private void superOpenServer(String proxyHost, int proxyPort) throws IOException, UnknownHostException {
        super.openServer(proxyHost, proxyPort);
    }

    private synchronized void privilegedSuperOpenServer(final String proxyHost, final int proxyPort) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    HttpClient.this.superOpenServer(proxyHost, proxyPort);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    protected synchronized void openServer() throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (this.keepingAlive) {
            if (security != null) {
                security.checkConnect(this.host, this.port);
            }
            return;
        }
        String urlHost = this.url.getHost().toLowerCase();
        if (this.url.getProtocol().equals("http") || this.url.getProtocol().equals("https")) {
            if (this.proxy != null && this.proxy.type() == Proxy.Type.HTTP) {
                URLConnection.setProxiedHost(this.host);
                if (security != null) {
                    security.checkConnect(this.host, this.port);
                }
                this.privilegedOpenServer((InetSocketAddress)this.proxy.address());
                this.usingProxy = true;
                return;
            }
            if (security != null) {
                security.checkConnect(this.host, this.port);
            }
            this.openServer(this.host, this.port);
            this.usingProxy = false;
            return;
        }
        if (this.proxy != null && this.proxy.type() == Proxy.Type.HTTP) {
            URLConnection.setProxiedHost(this.host);
            if (security != null) {
                security.checkConnect(this.host, this.port);
            }
            this.privilegedOpenServer((InetSocketAddress)this.proxy.address());
            this.usingProxy = true;
            return;
        }
        if (security != null) {
            security.checkConnect(this.host, this.port);
        }
        super.openServer(this.host, this.port);
        this.usingProxy = false;
    }

    public String getURLFile() throws IOException {
        String fileName = this.url.getFile();
        if (fileName == null || fileName.length() == 0) {
            fileName = "/";
        }
        if (this.usingProxy && !this.proxyDisabled) {
            StringBuffer result = new StringBuffer(128);
            result.append(this.url.getProtocol());
            result.append(":");
            if (this.url.getAuthority() != null && this.url.getAuthority().length() > 0) {
                result.append("//");
                result.append(this.url.getAuthority());
            }
            if (this.url.getPath() != null) {
                result.append(this.url.getPath());
            }
            if (this.url.getQuery() != null) {
                result.append('?');
                result.append(this.url.getQuery());
            }
            fileName = result.toString();
        }
        if (fileName.indexOf(10) == -1) {
            return fileName;
        }
        throw new MalformedURLException("Illegal character in URL");
    }

    @Deprecated
    public void writeRequests(MessageHeader head) {
        this.requests = head;
        this.requests.print(this.serverOutput);
        this.serverOutput.flush();
    }

    public void writeRequests(MessageHeader head, PosterOutputStream pos) throws IOException {
        this.requests = head;
        this.requests.print(this.serverOutput);
        this.poster = pos;
        if (this.poster != null) {
            this.poster.writeTo(this.serverOutput);
        }
        this.serverOutput.flush();
    }

    public boolean parseHTTP(MessageHeader responses, ProgressSource pi, HttpURLConnection httpuc) throws IOException {
        try {
            this.serverInput = this.serverSocket.getInputStream();
            this.serverInput = new BufferedInputStream(this.serverInput);
            return this.parseHTTPHeader(responses, pi, httpuc);
        }
        catch (SocketTimeoutException stex) {
            this.closeServer();
            throw stex;
        }
        catch (IOException e) {
            this.closeServer();
            this.cachedHttpClient = false;
            if (!(this.failedOnce || this.requests == null || httpuc.getRequestMethod().equals("POST") && !retryPostProp)) {
                this.failedOnce = true;
                this.openServer();
                if (this.needsTunneling()) {
                    httpuc.doTunneling();
                }
                this.afterConnect();
                this.writeRequests(this.requests, this.poster);
                return this.parseHTTP(responses, pi, httpuc);
            }
            throw e;
        }
    }

    public int setTimeout(int timeout) throws SocketException {
        int old = this.serverSocket.getSoTimeout();
        this.serverSocket.setSoTimeout(timeout);
        return old;
    }

    private boolean parseHTTPHeader(MessageHeader responses, ProgressSource pi, HttpURLConnection httpuc) throws IOException {
        int nread;
        int r;
        this.keepAliveConnections = -1;
        this.keepAliveTimeout = 0;
        boolean ret = false;
        byte[] b = new byte[8];
        this.serverInput.mark(10);
        for (nread = 0; nread < 8 && (r = this.serverInput.read(b, nread, 8 - nread)) >= 0; nread += r) {
        }
        String keep = null;
        ret = b[0] == 72 && b[1] == 84 && b[2] == 84 && b[3] == 80 && b[4] == 47 && b[5] == 49 && b[6] == 46;
        this.serverInput.reset();
        if (ret) {
            URI uri;
            responses.parseHeader(this.serverInput);
            if (this.cookieHandler != null && (uri = ParseUtil.toURI(this.url)) != null) {
                this.cookieHandler.put(uri, responses.getHeaders());
            }
            if (this.usingProxy) {
                keep = responses.findValue("Proxy-Connection");
            }
            if (keep == null) {
                keep = responses.findValue("Connection");
            }
            if (keep != null && keep.toLowerCase().equals("keep-alive")) {
                HeaderParser p = new HeaderParser(responses.findValue("Keep-Alive"));
                if (p != null) {
                    this.keepAliveConnections = p.findInt("max", this.usingProxy ? 50 : 5);
                    this.keepAliveTimeout = p.findInt("timeout", this.usingProxy ? 60 : 5);
                }
            } else if (b[7] != 48) {
                this.keepAliveConnections = keep != null ? 1 : 5;
            }
        } else {
            if (nread != 8) {
                if (!(this.failedOnce || this.requests == null || httpuc.getRequestMethod().equals("POST") && !retryPostProp)) {
                    this.failedOnce = true;
                    this.closeServer();
                    this.cachedHttpClient = false;
                    this.openServer();
                    if (this.needsTunneling()) {
                        httpuc.doTunneling();
                    }
                    this.afterConnect();
                    this.writeRequests(this.requests, this.poster);
                    return this.parseHTTP(responses, pi, httpuc);
                }
                throw new SocketException("Unexpected end of file from server");
            }
            responses.set("Content-type", "unknown/unknown");
        }
        int code = -1;
        try {
            String resp = responses.getValue(0);
            int ind = resp.indexOf(32);
            while (resp.charAt(ind) == ' ') {
                ++ind;
            }
            code = Integer.parseInt(resp.substring(ind, ind + 3));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (code == 100) {
            responses.reset();
            return this.parseHTTPHeader(responses, pi, httpuc);
        }
        int cl = -1;
        String te = null;
        try {
            te = responses.findValue("Transfer-Encoding");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (te != null && te.equalsIgnoreCase("chunked")) {
            this.serverInput = new ChunkedInputStream(this.serverInput, this, responses);
            if (this.keepAliveConnections <= 1) {
                this.keepAliveConnections = 1;
                this.keepingAlive = false;
            } else {
                this.keepingAlive = true;
            }
            this.failedOnce = false;
        } else {
            try {
                cl = Integer.parseInt(responses.findValue("content-length"));
            }
            catch (Exception e) {
                // empty catch block
            }
            String requestLine = this.requests.getKey(0);
            if (requestLine != null && requestLine.startsWith("HEAD") || code == 304 || code == 204) {
                cl = 0;
            }
            if (this.keepAliveConnections > 1 && (cl >= 0 || code == 304 || code == 204)) {
                this.keepingAlive = true;
                this.failedOnce = false;
            } else if (this.keepingAlive) {
                this.keepingAlive = false;
            }
        }
        if (cl > 0) {
            if (pi != null) {
                pi.setContentType(responses.findValue("content-type"));
            }
            if (this.isKeepingAlive()) {
                this.serverInput = new KeepAliveStream(this.serverInput, pi, cl, this);
                this.failedOnce = false;
            } else {
                this.serverInput = new MeteredStream(this.serverInput, pi, cl);
            }
        } else if (cl == -1) {
            if (pi != null) {
                pi.setContentType(responses.findValue("content-type"));
                this.serverInput = new MeteredStream(this.serverInput, pi, cl);
            }
        } else if (pi != null) {
            pi.finishTracking();
        }
        return ret;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.url + ")";
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.keepingAlive;
    }

    public void setCacheRequest(CacheRequest cacheRequest) {
        this.cacheRequest = cacheRequest;
    }

    CacheRequest getCacheRequest() {
        return this.cacheRequest;
    }

    protected void finalize() throws Throwable {
    }

    public void setDoNotRetry(boolean value) {
        this.failedOnce = value;
    }

    public void closeServer() {
        try {
            this.keepingAlive = false;
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProxyHostUsed() {
        if (!this.usingProxy) {
            return null;
        }
        return ((InetSocketAddress)this.proxy.address()).getHostName();
    }

    public int getProxyPortUsed() {
        if (this.usingProxy) {
            return ((InetSocketAddress)this.proxy.address()).getPort();
        }
        return -1;
    }

    static {
        String keepAlive = AccessController.doPrivileged(new GetPropertyAction("http.keepAlive"));
        String retryPost = AccessController.doPrivileged(new GetPropertyAction("sun.net.http.retryPost"));
        keepAliveProp = keepAlive != null ? Boolean.valueOf(keepAlive) : true;
        retryPostProp = retryPost != null ? Boolean.valueOf(retryPost) : true;
    }
}

