/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import sun.management.ManagementFactory;
import sun.management.VMManagement;

class ThreadImpl
implements ThreadMXBean {
    private final VMManagement jvm;
    private boolean contentionMonitoringEnabled = false;
    private boolean cpuTimeEnabled;

    ThreadImpl(VMManagement vm) {
        this.jvm = vm;
        this.cpuTimeEnabled = this.jvm.isThreadCpuTimeEnabled();
    }

    public int getThreadCount() {
        return this.jvm.getLiveThreadCount();
    }

    public int getPeakThreadCount() {
        return this.jvm.getPeakThreadCount();
    }

    public long getTotalStartedThreadCount() {
        return this.jvm.getTotalThreadCount();
    }

    public int getDaemonThreadCount() {
        return this.jvm.getDaemonThreadCount();
    }

    public boolean isThreadContentionMonitoringSupported() {
        return this.jvm.isThreadContentionMonitoringSupported();
    }

    public synchronized boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported.");
        }
        return this.contentionMonitoringEnabled;
    }

    public boolean isThreadCpuTimeSupported() {
        return this.jvm.isOtherThreadCpuTimeSupported();
    }

    public boolean isCurrentThreadCpuTimeSupported() {
        return this.jvm.isCurrentThreadCpuTimeSupported();
    }

    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        return this.cpuTimeEnabled;
    }

    public long[] getAllThreadIds() {
        ManagementFactory.checkMonitorAccess();
        Thread[] threads = ThreadImpl.getThreads();
        int length = threads.length;
        long[] ids = new long[length];
        for (int i = 0; i < length; ++i) {
            Thread t = threads[i];
            ids[i] = t.getId();
        }
        return ids;
    }

    public ThreadInfo getThreadInfo(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + id);
        }
        long[] ids = new long[]{id};
        ThreadInfo[] infos = this.getThreadInfo(ids, 0);
        return infos[0];
    }

    public ThreadInfo getThreadInfo(long id, int maxDepth) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + id);
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + maxDepth);
        }
        long[] ids = new long[]{id};
        ThreadInfo[] infos = this.getThreadInfo(ids, maxDepth);
        return infos[0];
    }

    public ThreadInfo[] getThreadInfo(long[] ids) {
        return this.getThreadInfo(ids, 0);
    }

    public ThreadInfo[] getThreadInfo(long[] ids, int maxDepth) {
        if (ids == null) {
            throw new NullPointerException("Null ids parameter.");
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + maxDepth);
        }
        ManagementFactory.checkMonitorAccess();
        ThreadInfo[] infos = new ThreadInfo[ids.length];
        if (maxDepth == Integer.MAX_VALUE) {
            ThreadImpl.getThreadInfo0(ids, -1, infos);
        } else {
            ThreadImpl.getThreadInfo0(ids, maxDepth, infos);
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadContentionMonitoringEnabled(boolean enable) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported");
        }
        ManagementFactory.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.contentionMonitoringEnabled != enable) {
                if (enable) {
                    ThreadImpl.resetContentionTimes0(0L);
                }
                ThreadImpl.setThreadContentionMonitoringEnabled0(enable);
                this.contentionMonitoringEnabled = enable;
            }
        }
    }

    public long getCurrentThreadCpuTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        return ThreadImpl.getThreadTotalCpuTime0(0L);
    }

    public long getThreadCpuTime(long id) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU Time Measurement is not supported.");
        }
        if (!this.isThreadCpuTimeSupported() && id != Thread.currentThread().getId()) {
            throw new UnsupportedOperationException("Thread CPU Time Measurement is only supported for the current thread.");
        }
        if (id <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + id);
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        if (id == Thread.currentThread().getId()) {
            return ThreadImpl.getThreadTotalCpuTime0(0L);
        }
        return ThreadImpl.getThreadTotalCpuTime0(id);
    }

    public long getCurrentThreadUserTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        return ThreadImpl.getThreadUserCpuTime0(0L);
    }

    public long getThreadUserTime(long id) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeSupported() && id != Thread.currentThread().getId()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is only supported for the current thread.");
        }
        if (id <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + id);
        }
        if (!this.isThreadCpuTimeEnabled()) {
            return -1L;
        }
        if (id == Thread.currentThread().getId()) {
            return ThreadImpl.getThreadUserCpuTime0(0L);
        }
        return ThreadImpl.getThreadUserCpuTime0(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadCpuTimeEnabled(boolean enable) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        ManagementFactory.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.cpuTimeEnabled != enable) {
                ThreadImpl.setThreadCpuTimeEnabled0(enable);
                this.cpuTimeEnabled = enable;
            }
        }
    }

    public long[] findMonitorDeadlockedThreads() {
        ManagementFactory.checkMonitorAccess();
        Thread[] threads = ThreadImpl.findMonitorDeadlockedThreads0();
        if (threads == null) {
            return null;
        }
        long[] ids = new long[threads.length];
        for (int i = 0; i < threads.length; ++i) {
            Thread t = threads[i];
            ids[i] = t.getId();
        }
        return ids;
    }

    public long[] findDeadlockedThreads() {
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        ManagementFactory.checkMonitorAccess();
        Thread[] threads = ThreadImpl.findDeadlockedThreads0();
        if (threads == null) {
            return null;
        }
        long[] ids = new long[threads.length];
        for (int i = 0; i < threads.length; ++i) {
            Thread t = threads[i];
            ids[i] = t.getId();
        }
        return ids;
    }

    public void resetPeakThreadCount() {
        ManagementFactory.checkControlAccess();
        ThreadImpl.resetPeakThreadCount0();
    }

    public boolean isObjectMonitorUsageSupported() {
        return this.jvm.isObjectMonitorUsageSupported();
    }

    public boolean isSynchronizerUsageSupported() {
        return this.jvm.isSynchronizerUsageSupported();
    }

    public ThreadInfo[] getThreadInfo(long[] ids, boolean lockedMonitors, boolean lockedSynchronizers) {
        if (ids == null) {
            throw new NullPointerException("Null ids parameter.");
        }
        if (lockedMonitors && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Object Monitor Usage is not supported.");
        }
        if (lockedSynchronizers && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        ManagementFactory.checkMonitorAccess();
        return ThreadImpl.dumpThreads0(ids, lockedMonitors, lockedSynchronizers);
    }

    public ThreadInfo[] dumpAllThreads(boolean lockedMonitors, boolean lockedSynchronizers) {
        if (lockedMonitors && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Object Monitor Usage is not supported.");
        }
        if (lockedSynchronizers && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        ManagementFactory.checkMonitorAccess();
        return ThreadImpl.dumpThreads0(null, lockedMonitors, lockedSynchronizers);
    }

    private static native Thread[] getThreads();

    private static native void getThreadInfo0(long[] var0, int var1, ThreadInfo[] var2);

    private static native long getThreadTotalCpuTime0(long var0);

    private static native long getThreadUserCpuTime0(long var0);

    private static native void setThreadCpuTimeEnabled0(boolean var0);

    private static native void setThreadContentionMonitoringEnabled0(boolean var0);

    private static native Thread[] findMonitorDeadlockedThreads0();

    private static native Thread[] findDeadlockedThreads0();

    private static native void resetPeakThreadCount0();

    private static native ThreadInfo[] dumpThreads0(long[] var0, boolean var1, boolean var2);

    private static native void resetContentionTimes0(long var0);
}

