/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.Visual;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class Depth
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 12;
    }

    public int getDataSize() {
        return Depth.getSize();
    }

    public long getPData() {
        return this.pData;
    }

    Depth(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    Depth() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(Depth.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_depth() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_depth(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public int get_nvisuals() {
        log.finest("");
        return Native.getInt(this.pData + 4L);
    }

    public void set_nvisuals(int v) {
        log.finest("");
        Native.putInt(this.pData + 4L, v);
    }

    public Visual get_visuals(int index) {
        log.finest("");
        return Native.getLong(this.pData + 8L) != 0L ? new Visual(Native.getLong(this.pData + 8L) + (long)(index * 32)) : null;
    }

    public long get_visuals() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_visuals(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    String getName() {
        return "Depth";
    }

    String getFieldsAsString() {
        String ret = "";
        ret = ret + "depth = " + this.get_depth() + ", ";
        ret = ret + "nvisuals = " + this.get_nvisuals() + ", ";
        ret = ret + "visuals = " + this.get_visuals() + ", ";
        return ret;
    }
}

