/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.text.JTextComponent;
import sun.awt.shell.ShellFolder;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicFileChooserUI
extends FileChooserUI {
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;
    protected Icon computerIcon = null;
    protected Icon hardDriveIcon = null;
    protected Icon floppyDriveIcon = null;
    protected Icon newFolderIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;
    protected int saveButtonMnemonic = 0;
    protected int openButtonMnemonic = 0;
    protected int cancelButtonMnemonic = 0;
    protected int updateButtonMnemonic = 0;
    protected int helpButtonMnemonic = 0;
    protected int directoryOpenButtonMnemonic = 0;
    protected String saveButtonText = null;
    protected String openButtonText = null;
    protected String cancelButtonText = null;
    protected String updateButtonText = null;
    protected String helpButtonText = null;
    protected String directoryOpenButtonText = null;
    private String openDialogTitleText = null;
    private String saveDialogTitleText = null;
    protected String saveButtonToolTipText = null;
    protected String openButtonToolTipText = null;
    protected String cancelButtonToolTipText = null;
    protected String updateButtonToolTipText = null;
    protected String helpButtonToolTipText = null;
    protected String directoryOpenButtonToolTipText = null;
    private Action approveSelectionAction = new ApproveSelectionAction();
    private Action cancelSelectionAction = new CancelSelectionAction();
    private Action updateAction = new UpdateAction();
    private Action newFolderAction;
    private Action goHomeAction = new GoHomeAction();
    private Action changeToParentDirectoryAction = new ChangeToParentDirectoryAction();
    private String newFolderErrorSeparator = null;
    private String newFolderErrorText = null;
    private String fileDescriptionText = null;
    private String directoryDescriptionText = null;
    private JFileChooser filechooser = null;
    private boolean directorySelected = false;
    private File directory = null;
    private PropertyChangeListener propertyChangeListener = null;
    private AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter();
    private FileFilter actualFileFilter = null;
    private GlobFilter globFilter = null;
    private BasicDirectoryModel model = null;
    private BasicFileView fileView = new BasicFileView();
    private boolean usesSingleFilePane;
    private boolean readOnly;
    private JPanel accessoryPanel = null;
    private Handler handler;
    private static final TransferHandler defaultTransferHandler = new FileTransferHandler();

    public BasicFileChooserUI(JFileChooser b) {
    }

    public void installUI(JComponent c) {
        this.accessoryPanel = new JPanel(new BorderLayout());
        this.filechooser = (JFileChooser)c;
        this.createModel();
        this.clearIconCache();
        this.installDefaults(this.filechooser);
        this.installComponents(this.filechooser);
        this.installListeners(this.filechooser);
        this.filechooser.applyComponentOrientation(this.filechooser.getComponentOrientation());
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
        this.handler = null;
    }

    public void installComponents(JFileChooser fc) {
    }

    public void uninstallComponents(JFileChooser fc) {
    }

    protected void installListeners(JFileChooser fc) {
        this.propertyChangeListener = this.createPropertyChangeListener(fc);
        if (this.propertyChangeListener != null) {
            fc.addPropertyChangeListener(this.propertyChangeListener);
        }
        fc.addPropertyChangeListener(this.getModel());
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(fc, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)DefaultLookup.get(this.getFileChooser(), this, "FileChooser.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        UIAction refreshAction = new UIAction("refresh"){

            public void actionPerformed(ActionEvent evt) {
                BasicFileChooserUI.this.getFileChooser().rescanCurrentDirectory();
            }
        };
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", this.getCancelSelectionAction());
        map.put("refresh", refreshAction);
        map.put("Go Up", this.getChangeToParentDirectoryAction());
        return map;
    }

    protected void uninstallListeners(JFileChooser fc) {
        if (this.propertyChangeListener != null) {
            fc.removePropertyChangeListener(this.propertyChangeListener);
        }
        fc.removePropertyChangeListener(this.getModel());
        SwingUtilities.replaceUIInputMap(fc, 1, null);
        SwingUtilities.replaceUIActionMap(fc, null);
    }

    protected void installDefaults(JFileChooser fc) {
        this.installIcons(fc);
        this.installStrings(fc);
        this.usesSingleFilePane = UIManager.getBoolean("FileChooser.usesSingleFilePane");
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        TransferHandler th = fc.getTransferHandler();
        if (th == null || th instanceof UIResource) {
            fc.setTransferHandler(defaultTransferHandler);
        }
        LookAndFeel.installProperty(fc, "opaque", Boolean.FALSE);
    }

    protected void installIcons(JFileChooser fc) {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.computerIcon = UIManager.getIcon("FileView.computerIcon");
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        this.floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
        this.newFolderIcon = UIManager.getIcon("FileChooser.newFolderIcon");
        this.upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
        this.homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        this.detailsViewIcon = UIManager.getIcon("FileChooser.detailsViewIcon");
        this.listViewIcon = UIManager.getIcon("FileChooser.listViewIcon");
    }

    protected void installStrings(JFileChooser fc) {
        Locale l = fc.getLocale();
        this.newFolderErrorText = UIManager.getString((Object)"FileChooser.newFolderErrorText", l);
        this.newFolderErrorSeparator = UIManager.getString((Object)"FileChooser.newFolderErrorSeparator", l);
        this.fileDescriptionText = UIManager.getString((Object)"FileChooser.fileDescriptionText", l);
        this.directoryDescriptionText = UIManager.getString((Object)"FileChooser.directoryDescriptionText", l);
        this.saveButtonText = UIManager.getString((Object)"FileChooser.saveButtonText", l);
        this.openButtonText = UIManager.getString((Object)"FileChooser.openButtonText", l);
        this.saveDialogTitleText = UIManager.getString((Object)"FileChooser.saveDialogTitleText", l);
        this.openDialogTitleText = UIManager.getString((Object)"FileChooser.openDialogTitleText", l);
        this.cancelButtonText = UIManager.getString((Object)"FileChooser.cancelButtonText", l);
        this.updateButtonText = UIManager.getString((Object)"FileChooser.updateButtonText", l);
        this.helpButtonText = UIManager.getString((Object)"FileChooser.helpButtonText", l);
        this.directoryOpenButtonText = UIManager.getString((Object)"FileChooser.directoryOpenButtonText", l);
        this.saveButtonMnemonic = this.getMnemonic("FileChooser.saveButtonMnemonic", l);
        this.openButtonMnemonic = this.getMnemonic("FileChooser.openButtonMnemonic", l);
        this.cancelButtonMnemonic = this.getMnemonic("FileChooser.cancelButtonMnemonic", l);
        this.updateButtonMnemonic = this.getMnemonic("FileChooser.updateButtonMnemonic", l);
        this.helpButtonMnemonic = this.getMnemonic("FileChooser.helpButtonMnemonic", l);
        this.directoryOpenButtonMnemonic = this.getMnemonic("FileChooser.directoryOpenButtonMnemonic", l);
        this.saveButtonToolTipText = UIManager.getString((Object)"FileChooser.saveButtonToolTipText", l);
        this.openButtonToolTipText = UIManager.getString((Object)"FileChooser.openButtonToolTipText", l);
        this.cancelButtonToolTipText = UIManager.getString((Object)"FileChooser.cancelButtonToolTipText", l);
        this.updateButtonToolTipText = UIManager.getString((Object)"FileChooser.updateButtonToolTipText", l);
        this.helpButtonToolTipText = UIManager.getString((Object)"FileChooser.helpButtonToolTipText", l);
        this.directoryOpenButtonToolTipText = UIManager.getString((Object)"FileChooser.directoryOpenButtonToolTipText", l);
    }

    protected void uninstallDefaults(JFileChooser fc) {
        this.uninstallIcons(fc);
        this.uninstallStrings(fc);
        if (fc.getTransferHandler() instanceof UIResource) {
            fc.setTransferHandler(null);
        }
    }

    protected void uninstallIcons(JFileChooser fc) {
        this.directoryIcon = null;
        this.fileIcon = null;
        this.computerIcon = null;
        this.hardDriveIcon = null;
        this.floppyDriveIcon = null;
        this.newFolderIcon = null;
        this.upFolderIcon = null;
        this.homeFolderIcon = null;
        this.detailsViewIcon = null;
        this.listViewIcon = null;
    }

    protected void uninstallStrings(JFileChooser fc) {
        this.saveButtonText = null;
        this.openButtonText = null;
        this.cancelButtonText = null;
        this.updateButtonText = null;
        this.helpButtonText = null;
        this.directoryOpenButtonText = null;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.updateButtonToolTipText = null;
        this.helpButtonToolTipText = null;
        this.directoryOpenButtonToolTipText = null;
    }

    protected void createModel() {
        if (this.model != null) {
            this.model.invalidateFileCache();
        }
        this.model = new BasicDirectoryModel(this.getFileChooser());
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return null;
    }

    public String getFileName() {
        return null;
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String filename) {
    }

    public void setDirectoryName(String dirname) {
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return null;
    }

    public String getApproveButtonToolTipText(JFileChooser fc) {
        String tooltipText = fc.getApproveButtonToolTipText();
        if (tooltipText != null) {
            return tooltipText;
        }
        if (fc.getDialogType() == 0) {
            return this.openButtonToolTipText;
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return null;
    }

    public void clearIconCache() {
        this.fileView.clearIconCache();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected MouseListener createDoubleClickListener(JFileChooser fc, JList list) {
        return new Handler(list);
    }

    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return this.getHandler();
    }

    protected boolean isDirectorySelected() {
        return this.directorySelected;
    }

    protected void setDirectorySelected(boolean b) {
        this.directorySelected = b;
    }

    protected File getDirectory() {
        return this.directory;
    }

    protected void setDirectory(File f) {
        this.directory = f;
    }

    private int getMnemonic(String key, Locale l) {
        return SwingUtilities2.getUIDefaultsInt((Object)key, l);
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser fc) {
        return this.acceptAllFileFilter;
    }

    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    public String getDialogTitle(JFileChooser fc) {
        String dialogTitle = fc.getDialogTitle();
        if (dialogTitle != null) {
            return dialogTitle;
        }
        if (fc.getDialogType() == 0) {
            return this.openDialogTitleText;
        }
        if (fc.getDialogType() == 1) {
            return this.saveDialogTitleText;
        }
        return this.getApproveButtonText(fc);
    }

    public int getApproveButtonMnemonic(JFileChooser fc) {
        int mnemonic = fc.getApproveButtonMnemonic();
        if (mnemonic > 0) {
            return mnemonic;
        }
        if (fc.getDialogType() == 0) {
            return this.openButtonMnemonic;
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        return mnemonic;
    }

    public String getApproveButtonText(JFileChooser fc) {
        String buttonText = fc.getApproveButtonText();
        if (buttonText != null) {
            return buttonText;
        }
        if (fc.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    public Action getNewFolderAction() {
        if (this.newFolderAction == null) {
            this.newFolderAction = new NewFolderAction();
            if (this.readOnly) {
                this.newFolderAction.setEnabled(false);
            }
        }
        return this.newFolderAction;
    }

    public Action getGoHomeAction() {
        return this.goHomeAction;
    }

    public Action getChangeToParentDirectoryAction() {
        return this.changeToParentDirectoryAction;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    public Action getUpdateAction() {
        return this.updateAction;
    }

    private void resetGlobFilter() {
        if (this.actualFileFilter != null) {
            JFileChooser chooser = this.getFileChooser();
            FileFilter currentFilter = chooser.getFileFilter();
            if (currentFilter != null && currentFilter.equals(this.globFilter)) {
                chooser.setFileFilter(this.actualFileFilter);
                chooser.removeChoosableFileFilter(this.globFilter);
            }
            this.actualFileFilter = null;
        }
    }

    private static boolean isGlobPattern(String filename) {
        return File.separatorChar == '\\' && (filename.indexOf(42) >= 0 || filename.indexOf(63) >= 0) || File.separatorChar == '/' && (filename.indexOf(42) >= 0 || filename.indexOf(63) >= 0 || filename.indexOf(91) >= 0);
    }

    private void changeDirectory(File dir) {
        JFileChooser fc = this.getFileChooser();
        if (dir != null && File.separatorChar == '\\' && dir.getPath().endsWith(".lnk")) {
            try {
                ShellFolder linkedTo = ShellFolder.getShellFolder(dir).getLinkLocation();
                if (linkedTo == null || !fc.isTraversable(linkedTo)) {
                    return;
                }
                dir = linkedTo;
            }
            catch (FileNotFoundException ex) {
                return;
            }
        }
        fc.setCurrentDirectory(dir);
        if (fc.getFileSelectionMode() == 2 && fc.getFileSystemView().isFileSystem(dir)) {
            this.setFileName(dir.getAbsolutePath());
        }
    }

    static class FileTransferHandler
    extends TransferHandler
    implements UIResource {
        FileTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            int i;
            JTable table;
            int[] rows;
            Object[] values = null;
            if (c instanceof JList) {
                values = ((JList)c).getSelectedValues();
            } else if (c instanceof JTable && (rows = (table = (JTable)c).getSelectedRows()) != null) {
                values = new Object[rows.length];
                for (i = 0; i < rows.length; ++i) {
                    values[i] = table.getValueAt(rows[i], 0);
                }
            }
            if (values == null || values.length == 0) {
                return null;
            }
            StringBuffer plainBuf = new StringBuffer();
            StringBuffer htmlBuf = new StringBuffer();
            htmlBuf.append("<html>\n<body>\n<ul>\n");
            for (i = 0; i < values.length; ++i) {
                Object obj = values[i];
                String val = obj == null ? "" : obj.toString();
                plainBuf.append(val + "\n");
                htmlBuf.append("  <li>" + val + "\n");
            }
            plainBuf.deleteCharAt(plainBuf.length() - 1);
            htmlBuf.append("</ul>\n</body>\n</html>");
            return new FileTransferable(plainBuf.toString(), htmlBuf.toString(), values);
        }

        public int getSourceActions(JComponent c) {
            return 1;
        }

        static class FileTransferable
        extends BasicTransferable {
            Object[] fileData;

            FileTransferable(String plainData, String htmlData, Object[] fileData) {
                super(plainData, htmlData);
                this.fileData = fileData;
            }

            protected DataFlavor[] getRicherFlavors() {
                DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor};
                return flavors;
            }

            protected Object getRicherData(DataFlavor flavor) {
                if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                    ArrayList<Object> files = new ArrayList<Object>();
                    for (int i = 0; i < this.fileData.length; ++i) {
                        files.add(this.fileData[i]);
                    }
                    return files;
                }
                return null;
            }
        }
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable<File, Icon> iconCache = new Hashtable();

        public void clearIconCache() {
            this.iconCache = new Hashtable();
        }

        public String getName(File f) {
            String fileName = null;
            if (f != null) {
                fileName = BasicFileChooserUI.this.getFileChooser().getFileSystemView().getSystemDisplayName(f);
            }
            return fileName;
        }

        public String getDescription(File f) {
            return f.getName();
        }

        public String getTypeDescription(File f) {
            String type = BasicFileChooserUI.this.getFileChooser().getFileSystemView().getSystemTypeDescription(f);
            if (type == null) {
                type = f.isDirectory() ? BasicFileChooserUI.this.directoryDescriptionText : BasicFileChooserUI.this.fileDescriptionText;
            }
            return type;
        }

        public Icon getCachedIcon(File f) {
            return this.iconCache.get(f);
        }

        public void cacheIcon(File f, Icon i) {
            if (f == null || i == null) {
                return;
            }
            this.iconCache.put(f, i);
        }

        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            icon = BasicFileChooserUI.this.fileIcon;
            if (f != null) {
                FileSystemView fsv = BasicFileChooserUI.this.getFileChooser().getFileSystemView();
                if (fsv.isFloppyDrive(f)) {
                    icon = BasicFileChooserUI.this.floppyDriveIcon;
                } else if (fsv.isDrive(f)) {
                    icon = BasicFileChooserUI.this.hardDriveIcon;
                } else if (fsv.isComputerNode(f)) {
                    icon = BasicFileChooserUI.this.computerIcon;
                } else if (f.isDirectory()) {
                    icon = BasicFileChooserUI.this.directoryIcon;
                }
            }
            this.cacheIcon(f, icon);
            return icon;
        }

        public Boolean isHidden(File f) {
            String name = f.getName();
            if (name != null && name.charAt(0) == '.') {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return UIManager.getString("FileChooser.acceptAllFileFilterText");
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = BasicFileChooserUI.this.getFileChooser();
            fc.setCurrentDirectory(fc.getFileSystemView().createFileObject(BasicFileChooserUI.this.getDirectoryName()));
            fc.rescanCurrentDirectory();
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            BasicFileChooserUI.this.getFileChooser().cancelSelection();
        }
    }

    class GlobFilter
    extends FileFilter {
        Pattern pattern;
        String globPattern;

        GlobFilter() {
        }

        public void setPattern(String globPattern) {
            char[] gPat = globPattern.toCharArray();
            char[] rPat = new char[gPat.length * 2];
            boolean isWin32 = File.separatorChar == '\\';
            boolean inBrackets = false;
            int j = 0;
            this.globPattern = globPattern;
            if (isWin32) {
                int len = gPat.length;
                if (globPattern.endsWith("*.*")) {
                    len -= 2;
                }
                block16: for (int i = 0; i < len; ++i) {
                    switch (gPat[i]) {
                        case '*': {
                            rPat[j++] = 46;
                            rPat[j++] = 42;
                            continue block16;
                        }
                        case '?': {
                            rPat[j++] = 46;
                            continue block16;
                        }
                        case '\\': {
                            rPat[j++] = 92;
                            rPat[j++] = 92;
                            continue block16;
                        }
                        default: {
                            if ("+()^$.{}[]".indexOf(gPat[i]) >= 0) {
                                rPat[j++] = 92;
                            }
                            rPat[j++] = gPat[i];
                        }
                    }
                }
            } else {
                block17: for (int i = 0; i < gPat.length; ++i) {
                    switch (gPat[i]) {
                        case '*': {
                            if (!inBrackets) {
                                rPat[j++] = 46;
                            }
                            rPat[j++] = 42;
                            continue block17;
                        }
                        case '?': {
                            rPat[j++] = inBrackets ? 63 : 46;
                            continue block17;
                        }
                        case '[': {
                            inBrackets = true;
                            rPat[j++] = gPat[i];
                            if (i >= gPat.length - 1) continue block17;
                            switch (gPat[i + 1]) {
                                case '!': 
                                case '^': {
                                    rPat[j++] = 94;
                                    ++i;
                                    break;
                                }
                                case ']': {
                                    rPat[j++] = gPat[++i];
                                }
                            }
                            continue block17;
                        }
                        case ']': {
                            rPat[j++] = gPat[i];
                            inBrackets = false;
                            continue block17;
                        }
                        case '\\': {
                            if (i == 0 && gPat.length > 1 && gPat[1] == '~') {
                                rPat[j++] = gPat[++i];
                                continue block17;
                            }
                            rPat[j++] = 92;
                            if (i < gPat.length - 1 && "*?[]".indexOf(gPat[i + 1]) >= 0) {
                                rPat[j++] = gPat[++i];
                                continue block17;
                            }
                            rPat[j++] = 92;
                            continue block17;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(gPat[i])) {
                                rPat[j++] = 92;
                            }
                            rPat[j++] = gPat[i];
                        }
                    }
                }
            }
            this.pattern = Pattern.compile(new String(rPat, 0, j), 2);
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(f.getName()).matches();
        }

        public String getDescription() {
            return this.globPattern;
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
            super("approveSelection");
        }

        public void actionPerformed(ActionEvent e) {
            File dir;
            if (BasicFileChooserUI.this.isDirectorySelected() && (dir = BasicFileChooserUI.this.getDirectory()) != null) {
                try {
                    dir = ShellFolder.getNormalizedFile(dir);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                BasicFileChooserUI.this.changeDirectory(dir);
                return;
            }
            JFileChooser chooser = BasicFileChooserUI.this.getFileChooser();
            String filename = BasicFileChooserUI.this.getFileName();
            FileSystemView fs = chooser.getFileSystemView();
            File dir2 = chooser.getCurrentDirectory();
            if (filename != null) {
                filename = filename.trim();
            }
            if (filename == null || filename.equals("")) {
                BasicFileChooserUI.this.resetGlobFilter();
                return;
            }
            File selectedFile = null;
            File[] selectedFiles = null;
            if (filename != null && !filename.equals("")) {
                if (File.separatorChar == '/') {
                    if (filename.startsWith("~/")) {
                        filename = System.getProperty("user.home") + filename.substring(1);
                    } else if (filename.equals("~")) {
                        filename = System.getProperty("user.home");
                    }
                }
                if (chooser.isMultiSelectionEnabled() && filename.startsWith("\"")) {
                    ArrayList<File> fList = new ArrayList<File>();
                    if ((filename = filename.substring(1)).endsWith("\"")) {
                        filename = filename.substring(0, filename.length() - 1);
                    }
                    Object[] children = null;
                    int childIndex = 0;
                    do {
                        String str;
                        int i;
                        if ((i = filename.indexOf("\" \"")) > 0) {
                            str = filename.substring(0, i);
                            filename = filename.substring(i + 3);
                        } else {
                            str = filename;
                            filename = "";
                        }
                        Object file = fs.createFileObject(str);
                        if (!((File)file).isAbsolute()) {
                            if (children == null) {
                                children = fs.getFiles(dir2, false);
                                Arrays.sort(children);
                            }
                            for (int k = 0; k < children.length; ++k) {
                                int l = (childIndex + k) % children.length;
                                if (!((File)children[l]).getName().equals(str)) continue;
                                file = children[l];
                                childIndex = l + 1;
                                break;
                            }
                        }
                        fList.add((File)file);
                    } while (filename.length() > 0);
                    if (fList.size() > 0) {
                        selectedFiles = fList.toArray(new File[fList.size()]);
                    }
                    BasicFileChooserUI.this.resetGlobFilter();
                } else {
                    boolean isCtrl;
                    selectedFile = fs.createFileObject(filename);
                    if (!selectedFile.isAbsolute()) {
                        selectedFile = fs.getChild(dir2, filename);
                    }
                    FileFilter currentFilter = chooser.getFileFilter();
                    if (!selectedFile.exists() && BasicFileChooserUI.isGlobPattern(filename)) {
                        BasicFileChooserUI.this.changeDirectory(selectedFile.getParentFile());
                        if (BasicFileChooserUI.this.globFilter == null) {
                            BasicFileChooserUI.this.globFilter = new GlobFilter();
                        }
                        try {
                            BasicFileChooserUI.this.globFilter.setPattern(selectedFile.getName());
                            if (!(currentFilter instanceof GlobFilter)) {
                                BasicFileChooserUI.this.actualFileFilter = currentFilter;
                            }
                            chooser.setFileFilter(null);
                            chooser.setFileFilter(BasicFileChooserUI.this.globFilter);
                            return;
                        }
                        catch (PatternSyntaxException pse) {
                            // empty catch block
                        }
                    }
                    BasicFileChooserUI.this.resetGlobFilter();
                    boolean isDir = selectedFile != null && selectedFile.isDirectory();
                    boolean isTrav = selectedFile != null && chooser.isTraversable(selectedFile);
                    boolean isDirSelEnabled = chooser.isDirectorySelectionEnabled();
                    boolean isFileSelEnabled = chooser.isFileSelectionEnabled();
                    boolean bl = isCtrl = e != null && (e.getModifiers() & 2) != 0;
                    if (isDir && isTrav && (isCtrl || !isDirSelEnabled)) {
                        BasicFileChooserUI.this.changeDirectory(selectedFile);
                        return;
                    }
                    if (!(!isDir && isFileSelEnabled || isDir && isDirSelEnabled || isDirSelEnabled && !selectedFile.exists())) {
                        selectedFile = null;
                    }
                }
            }
            if (selectedFiles != null || selectedFile != null) {
                if (selectedFiles != null || chooser.isMultiSelectionEnabled()) {
                    if (selectedFiles == null) {
                        selectedFiles = new File[]{selectedFile};
                    }
                    chooser.setSelectedFiles(selectedFiles);
                    chooser.setSelectedFiles(selectedFiles);
                } else {
                    chooser.setSelectedFile(selectedFile);
                }
                chooser.approveSelection();
            } else {
                if (chooser.isMultiSelectionEnabled()) {
                    chooser.setSelectedFiles(null);
                } else {
                    chooser.setSelectedFile(null);
                }
                chooser.cancelSelection();
            }
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction() {
            super("Go Up");
            this.putValue("ActionCommandKey", "Go Up");
        }

        public void actionPerformed(ActionEvent e) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner == null || !(focusOwner instanceof JTextComponent)) {
                BasicFileChooserUI.this.getFileChooser().changeToParentDirectory();
            }
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction() {
            super("Go Home");
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = BasicFileChooserUI.this.getFileChooser();
            BasicFileChooserUI.this.changeDirectory(fc.getFileSystemView().getHomeDirectory());
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent e) {
            if (BasicFileChooserUI.this.readOnly) {
                return;
            }
            JFileChooser fc = BasicFileChooserUI.this.getFileChooser();
            File currentDirectory = fc.getCurrentDirectory();
            File newFolder = null;
            try {
                newFolder = fc.getFileSystemView().createNewFolder(currentDirectory);
                if (fc.isMultiSelectionEnabled()) {
                    fc.setSelectedFiles(new File[]{newFolder});
                } else {
                    fc.setSelectedFile(newFolder);
                }
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(fc, BasicFileChooserUI.this.newFolderErrorText + BasicFileChooserUI.this.newFolderErrorSeparator + exc, BasicFileChooserUI.this.newFolderErrorText, 0);
                return;
            }
            fc.rescanCurrentDirectory();
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            BasicFileChooserUI.this.getHandler().valueChanged(e);
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        Handler handler;

        public DoubleClickListener(JList list) {
            this.handler = new Handler(list);
        }

        public void mouseEntered(MouseEvent e) {
            this.handler.mouseEntered(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.handler.mouseClicked(e);
        }
    }

    private class Handler
    implements MouseListener,
    ListSelectionListener {
        JList list;

        Handler() {
        }

        Handler(JList list) {
            this.list = list;
        }

        public void mouseClicked(MouseEvent evt) {
            int index;
            if (this.list != null && SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() % 2 == 0 && (index = SwingUtilities2.loc2IndexFileList(this.list, evt.getPoint())) >= 0) {
                File f = (File)this.list.getModel().getElementAt(index);
                try {
                    f = ShellFolder.getNormalizedFile(f);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (BasicFileChooserUI.this.getFileChooser().isTraversable(f)) {
                    this.list.clearSelection();
                    BasicFileChooserUI.this.changeDirectory(f);
                } else {
                    BasicFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        }

        public void mouseEntered(MouseEvent evt) {
            if (this.list != null) {
                TransferHandler th2;
                TransferHandler th1 = BasicFileChooserUI.this.getFileChooser().getTransferHandler();
                if (th1 != (th2 = this.list.getTransferHandler())) {
                    this.list.setTransferHandler(th1);
                }
                if (BasicFileChooserUI.this.getFileChooser().getDragEnabled() != this.list.getDragEnabled()) {
                    this.list.setDragEnabled(BasicFileChooserUI.this.getFileChooser().getDragEnabled());
                }
            }
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void valueChanged(ListSelectionEvent evt) {
            if (!evt.getValueIsAdjusting()) {
                boolean useSetDirectory;
                JFileChooser chooser = BasicFileChooserUI.this.getFileChooser();
                FileSystemView fsv = chooser.getFileSystemView();
                JList list = (JList)evt.getSource();
                int fsm = chooser.getFileSelectionMode();
                boolean bl = useSetDirectory = BasicFileChooserUI.this.usesSingleFilePane && fsm == 0;
                if (chooser.isMultiSelectionEnabled()) {
                    File[] files = null;
                    Object[] objects = list.getSelectedValues();
                    if (objects != null) {
                        if (objects.length == 1 && ((File)objects[0]).isDirectory() && chooser.isTraversable((File)objects[0]) && (useSetDirectory || !fsv.isFileSystem((File)objects[0]))) {
                            BasicFileChooserUI.this.setDirectorySelected(true);
                            BasicFileChooserUI.this.setDirectory((File)objects[0]);
                        } else {
                            ArrayList<File> fList = new ArrayList<File>(objects.length);
                            for (int i = 0; i < objects.length; ++i) {
                                File f = (File)objects[i];
                                boolean isDir = f.isDirectory();
                                if ((!chooser.isFileSelectionEnabled() || isDir) && (!chooser.isDirectorySelectionEnabled() || !fsv.isFileSystem(f) || !isDir)) continue;
                                fList.add(f);
                            }
                            if (fList.size() > 0) {
                                files = fList.toArray(new File[fList.size()]);
                            }
                            BasicFileChooserUI.this.setDirectorySelected(false);
                        }
                    }
                    chooser.setSelectedFiles(files);
                } else {
                    File file = (File)list.getSelectedValue();
                    if (file != null && file.isDirectory() && chooser.isTraversable(file) && (useSetDirectory || !fsv.isFileSystem(file))) {
                        BasicFileChooserUI.this.setDirectorySelected(true);
                        BasicFileChooserUI.this.setDirectory(file);
                        if (BasicFileChooserUI.this.usesSingleFilePane) {
                            chooser.setSelectedFile(null);
                        }
                    } else {
                        BasicFileChooserUI.this.setDirectorySelected(false);
                        if (file != null) {
                            chooser.setSelectedFile(file);
                        }
                    }
                }
            }
        }
    }
}

