/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class BasicComboBoxEditor
implements ComboBoxEditor,
FocusListener {
    protected JTextField editor = this.createEditorComponent();
    private Object oldValue;

    public Component getEditorComponent() {
        return this.editor;
    }

    protected JTextField createEditorComponent() {
        BorderlessTextField editor = new BorderlessTextField("", 9);
        ((JComponent)editor).setBorder(null);
        return editor;
    }

    public void setItem(Object anObject) {
        if (anObject != null) {
            this.editor.setText(anObject.toString());
            this.oldValue = anObject;
        } else {
            this.editor.setText("");
        }
    }

    public Object getItem() {
        Object newValue = this.editor.getText();
        if (this.oldValue != null && !(this.oldValue instanceof String)) {
            if (newValue.equals(this.oldValue.toString())) {
                return this.oldValue;
            }
            Class<?> cls = this.oldValue.getClass();
            try {
                Method method = cls.getMethod("valueOf", String.class);
                newValue = method.invoke(this.oldValue, this.editor.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newValue;
    }

    public void selectAll() {
        this.editor.selectAll();
        this.editor.requestFocus();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void addActionListener(ActionListener l) {
        this.editor.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.editor.removeActionListener(l);
    }

    public static class UIResource
    extends BasicComboBoxEditor
    implements javax.swing.plaf.UIResource {
    }

    static class BorderlessTextField
    extends JTextField {
        public BorderlessTextField(String value, int n) {
            super(value, n);
        }

        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }

        public void setBorder(Border b) {
            if (!(b instanceof UIResource)) {
                super.setBorder(b);
            }
        }
    }
}

