/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import javax.swing.AbstractSpinnerModel;

public class SpinnerNumberModel
extends AbstractSpinnerModel
implements Serializable {
    private Number stepSize;
    private Number value;
    private Comparable minimum;
    private Comparable maximum;

    public SpinnerNumberModel(Number value, Comparable minimum, Comparable maximum, Number stepSize) {
        if (value == null || stepSize == null) {
            throw new IllegalArgumentException("value and stepSize must be non-null");
        }
        if (minimum != null && minimum.compareTo(value) > 0 || maximum != null && maximum.compareTo(value) < 0) {
            throw new IllegalArgumentException("(minimum <= value <= maximum) is false");
        }
        this.value = value;
        this.minimum = minimum;
        this.maximum = maximum;
        this.stepSize = stepSize;
    }

    public SpinnerNumberModel(int value, int minimum, int maximum, int stepSize) {
        this(new Integer(value), new Integer(minimum), new Integer(maximum), new Integer(stepSize));
    }

    public SpinnerNumberModel(double value, double minimum, double maximum, double stepSize) {
        this(new Double(value), new Double(minimum), new Double(maximum), new Double(stepSize));
    }

    public SpinnerNumberModel() {
        this(new Integer(0), null, null, new Integer(1));
    }

    public void setMinimum(Comparable minimum) {
        if (minimum == null ? this.minimum != null : !minimum.equals(this.minimum)) {
            this.minimum = minimum;
            this.fireStateChanged();
        }
    }

    public Comparable getMinimum() {
        return this.minimum;
    }

    public void setMaximum(Comparable maximum) {
        if (maximum == null ? this.maximum != null : !maximum.equals(this.maximum)) {
            this.maximum = maximum;
            this.fireStateChanged();
        }
    }

    public Comparable getMaximum() {
        return this.maximum;
    }

    public void setStepSize(Number stepSize) {
        if (stepSize == null) {
            throw new IllegalArgumentException("null stepSize");
        }
        if (!stepSize.equals(this.stepSize)) {
            this.stepSize = stepSize;
            this.fireStateChanged();
        }
    }

    public Number getStepSize() {
        return this.stepSize;
    }

    private Number incrValue(int dir) {
        Number newValue;
        if (this.value instanceof Float || this.value instanceof Double) {
            double v = this.value.doubleValue() + this.stepSize.doubleValue() * (double)dir;
            newValue = this.value instanceof Double ? (Number)new Double(v) : (Number)new Float(v);
        } else {
            long v = this.value.longValue() + this.stepSize.longValue() * (long)dir;
            newValue = this.value instanceof Long ? (Number)new Long(v) : (Number)(this.value instanceof Integer ? (Number)new Integer((int)v) : (Number)(this.value instanceof Short ? (Number)new Short((short)v) : (Number)new Byte((byte)v)));
        }
        if (this.maximum != null && this.maximum.compareTo(newValue) < 0) {
            return null;
        }
        if (this.minimum != null && this.minimum.compareTo(newValue) > 0) {
            return null;
        }
        return newValue;
    }

    public Object getNextValue() {
        return this.incrValue(1);
    }

    public Object getPreviousValue() {
        return this.incrValue(-1);
    }

    public Number getNumber() {
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (value == null || !(value instanceof Number)) {
            throw new IllegalArgumentException("illegal value");
        }
        if (!value.equals(this.value)) {
            this.value = (Number)value;
            this.fireStateChanged();
        }
    }
}

