/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class ShortMessage
extends MidiMessage {
    public static final int MIDI_TIME_CODE = 241;
    public static final int SONG_POSITION_POINTER = 242;
    public static final int SONG_SELECT = 243;
    public static final int TUNE_REQUEST = 246;
    public static final int END_OF_EXCLUSIVE = 247;
    public static final int TIMING_CLOCK = 248;
    public static final int START = 250;
    public static final int CONTINUE = 251;
    public static final int STOP = 252;
    public static final int ACTIVE_SENSING = 254;
    public static final int SYSTEM_RESET = 255;
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLY_PRESSURE = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;

    public ShortMessage() {
        this(new byte[3]);
        this.data[0] = -112;
        this.data[1] = 64;
        this.data[2] = 127;
        this.length = 3;
    }

    protected ShortMessage(byte[] data) {
        super(data);
    }

    public void setMessage(int status) throws InvalidMidiDataException {
        int dataLength = this.getDataLength(status);
        if (dataLength != 0) {
            throw new InvalidMidiDataException("Status byte; " + status + " requires " + dataLength + " data bytes");
        }
        this.setMessage(status, 0, 0);
    }

    public void setMessage(int status, int data1, int data2) throws InvalidMidiDataException {
        int dataLength = this.getDataLength(status);
        if (dataLength > 0) {
            if (data1 < 0 || data1 > 127) {
                throw new InvalidMidiDataException("data1 out of range: " + data1);
            }
            if (dataLength > 1 && (data2 < 0 || data2 > 127)) {
                throw new InvalidMidiDataException("data2 out of range: " + data2);
            }
        }
        this.length = dataLength + 1;
        if (this.data == null || this.data.length < this.length) {
            this.data = new byte[3];
        }
        this.data[0] = (byte)(status & 0xFF);
        if (this.length > 1) {
            this.data[1] = (byte)(data1 & 0xFF);
            if (this.length > 2) {
                this.data[2] = (byte)(data2 & 0xFF);
            }
        }
    }

    public void setMessage(int command, int channel, int data1, int data2) throws InvalidMidiDataException {
        if (command >= 240 || command < 128) {
            throw new InvalidMidiDataException("command out of range: 0x" + Integer.toHexString(command));
        }
        if ((channel & 0xFFFFFFF0) != 0) {
            throw new InvalidMidiDataException("channel out of range: " + channel);
        }
        this.setMessage(command & 0xF0 | channel & 0xF, data1, data2);
    }

    public int getChannel() {
        return this.getStatus() & 0xF;
    }

    public int getCommand() {
        return this.getStatus() & 0xF0;
    }

    public int getData1() {
        if (this.length > 1) {
            return this.data[1] & 0xFF;
        }
        return 0;
    }

    public int getData2() {
        if (this.length > 2) {
            return this.data[2] & 0xFF;
        }
        return 0;
    }

    public Object clone() {
        byte[] newData = new byte[this.length];
        System.arraycopy(this.data, 0, newData, 0, newData.length);
        ShortMessage msg = new ShortMessage(newData);
        return msg;
    }

    protected final int getDataLength(int status) throws InvalidMidiDataException {
        switch (status) {
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return 0;
            }
            case 241: 
            case 243: {
                return 1;
            }
            case 242: {
                return 2;
            }
        }
        switch (status & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        throw new InvalidMidiDataException("Invalid status byte: " + status);
    }
}

