/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.Attribute;
import javax.management.RuntimeOperationsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeList
extends ArrayList<Object> {
    private transient boolean typeSafe;
    private transient boolean tainted;
    private static final long serialVersionUID = -4077085769279709076L;

    public AttributeList() {
    }

    public AttributeList(int initialCapacity) {
        super(initialCapacity);
    }

    public AttributeList(AttributeList list) {
        super(list);
    }

    public AttributeList(List<Attribute> list) {
        if (list == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        AttributeList.checkTypeSafe(list);
        super.addAll(list);
    }

    public List<Attribute> asList() {
        if (!this.typeSafe) {
            if (this.tainted) {
                AttributeList.checkTypeSafe(this);
            }
            this.typeSafe = true;
        }
        return this;
    }

    public void add(Attribute object) {
        super.add(object);
    }

    @Override
    public void add(int index, Attribute object) {
        try {
            super.add(index, object);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeOperationsException(e, "The specified index is out of range");
        }
    }

    @Override
    public void set(int index, Attribute object) {
        try {
            super.set(index, object);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeOperationsException(e, "The specified index is out of range");
        }
    }

    public boolean addAll(AttributeList list) {
        return super.addAll(list);
    }

    public boolean addAll(int index, AttributeList list) {
        try {
            return super.addAll(index, list);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeOperationsException(e, "The specified index is out of range");
        }
    }

    @Override
    public boolean add(Object o) {
        if (!this.tainted) {
            this.tainted = AttributeList.isTainted(o);
        }
        if (this.typeSafe) {
            AttributeList.checkTypeSafe(o);
        }
        return super.add(o);
    }

    @Override
    public void add(int index, Object element) {
        if (!this.tainted) {
            this.tainted = AttributeList.isTainted(element);
        }
        if (this.typeSafe) {
            AttributeList.checkTypeSafe(element);
        }
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<?> c) {
        if (!this.tainted) {
            this.tainted = AttributeList.isTainted(c);
        }
        if (this.typeSafe) {
            AttributeList.checkTypeSafe(c);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        if (!this.tainted) {
            this.tainted = AttributeList.isTainted(c);
        }
        if (this.typeSafe) {
            AttributeList.checkTypeSafe(c);
        }
        return super.addAll(index, c);
    }

    @Override
    public Object set(int index, Object element) {
        if (!this.tainted) {
            this.tainted = AttributeList.isTainted(element);
        }
        if (this.typeSafe) {
            AttributeList.checkTypeSafe(element);
        }
        return super.set(index, element);
    }

    private static void checkTypeSafe(Object o) {
        try {
            o = (Attribute)o;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void checkTypeSafe(Collection<?> c) {
        try {
            for (Object o : c) {
                Attribute a = (Attribute)o;
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static boolean isTainted(Object o) {
        try {
            AttributeList.checkTypeSafe(o);
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        return false;
    }

    private static boolean isTainted(Collection<?> c) {
        try {
            AttributeList.checkTypeSafe(c);
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        return false;
    }
}

