/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.Arrays;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicReferenceArray<E>
implements Serializable {
    private static final long serialVersionUID = -6209656149925076980L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(Object[].class);
    private static final int scale = unsafe.arrayIndexScale(Object[].class);
    private final Object[] array;

    private long rawIndex(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + i);
        }
        return (long)base + (long)i * (long)scale;
    }

    public AtomicReferenceArray(int length) {
        this.array = new Object[length];
        if (length > 0) {
            unsafe.putObjectVolatile(this.array, this.rawIndex(0), null);
        }
    }

    public AtomicReferenceArray(E[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        int length = array.length;
        this.array = new Object[length];
        if (length > 0) {
            int last = length - 1;
            for (int i = 0; i < last; ++i) {
                this.array[i] = array[i];
            }
            E e = array[last];
            unsafe.putObjectVolatile(this.array, this.rawIndex(last), e);
        }
    }

    public final int length() {
        return this.array.length;
    }

    public final E get(int i) {
        return (E)unsafe.getObjectVolatile(this.array, this.rawIndex(i));
    }

    public final void set(int i, E newValue) {
        unsafe.putObjectVolatile(this.array, this.rawIndex(i), newValue);
    }

    public final void lazySet(int i, E newValue) {
        unsafe.putOrderedObject(this.array, this.rawIndex(i), newValue);
    }

    public final E getAndSet(int i, E newValue) {
        E current;
        while (!this.compareAndSet(i, current = this.get(i), newValue)) {
        }
        return current;
    }

    public final boolean compareAndSet(int i, E expect, E update) {
        return unsafe.compareAndSwapObject(this.array, this.rawIndex(i), expect, update);
    }

    public final boolean weakCompareAndSet(int i, E expect, E update) {
        return this.compareAndSet(i, expect, update);
    }

    public String toString() {
        if (this.array.length > 0) {
            this.get(0);
        }
        return Arrays.toString(this.array);
    }
}

