/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.Arrays;
import sun.misc.Unsafe;

public class AtomicIntegerArray
implements Serializable {
    private static final long serialVersionUID = 2862133569453604235L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(int[].class);
    private static final int scale = unsafe.arrayIndexScale(int[].class);
    private final int[] array;

    private long rawIndex(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + i);
        }
        return (long)base + (long)i * (long)scale;
    }

    public AtomicIntegerArray(int length) {
        this.array = new int[length];
        if (length > 0) {
            unsafe.putIntVolatile(this.array, this.rawIndex(0), 0);
        }
    }

    public AtomicIntegerArray(int[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        int length = array.length;
        this.array = new int[length];
        if (length > 0) {
            int last = length - 1;
            for (int i = 0; i < last; ++i) {
                this.array[i] = array[i];
            }
            unsafe.putIntVolatile(this.array, this.rawIndex(last), array[last]);
        }
    }

    public final int length() {
        return this.array.length;
    }

    public final int get(int i) {
        return unsafe.getIntVolatile(this.array, this.rawIndex(i));
    }

    public final void set(int i, int newValue) {
        unsafe.putIntVolatile(this.array, this.rawIndex(i), newValue);
    }

    public final void lazySet(int i, int newValue) {
        unsafe.putOrderedInt(this.array, this.rawIndex(i), newValue);
    }

    public final int getAndSet(int i, int newValue) {
        int current;
        while (!this.compareAndSet(i, current = this.get(i), newValue)) {
        }
        return current;
    }

    public final boolean compareAndSet(int i, int expect, int update) {
        return unsafe.compareAndSwapInt(this.array, this.rawIndex(i), expect, update);
    }

    public final boolean weakCompareAndSet(int i, int expect, int update) {
        return this.compareAndSet(i, expect, update);
    }

    public final int getAndIncrement(int i) {
        int next;
        int current;
        while (!this.compareAndSet(i, current = this.get(i), next = current + 1)) {
        }
        return current;
    }

    public final int getAndDecrement(int i) {
        int next;
        int current;
        while (!this.compareAndSet(i, current = this.get(i), next = current - 1)) {
        }
        return current;
    }

    public final int getAndAdd(int i, int delta) {
        int next;
        int current;
        while (!this.compareAndSet(i, current = this.get(i), next = current + delta)) {
        }
        return current;
    }

    public final int incrementAndGet(int i) {
        int next;
        int current;
        while (!this.compareAndSet(i, current = this.get(i), next = current + 1)) {
        }
        return next;
    }

    public final int decrementAndGet(int i) {
        int next;
        int current;
        while (!this.compareAndSet(i, current = this.get(i), next = current - 1)) {
        }
        return next;
    }

    public final int addAndGet(int i, int delta) {
        int next;
        int current;
        while (!this.compareAndSet(i, current = this.get(i), next = current + delta)) {
        }
        return next;
    }

    public String toString() {
        if (this.array.length > 0) {
            this.get(0);
        }
        return Arrays.toString(this.array);
    }
}

