/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class InetSocketAddress
extends SocketAddress {
    private String hostname = null;
    private InetAddress addr = null;
    private int port;
    private static final long serialVersionUID = 5076001401234631237L;

    private InetSocketAddress() {
    }

    public InetSocketAddress(int port) {
        this(InetAddress.anyLocalAddress(), port);
    }

    public InetSocketAddress(InetAddress addr, int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        this.port = port;
        this.addr = addr == null ? InetAddress.anyLocalAddress() : addr;
    }

    public InetSocketAddress(String hostname, int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        if (hostname == null) {
            throw new IllegalArgumentException("hostname can't be null");
        }
        try {
            this.addr = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            this.hostname = hostname;
            this.addr = null;
        }
        this.port = port;
    }

    public static InetSocketAddress createUnresolved(String host, int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        if (host == null) {
            throw new IllegalArgumentException("hostname can't be null");
        }
        InetSocketAddress s = new InetSocketAddress();
        s.port = port;
        s.hostname = host;
        s.addr = null;
        return s;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.port < 0 || this.port > 65535) {
            throw new InvalidObjectException("port out of range:" + this.port);
        }
        if (this.hostname == null && this.addr == null) {
            throw new InvalidObjectException("hostname and addr can't both be null");
        }
    }

    public final int getPort() {
        return this.port;
    }

    public final InetAddress getAddress() {
        return this.addr;
    }

    public final String getHostName() {
        if (this.hostname != null) {
            return this.hostname;
        }
        if (this.addr != null) {
            return this.addr.getHostName();
        }
        return null;
    }

    final String getHostString() {
        if (this.hostname != null) {
            return this.hostname;
        }
        if (this.addr != null) {
            if (this.addr.hostName != null) {
                return this.addr.hostName;
            }
            return this.addr.getHostAddress();
        }
        return null;
    }

    public final boolean isUnresolved() {
        return this.addr == null;
    }

    public String toString() {
        if (this.isUnresolved()) {
            return this.hostname + ":" + this.port;
        }
        return this.addr.toString() + ":" + this.port;
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof InetSocketAddress)) {
            return false;
        }
        InetSocketAddress sockAddr = (InetSocketAddress)obj;
        boolean sameIP = false;
        sameIP = this.addr != null ? this.addr.equals(sockAddr.addr) : (this.hostname != null ? sockAddr.addr == null && this.hostname.equals(sockAddr.hostname) : sockAddr.addr == null && sockAddr.hostname == null);
        return sameIP && this.port == sockAddr.port;
    }

    public final int hashCode() {
        if (this.addr != null) {
            return this.addr.hashCode() + this.port;
        }
        if (this.hostname != null) {
            return this.hostname.hashCode() + this.port;
        }
        return this.port;
    }
}

