/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.SignedMutableBigInteger;

class MutableBigInteger {
    int[] value;
    int intLen;
    int offset = 0;
    private static final long LONG_MASK = 0xFFFFFFFFL;

    MutableBigInteger() {
        this.value = new int[1];
        this.intLen = 0;
    }

    MutableBigInteger(int val) {
        this.value = new int[1];
        this.intLen = 1;
        this.value[0] = val;
    }

    MutableBigInteger(int[] val, int len) {
        this.value = val;
        this.intLen = len;
    }

    MutableBigInteger(int[] val) {
        this.value = val;
        this.intLen = val.length;
    }

    MutableBigInteger(BigInteger b) {
        this.value = (int[])b.mag.clone();
        this.intLen = this.value.length;
    }

    MutableBigInteger(MutableBigInteger val) {
        this.intLen = val.intLen;
        this.value = new int[this.intLen];
        for (int i = 0; i < this.intLen; ++i) {
            this.value[i] = val.value[val.offset + i];
        }
    }

    void clear() {
        this.intLen = 0;
        this.offset = 0;
        int n = this.value.length;
        for (int index = 0; index < n; ++index) {
            this.value[index] = 0;
        }
    }

    void reset() {
        this.intLen = 0;
        this.offset = 0;
    }

    final int compare(MutableBigInteger b) {
        if (this.intLen < b.intLen) {
            return -1;
        }
        if (this.intLen > b.intLen) {
            return 1;
        }
        for (int i = 0; i < this.intLen; ++i) {
            int b1 = this.value[this.offset + i] + Integer.MIN_VALUE;
            int b2 = b.value[b.offset + i] + Integer.MIN_VALUE;
            if (b1 < b2) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        return 0;
    }

    private final int getLowestSetBit() {
        int j;
        if (this.intLen == 0) {
            return -1;
        }
        for (j = this.intLen - 1; j > 0 && this.value[j + this.offset] == 0; --j) {
        }
        int b = this.value[j + this.offset];
        if (b == 0) {
            return -1;
        }
        return (this.intLen - 1 - j << 5) + BigInteger.trailingZeroCnt(b);
    }

    private final int getInt(int index) {
        return this.value[this.offset + index];
    }

    private final long getLong(int index) {
        return (long)this.value[this.offset + index] & 0xFFFFFFFFL;
    }

    final void normalize() {
        if (this.intLen == 0) {
            this.offset = 0;
            return;
        }
        int index = this.offset;
        if (this.value[index] != 0) {
            return;
        }
        int indexBound = index + this.intLen;
        while (++index < indexBound && this.value[index] == 0) {
        }
        int numZeros = index - this.offset;
        this.intLen -= numZeros;
        this.offset = this.intLen == 0 ? 0 : this.offset + numZeros;
    }

    private final void ensureCapacity(int len) {
        if (this.value.length < len) {
            this.value = new int[len];
            this.offset = 0;
            this.intLen = len;
        }
    }

    int[] toIntArray() {
        int[] result = new int[this.intLen];
        for (int i = 0; i < this.intLen; ++i) {
            result[i] = this.value[this.offset + i];
        }
        return result;
    }

    void setInt(int index, int val) {
        this.value[this.offset + index] = val;
    }

    void setValue(int[] val, int length) {
        this.value = val;
        this.intLen = length;
        this.offset = 0;
    }

    void copyValue(MutableBigInteger val) {
        int len = val.intLen;
        if (this.value.length < len) {
            this.value = new int[len];
        }
        for (int i = 0; i < len; ++i) {
            this.value[i] = val.value[val.offset + i];
        }
        this.intLen = len;
        this.offset = 0;
    }

    void copyValue(int[] val) {
        int len = val.length;
        if (this.value.length < len) {
            this.value = new int[len];
        }
        for (int i = 0; i < len; ++i) {
            this.value[i] = val[i];
        }
        this.intLen = len;
        this.offset = 0;
    }

    boolean isOne() {
        return this.intLen == 1 && this.value[this.offset] == 1;
    }

    boolean isZero() {
        return this.intLen == 0;
    }

    boolean isEven() {
        return this.intLen == 0 || (this.value[this.offset + this.intLen - 1] & 1) == 0;
    }

    boolean isOdd() {
        return (this.value[this.offset + this.intLen - 1] & 1) == 1;
    }

    boolean isNormal() {
        if (this.intLen + this.offset > this.value.length) {
            return false;
        }
        if (this.intLen == 0) {
            return true;
        }
        return this.value[this.offset] != 0;
    }

    public String toString() {
        BigInteger b = new BigInteger(this, 1);
        return b.toString();
    }

    void rightShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        this.intLen -= nInts;
        if (nBits == 0) {
            return;
        }
        int bitsInHighWord = BigInteger.bitLen(this.value[this.offset]);
        if (nBits >= bitsInHighWord) {
            this.primitiveLeftShift(32 - nBits);
            --this.intLen;
        } else {
            this.primitiveRightShift(nBits);
        }
    }

    void leftShift(int n) {
        if (this.intLen == 0) {
            return;
        }
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int bitsInHighWord = BigInteger.bitLen(this.value[this.offset]);
        if (n <= 32 - bitsInHighWord) {
            this.primitiveLeftShift(nBits);
            return;
        }
        int newLen = this.intLen + nInts + 1;
        if (nBits <= 32 - bitsInHighWord) {
            --newLen;
        }
        if (this.value.length < newLen) {
            int[] result = new int[newLen];
            for (int i = 0; i < this.intLen; ++i) {
                result[i] = this.value[this.offset + i];
            }
            this.setValue(result, newLen);
        } else if (this.value.length - this.offset >= newLen) {
            for (int i = 0; i < newLen - this.intLen; ++i) {
                this.value[this.offset + this.intLen + i] = 0;
            }
        } else {
            int i;
            for (i = 0; i < this.intLen; ++i) {
                this.value[i] = this.value[this.offset + i];
            }
            for (i = this.intLen; i < newLen; ++i) {
                this.value[i] = 0;
            }
            this.offset = 0;
        }
        this.intLen = newLen;
        if (nBits == 0) {
            return;
        }
        if (nBits <= 32 - bitsInHighWord) {
            this.primitiveLeftShift(nBits);
        } else {
            this.primitiveRightShift(32 - nBits);
        }
    }

    private int divadd(int[] a, int[] result, int offset) {
        long carry = 0L;
        for (int j = a.length - 1; j >= 0; --j) {
            long sum = ((long)a[j] & 0xFFFFFFFFL) + ((long)result[j + offset] & 0xFFFFFFFFL) + carry;
            result[j + offset] = (int)sum;
            carry = sum >>> 32;
        }
        return (int)carry;
    }

    private int mulsub(int[] q, int[] a, int x, int len, int offset) {
        long xLong = (long)x & 0xFFFFFFFFL;
        long carry = 0L;
        offset += len;
        for (int j = len - 1; j >= 0; --j) {
            long product = ((long)a[j] & 0xFFFFFFFFL) * xLong + carry;
            long difference = (long)q[offset] - product;
            q[offset--] = (int)difference;
            carry = (product >>> 32) + (long)((difference & 0xFFFFFFFFL) > ((long)(~((int)product)) & 0xFFFFFFFFL) ? 1 : 0);
        }
        return (int)carry;
    }

    private final void primitiveRightShift(int n) {
        int i;
        int[] val = this.value;
        int n2 = 32 - n;
        int c = val[i];
        for (i = this.offset + this.intLen - 1; i > this.offset; --i) {
            int b = c;
            c = val[i - 1];
            val[i] = c << n2 | b >>> n;
        }
        int n3 = this.offset;
        val[n3] = val[n3] >>> n;
    }

    private final void primitiveLeftShift(int n) {
        int i;
        int[] val = this.value;
        int n2 = 32 - n;
        int c = val[i];
        int m = i + this.intLen - 1;
        for (i = this.offset; i < m; ++i) {
            int b = c;
            c = val[i + 1];
            val[i] = b << n | c >>> n2;
        }
        int n3 = this.offset + this.intLen - 1;
        val[n3] = val[n3] << n;
    }

    void add(MutableBigInteger addend) {
        int x = this.intLen;
        int y = addend.intLen;
        int resultLen = this.intLen > addend.intLen ? this.intLen : addend.intLen;
        int[] result = this.value.length < resultLen ? new int[resultLen] : this.value;
        int rstart = result.length - 1;
        long sum = 0L;
        while (x > 0 && y > 0) {
            sum = ((long)this.value[--x + this.offset] & 0xFFFFFFFFL) + ((long)addend.value[--y + addend.offset] & 0xFFFFFFFFL) + (sum >>> 32);
            result[rstart--] = (int)sum;
        }
        while (x > 0) {
            sum = ((long)this.value[--x + this.offset] & 0xFFFFFFFFL) + (sum >>> 32);
            result[rstart--] = (int)sum;
        }
        while (y > 0) {
            sum = ((long)addend.value[--y + addend.offset] & 0xFFFFFFFFL) + (sum >>> 32);
            result[rstart--] = (int)sum;
        }
        if (sum >>> 32 > 0L) {
            if (result.length < ++resultLen) {
                int[] temp = new int[resultLen];
                for (int i = resultLen - 1; i > 0; --i) {
                    temp[i] = result[i - 1];
                }
                temp[0] = 1;
                result = temp;
            } else {
                result[rstart--] = 1;
            }
        }
        this.value = result;
        this.intLen = resultLen;
        this.offset = result.length - resultLen;
    }

    int subtract(MutableBigInteger b) {
        int resultLen;
        MutableBigInteger a = this;
        int[] result = this.value;
        int sign = a.compare(b);
        if (sign == 0) {
            this.reset();
            return 0;
        }
        if (sign < 0) {
            MutableBigInteger tmp = a;
            a = b;
            b = tmp;
        }
        if (result.length < (resultLen = a.intLen)) {
            result = new int[resultLen];
        }
        long diff = 0L;
        int x = a.intLen;
        int y = b.intLen;
        int rstart = result.length - 1;
        while (y > 0) {
            diff = ((long)a.value[--x + a.offset] & 0xFFFFFFFFL) - ((long)b.value[--y + b.offset] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            result[rstart--] = (int)diff;
        }
        while (x > 0) {
            diff = ((long)a.value[--x + a.offset] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            result[rstart--] = (int)diff;
        }
        this.value = result;
        this.intLen = resultLen;
        this.offset = this.value.length - resultLen;
        this.normalize();
        return sign;
    }

    private int difference(MutableBigInteger b) {
        MutableBigInteger a = this;
        int sign = a.compare(b);
        if (sign == 0) {
            return 0;
        }
        if (sign < 0) {
            MutableBigInteger tmp = a;
            a = b;
            b = tmp;
        }
        long diff = 0L;
        int x = a.intLen;
        int y = b.intLen;
        while (y > 0) {
            diff = ((long)a.value[a.offset + --x] & 0xFFFFFFFFL) - ((long)b.value[b.offset + --y] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            a.value[a.offset + x] = (int)diff;
        }
        while (x > 0) {
            diff = ((long)a.value[a.offset + --x] & 0xFFFFFFFFL) - (long)((int)(-(diff >> 32)));
            a.value[a.offset + x] = (int)diff;
        }
        a.normalize();
        return sign;
    }

    void multiply(MutableBigInteger y, MutableBigInteger z) {
        int xLen = this.intLen;
        int yLen = y.intLen;
        int newLen = xLen + yLen;
        if (z.value.length < newLen) {
            z.value = new int[newLen];
        }
        z.offset = 0;
        z.intLen = newLen;
        long carry = 0L;
        int j = yLen - 1;
        int k = yLen + xLen - 1;
        while (j >= 0) {
            long product = ((long)y.value[j + y.offset] & 0xFFFFFFFFL) * ((long)this.value[xLen - 1 + this.offset] & 0xFFFFFFFFL) + carry;
            z.value[k] = (int)product;
            carry = product >>> 32;
            --j;
            --k;
        }
        z.value[xLen - 1] = (int)carry;
        for (int i = xLen - 2; i >= 0; --i) {
            carry = 0L;
            int j2 = yLen - 1;
            int k2 = yLen + i;
            while (j2 >= 0) {
                long product = ((long)y.value[j2 + y.offset] & 0xFFFFFFFFL) * ((long)this.value[i + this.offset] & 0xFFFFFFFFL) + ((long)z.value[k2] & 0xFFFFFFFFL) + carry;
                z.value[k2] = (int)product;
                carry = product >>> 32;
                --j2;
                --k2;
            }
            z.value[i] = (int)carry;
        }
        z.normalize();
    }

    void mul(int y, MutableBigInteger z) {
        if (y == 1) {
            z.copyValue(this);
            return;
        }
        if (y == 0) {
            z.clear();
            return;
        }
        long ylong = (long)y & 0xFFFFFFFFL;
        int[] zval = z.value.length < this.intLen + 1 ? new int[this.intLen + 1] : z.value;
        long carry = 0L;
        for (int i = this.intLen - 1; i >= 0; --i) {
            long product = ylong * ((long)this.value[i + this.offset] & 0xFFFFFFFFL) + carry;
            zval[i + 1] = (int)product;
            carry = product >>> 32;
        }
        if (carry == 0L) {
            z.offset = 1;
            z.intLen = this.intLen;
        } else {
            z.offset = 0;
            z.intLen = this.intLen + 1;
            zval[0] = (int)carry;
        }
        z.value = zval;
    }

    void divideOneWord(int divisor, MutableBigInteger quotient) {
        long divLong = (long)divisor & 0xFFFFFFFFL;
        if (this.intLen == 1) {
            long remValue = (long)this.value[this.offset] & 0xFFFFFFFFL;
            quotient.value[0] = (int)(remValue / divLong);
            quotient.intLen = quotient.value[0] == 0 ? 0 : 1;
            quotient.offset = 0;
            this.value[0] = (int)(remValue - (long)quotient.value[0] * divLong);
            this.offset = 0;
            this.intLen = this.value[0] == 0 ? 0 : 1;
            return;
        }
        if (quotient.value.length < this.intLen) {
            quotient.value = new int[this.intLen];
        }
        quotient.offset = 0;
        quotient.intLen = this.intLen;
        int shift = 32 - BigInteger.bitLen(divisor);
        int rem = this.value[this.offset];
        long remLong = (long)rem & 0xFFFFFFFFL;
        if (remLong < divLong) {
            quotient.value[0] = 0;
        } else {
            quotient.value[0] = (int)(remLong / divLong);
            rem = (int)(remLong - (long)quotient.value[0] * divLong);
            remLong = (long)rem & 0xFFFFFFFFL;
        }
        int xlen = this.intLen;
        int[] qWord = new int[2];
        while (--xlen > 0) {
            long dividendEstimate = remLong << 32 | (long)this.value[this.offset + this.intLen - xlen] & 0xFFFFFFFFL;
            if (dividendEstimate >= 0L) {
                qWord[0] = (int)(dividendEstimate / divLong);
                qWord[1] = (int)(dividendEstimate - (long)qWord[0] * divLong);
            } else {
                this.divWord(qWord, dividendEstimate, divisor);
            }
            quotient.value[this.intLen - xlen] = qWord[0];
            rem = qWord[1];
            remLong = (long)rem & 0xFFFFFFFFL;
        }
        this.value[0] = shift > 0 ? (rem %= divisor) : rem;
        this.intLen = this.value[0] == 0 ? 0 : 1;
        quotient.normalize();
    }

    void divide(MutableBigInteger b, MutableBigInteger quotient, MutableBigInteger rem) {
        if (b.intLen == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.intLen == 0) {
            rem.offset = 0;
            rem.intLen = 0;
            quotient.offset = 0;
            quotient.intLen = 0;
            return;
        }
        int cmp = this.compare(b);
        if (cmp < 0) {
            quotient.offset = 0;
            quotient.intLen = 0;
            rem.copyValue(this);
            return;
        }
        if (cmp == 0) {
            quotient.intLen = 1;
            quotient.value[0] = 1;
            rem.offset = 0;
            rem.intLen = 0;
            quotient.offset = 0;
            return;
        }
        quotient.clear();
        if (b.intLen == 1) {
            rem.copyValue(this);
            rem.divideOneWord(b.value[b.offset], quotient);
            return;
        }
        int[] d = new int[b.intLen];
        for (int i = 0; i < b.intLen; ++i) {
            d[i] = b.value[b.offset + i];
        }
        int dlen = b.intLen;
        if (rem.value.length < this.intLen + 1) {
            rem.value = new int[this.intLen + 1];
        }
        for (int i = 0; i < this.intLen; ++i) {
            rem.value[i + 1] = this.value[i + this.offset];
        }
        rem.intLen = this.intLen;
        rem.offset = 1;
        int nlen = rem.intLen;
        int limit = nlen - dlen + 1;
        if (quotient.value.length < limit) {
            quotient.value = new int[limit];
            quotient.offset = 0;
        }
        quotient.intLen = limit;
        int[] q = quotient.value;
        int shift = 32 - BigInteger.bitLen(d[0]);
        if (shift > 0) {
            BigInteger.primitiveLeftShift(d, dlen, shift);
            rem.leftShift(shift);
        }
        if (rem.intLen == nlen) {
            rem.offset = 0;
            rem.value[0] = 0;
            ++rem.intLen;
        }
        int dh = d[0];
        long dhLong = (long)dh & 0xFFFFFFFFL;
        int dl = d[1];
        int[] qWord = new int[2];
        for (int j = 0; j < limit; ++j) {
            long nl;
            long rs;
            long estProduct;
            int qhat = 0;
            int qrem = 0;
            boolean skipCorrection = false;
            int nh = rem.value[j + rem.offset];
            int nh2 = nh + Integer.MIN_VALUE;
            int nm = rem.value[j + 1 + rem.offset];
            if (nh == dh) {
                qhat = -1;
                qrem = nh + nm;
                skipCorrection = qrem + Integer.MIN_VALUE < nh2;
            } else {
                long nChunk = (long)nh << 32 | (long)nm & 0xFFFFFFFFL;
                if (nChunk >= 0L) {
                    qhat = (int)(nChunk / dhLong);
                    qrem = (int)(nChunk - (long)qhat * dhLong);
                } else {
                    this.divWord(qWord, nChunk, dh);
                    qhat = qWord[0];
                    qrem = qWord[1];
                }
            }
            if (qhat == 0) continue;
            if (!skipCorrection && this.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)qhat & 0xFFFFFFFFL), rs = ((long)qrem & 0xFFFFFFFFL) << 32 | (nl = (long)rem.value[j + 2 + rem.offset] & 0xFFFFFFFFL)) && ((long)(qrem = (int)(((long)qrem & 0xFFFFFFFFL) + dhLong)) & 0xFFFFFFFFL) >= dhLong && this.unsignedLongCompare(estProduct = ((long)dl & 0xFFFFFFFFL) * ((long)(--qhat) & 0xFFFFFFFFL), rs = ((long)qrem & 0xFFFFFFFFL) << 32 | nl)) {
                --qhat;
            }
            rem.value[j + rem.offset] = 0;
            int borrow = this.mulsub(rem.value, d, qhat, dlen, j + rem.offset);
            if (borrow + Integer.MIN_VALUE > nh2) {
                this.divadd(d, rem.value, j + 1 + rem.offset);
            }
            q[j] = --qhat;
        }
        if (shift > 0) {
            rem.rightShift(shift);
        }
        rem.normalize();
        quotient.normalize();
    }

    private boolean unsignedLongCompare(long one, long two) {
        return one + Long.MIN_VALUE > two + Long.MIN_VALUE;
    }

    private void divWord(int[] result, long n, int d) {
        long dLong = (long)d & 0xFFFFFFFFL;
        if (dLong == 1L) {
            result[0] = (int)n;
            result[1] = 0;
            return;
        }
        long q = (n >>> 1) / (dLong >>> 1);
        long r = n - q * dLong;
        while (r < 0L) {
            r += dLong;
            --q;
        }
        while (r >= dLong) {
            r -= dLong;
            ++q;
        }
        result[0] = (int)q;
        result[1] = (int)r;
    }

    MutableBigInteger hybridGCD(MutableBigInteger b) {
        MutableBigInteger a = this;
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger r = new MutableBigInteger();
        while (b.intLen != 0) {
            if (Math.abs(a.intLen - b.intLen) < 2) {
                return a.binaryGCD(b);
            }
            a.divide(b, q, r);
            MutableBigInteger swapper = a;
            a = b;
            b = r;
            r = swapper;
        }
        return a;
    }

    private MutableBigInteger binaryGCD(MutableBigInteger v) {
        int lb;
        int tsign;
        int s2;
        int k;
        MutableBigInteger u = this;
        MutableBigInteger r = new MutableBigInteger();
        int s1 = u.getLowestSetBit();
        int n = k = s1 < (s2 = v.getLowestSetBit()) ? s1 : s2;
        if (k != 0) {
            u.rightShift(k);
            v.rightShift(k);
        }
        boolean uOdd = k == s1;
        MutableBigInteger t = uOdd ? v : u;
        int n2 = tsign = uOdd ? -1 : 1;
        while ((lb = t.getLowestSetBit()) >= 0) {
            t.rightShift(lb);
            if (tsign > 0) {
                u = t;
            } else {
                v = t;
            }
            if (u.intLen < 2 && v.intLen < 2) {
                int x = u.value[u.offset];
                int y = v.value[v.offset];
                r.value[0] = x = MutableBigInteger.binaryGcd(x, y);
                r.intLen = 1;
                r.offset = 0;
                if (k > 0) {
                    r.leftShift(k);
                }
                return r;
            }
            tsign = u.difference(v);
            if (tsign == 0) break;
            t = tsign >= 0 ? u : v;
        }
        if (k > 0) {
            u.leftShift(k);
        }
        return u;
    }

    static int binaryGcd(int a, int b) {
        int t;
        int x;
        if (b == 0) {
            return a;
        }
        if (a == 0) {
            return b;
        }
        int aZeros = 0;
        while ((x = a & 0xFF) == 0) {
            a >>>= 8;
            aZeros += 8;
        }
        byte y = BigInteger.trailingZeroTable[x];
        aZeros += y;
        a >>>= y;
        int bZeros = 0;
        while ((x = b & 0xFF) == 0) {
            b >>>= 8;
            bZeros += 8;
        }
        y = BigInteger.trailingZeroTable[x];
        b >>>= y;
        int n = t = aZeros < (bZeros += y) ? aZeros : bZeros;
        while (a != b) {
            if (a + Integer.MIN_VALUE > b + Integer.MIN_VALUE) {
                a -= b;
                while ((x = a & 0xFF) == 0) {
                    a >>>= 8;
                }
                a >>>= BigInteger.trailingZeroTable[x];
                continue;
            }
            b -= a;
            while ((x = b & 0xFF) == 0) {
                b >>>= 8;
            }
            b >>>= BigInteger.trailingZeroTable[x];
        }
        return a << t;
    }

    MutableBigInteger mutableModInverse(MutableBigInteger p) {
        if (p.isOdd()) {
            return this.modInverse(p);
        }
        if (this.isEven()) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        int powersOf2 = p.getLowestSetBit();
        MutableBigInteger oddMod = new MutableBigInteger(p);
        oddMod.rightShift(powersOf2);
        if (oddMod.isOne()) {
            return this.modInverseMP2(powersOf2);
        }
        MutableBigInteger oddPart = this.modInverse(oddMod);
        MutableBigInteger evenPart = this.modInverseMP2(powersOf2);
        MutableBigInteger y1 = MutableBigInteger.modInverseBP2(oddMod, powersOf2);
        MutableBigInteger y2 = oddMod.modInverseMP2(powersOf2);
        MutableBigInteger temp1 = new MutableBigInteger();
        MutableBigInteger temp2 = new MutableBigInteger();
        MutableBigInteger result = new MutableBigInteger();
        oddPart.leftShift(powersOf2);
        oddPart.multiply(y1, result);
        evenPart.multiply(oddMod, temp1);
        temp1.multiply(y2, temp2);
        result.add(temp2);
        result.divide(p, temp1, temp2);
        return temp2;
    }

    MutableBigInteger modInverseMP2(int k) {
        if (this.isEven()) {
            throw new ArithmeticException("Non-invertible. (GCD != 1)");
        }
        if (k > 64) {
            return this.euclidModInverse(k);
        }
        int t = MutableBigInteger.inverseMod32(this.value[this.offset + this.intLen - 1]);
        if (k < 33) {
            t = k == 32 ? t : t & (1 << k) - 1;
            return new MutableBigInteger(t);
        }
        long pLong = (long)this.value[this.offset + this.intLen - 1] & 0xFFFFFFFFL;
        if (this.intLen > 1) {
            pLong |= (long)this.value[this.offset + this.intLen - 2] << 32;
        }
        long tLong = (long)t & 0xFFFFFFFFL;
        tLong *= 2L - pLong * tLong;
        tLong = k == 64 ? tLong : tLong & (1L << k) - 1L;
        MutableBigInteger result = new MutableBigInteger(new int[2]);
        result.value[0] = (int)(tLong >>> 32);
        result.value[1] = (int)tLong;
        result.intLen = 2;
        result.normalize();
        return result;
    }

    static int inverseMod32(int val) {
        int t = val;
        t *= 2 - val * t;
        t *= 2 - val * t;
        t *= 2 - val * t;
        t *= 2 - val * t;
        return t;
    }

    static MutableBigInteger modInverseBP2(MutableBigInteger mod, int k) {
        return MutableBigInteger.fixup(new MutableBigInteger(1), new MutableBigInteger(mod), k);
    }

    private MutableBigInteger modInverse(MutableBigInteger mod) {
        int trailingZeros;
        MutableBigInteger p = new MutableBigInteger(mod);
        MutableBigInteger f = new MutableBigInteger(this);
        MutableBigInteger g = new MutableBigInteger(p);
        SignedMutableBigInteger c = new SignedMutableBigInteger(1);
        SignedMutableBigInteger d = new SignedMutableBigInteger();
        MutableBigInteger temp = null;
        SignedMutableBigInteger sTemp = null;
        int k = 0;
        if (f.isEven()) {
            trailingZeros = f.getLowestSetBit();
            f.rightShift(trailingZeros);
            d.leftShift(trailingZeros);
            k = trailingZeros;
        }
        while (!f.isOne()) {
            if (f.isZero()) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            if (f.compare(g) < 0) {
                temp = f;
                f = g;
                g = temp;
                sTemp = d;
                d = c;
                c = sTemp;
            }
            if (((f.value[f.offset + f.intLen - 1] ^ g.value[g.offset + g.intLen - 1]) & 3) == 0) {
                f.subtract(g);
                c.signedSubtract(d);
            } else {
                f.add(g);
                c.signedAdd(d);
            }
            trailingZeros = f.getLowestSetBit();
            f.rightShift(trailingZeros);
            d.leftShift(trailingZeros);
            k += trailingZeros;
        }
        while (c.sign < 0) {
            c.signedAdd(p);
        }
        return MutableBigInteger.fixup(c, p, k);
    }

    static MutableBigInteger fixup(MutableBigInteger c, MutableBigInteger p, int k) {
        MutableBigInteger temp = new MutableBigInteger();
        int r = -MutableBigInteger.inverseMod32(p.value[p.offset + p.intLen - 1]);
        int numWords = k >> 5;
        for (int i = 0; i < numWords; ++i) {
            int v = r * c.value[c.offset + c.intLen - 1];
            p.mul(v, temp);
            c.add(temp);
            --c.intLen;
        }
        int numBits = k & 0x1F;
        if (numBits != 0) {
            int v = r * c.value[c.offset + c.intLen - 1];
            p.mul(v &= (1 << numBits) - 1, temp);
            c.add(temp);
            c.rightShift(numBits);
        }
        while (c.compare(p) >= 0) {
            c.subtract(p);
        }
        return c;
    }

    MutableBigInteger euclidModInverse(int k) {
        MutableBigInteger b = new MutableBigInteger(1);
        b.leftShift(k);
        MutableBigInteger mod = new MutableBigInteger(b);
        MutableBigInteger a = new MutableBigInteger(this);
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger r = new MutableBigInteger();
        b.divide(a, q, r);
        MutableBigInteger swapper = b;
        b = r;
        r = swapper;
        MutableBigInteger t1 = new MutableBigInteger(q);
        MutableBigInteger t0 = new MutableBigInteger(1);
        MutableBigInteger temp = new MutableBigInteger();
        while (!b.isOne()) {
            a.divide(b, q, r);
            if (r.intLen == 0) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            swapper = r;
            r = a;
            a = swapper;
            if (q.intLen == 1) {
                t1.mul(q.value[q.offset], temp);
            } else {
                q.multiply(t1, temp);
            }
            swapper = q;
            q = temp;
            temp = swapper;
            t0.add(q);
            if (a.isOne()) {
                return t0;
            }
            b.divide(a, q, r);
            if (r.intLen == 0) {
                throw new ArithmeticException("BigInteger not invertible.");
            }
            swapper = b;
            b = r;
            r = swapper;
            if (q.intLen == 1) {
                t0.mul(q.value[q.offset], temp);
            } else {
                q.multiply(t0, temp);
            }
            swapper = q;
            q = temp;
            temp = swapper;
            t1.add(q);
        }
        mod.subtract(t1);
        return mod;
    }
}

