/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import sun.misc.FloatingDecimal;
import sun.misc.FpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Double
extends Number
implements Comparable<Double> {
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_NORMAL = 2.2250738585072014E-308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_EXPONENT = -1022;
    public static final int SIZE = 64;
    public static final Class<Double> TYPE = Class.getPrimitiveClass("double");
    private final double value;
    private static final long serialVersionUID = -9172774392245257468L;

    public static String toString(double d) {
        return new FloatingDecimal(d).toJavaFormatString();
    }

    public static String toHexString(double d) {
        if (!FpUtils.isFinite(d)) {
            return Double.toString(d);
        }
        StringBuffer answer = new StringBuffer(24);
        if (FpUtils.rawCopySign(1.0, d) == -1.0) {
            answer.append("-");
        }
        answer.append("0x");
        d = Math.abs(d);
        if (d == 0.0) {
            answer.append("0.0p0");
        } else {
            boolean subnormal = d < Double.MIN_NORMAL;
            long signifBits = Double.doubleToLongBits(d) & 0xFFFFFFFFFFFFFL | 0x1000000000000000L;
            answer.append(subnormal ? "0." : "1.");
            String signif = Long.toHexString(signifBits).substring(3, 16);
            answer.append(signif.equals("0000000000000") ? "0" : signif.replaceFirst("0{1,12}$", ""));
            answer.append("p" + (subnormal ? -1022 : FpUtils.getExponent(d)));
        }
        return answer.toString();
    }

    public static Double valueOf(String s) throws NumberFormatException {
        return new Double(FloatingDecimal.readJavaFormatString(s).doubleValue());
    }

    public static Double valueOf(double d) {
        return new Double(d);
    }

    public static double parseDouble(String s) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(s).doubleValue();
    }

    public static boolean isNaN(double v) {
        return v != v;
    }

    public static boolean isInfinite(double v) {
        return v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY;
    }

    public Double(double value) {
        this.value = value;
    }

    public Double(String s) throws NumberFormatException {
        this(Double.valueOf(s));
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof Double && Double.doubleToLongBits(((Double)obj).value) == Double.doubleToLongBits(this.value);
    }

    public static long doubleToLongBits(double value) {
        long result = Double.doubleToRawLongBits(value);
        if ((result & 0x7FF0000000000000L) == 0x7FF0000000000000L && (result & 0xFFFFFFFFFFFFFL) != 0L) {
            result = 9221120237041090560L;
        }
        return result;
    }

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    @Override
    public int compareTo(Double anotherDouble) {
        return Double.compare(this.value, anotherDouble.value);
    }

    public static int compare(double d1, double d2) {
        long anotherBits;
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        long thisBits = Double.doubleToLongBits(d1);
        return thisBits == (anotherBits = Double.doubleToLongBits(d2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }
}

