/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509Certificate;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509CertificateResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(X509CertificateResolver.class.getName());
    Element[] _x509CertKeyElements = null;
    XMLX509Certificate[] _x509certObject = null;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can I resolve " + element.getTagName() + "?");
        }
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I can't");
            }
            return false;
        }
        this._x509CertKeyElements = XMLUtils.selectDsNodes(element.getFirstChild(), "X509Certificate");
        if (this._x509CertKeyElements != null && this._x509CertKeyElements.length > 0) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Yes Sir, I can");
            }
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I can't");
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        try {
            int i;
            boolean weCanResolve;
            if (!(this._x509CertKeyElements != null && this._x509CertKeyElements.length != 0 || (weCanResolve = this.engineCanResolve(element, BaseURI, storage)) && this._x509CertKeyElements != null && this._x509CertKeyElements.length != 0)) {
                return null;
            }
            this._x509certObject = new XMLX509Certificate[this._x509CertKeyElements.length];
            for (i = 0; i < this._x509CertKeyElements.length; ++i) {
                this._x509certObject[i] = new XMLX509Certificate(this._x509CertKeyElements[i], BaseURI);
            }
            for (i = 0; i < this._x509certObject.length; ++i) {
                X509Certificate cert = this._x509certObject[i].getX509Certificate();
                if (cert == null) continue;
                return cert;
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "XMLSecurityException", ex);
            }
            throw new KeyResolverException("generic.EmptyMessage", ex);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

