/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.x509;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509IssuerSerial
extends SignatureElementProxy
implements XMLX509DataContent {
    static Logger log = Logger.getLogger(XMLX509IssuerSerial.class.getName());

    public XMLX509IssuerSerial(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public XMLX509IssuerSerial(Document doc, String X509IssuerName, BigInteger X509SerialNumber) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this.addTextElement(X509IssuerName, "X509IssuerName");
        XMLUtils.addReturnToElement(this._constructionElement);
        this.addTextElement(X509SerialNumber.toString(), "X509SerialNumber");
    }

    public XMLX509IssuerSerial(Document doc, String X509IssuerName, String X509SerialNumber) {
        this(doc, X509IssuerName, new BigInteger(X509SerialNumber));
    }

    public XMLX509IssuerSerial(Document doc, String X509IssuerName, int X509SerialNumber) {
        this(doc, X509IssuerName, new BigInteger(Integer.toString(X509SerialNumber)));
    }

    public XMLX509IssuerSerial(Document doc, X509Certificate x509certificate) {
        this(doc, RFC2253Parser.normalize(x509certificate.getIssuerDN().getName()), x509certificate.getSerialNumber());
    }

    public BigInteger getSerialNumber() {
        String text = this.getTextFromChildElement("X509SerialNumber", "http://www.w3.org/2000/09/xmldsig#");
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "In dem X509SerialNumber wurde gefunden: " + text);
        }
        return new BigInteger(text);
    }

    public int getSerialNumberInteger() {
        return this.getSerialNumber().intValue();
    }

    public String getIssuerName() {
        return RFC2253Parser.normalize(this.getTextFromChildElement("X509IssuerName", "http://www.w3.org/2000/09/xmldsig#"));
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        XMLX509IssuerSerial other = (XMLX509IssuerSerial)obj;
        return other.getSerialNumber().equals(this.getSerialNumber()) && other.getIssuerName().equals(this.getIssuerName());
    }

    public String getBaseLocalName() {
        return "X509IssuerSerial";
    }
}

