/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelChannelMixer;
import com.sun.media.sound.ModelConnectionBlock;
import com.sun.media.sound.ModelDestination;
import com.sun.media.sound.ModelIdentifier;
import com.sun.media.sound.ModelOscillator;
import com.sun.media.sound.ModelOscillatorStream;
import com.sun.media.sound.ModelSource;
import com.sun.media.sound.ModelTransform;
import com.sun.media.sound.ModelWavetable;
import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftChannel;
import com.sun.media.sound.SoftControl;
import com.sun.media.sound.SoftEnvelopeGenerator;
import com.sun.media.sound.SoftFilter;
import com.sun.media.sound.SoftInstrument;
import com.sun.media.sound.SoftLowFrequencyOscillator;
import com.sun.media.sound.SoftPerformer;
import com.sun.media.sound.SoftProcess;
import com.sun.media.sound.SoftResamplerStreamer;
import com.sun.media.sound.SoftSynthesizer;
import com.sun.media.sound.SoftTuning;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.sound.midi.VoiceStatus;

public class SoftVoice
extends VoiceStatus {
    public int exclusiveClass = 0;
    public boolean releaseTriggered = false;
    private int noteOn_noteNumber = 0;
    private int noteOn_velocity = 0;
    private int noteOff_velocity = 0;
    private int delay = 0;
    protected ModelChannelMixer channelmixer = null;
    protected double tunedKey = 0.0;
    protected SoftTuning tuning = null;
    protected SoftChannel stealer_channel = null;
    protected ModelConnectionBlock[] stealer_extendedConnectionBlocks = null;
    protected SoftPerformer stealer_performer = null;
    protected ModelChannelMixer stealer_channelmixer = null;
    protected int stealer_voiceID = -1;
    protected int stealer_noteNumber = 0;
    protected int stealer_velocity = 0;
    protected boolean stealer_releaseTriggered = false;
    protected int voiceID = -1;
    protected boolean sustain = false;
    protected boolean sostenuto = false;
    protected boolean portamento = false;
    private SoftFilter filter_left;
    private SoftFilter filter_right;
    private SoftProcess eg = new SoftEnvelopeGenerator();
    private SoftProcess lfo = new SoftLowFrequencyOscillator();
    protected Map<String, SoftControl> objects = new HashMap<String, SoftControl>();
    protected SoftSynthesizer synthesizer;
    protected SoftInstrument instrument;
    protected SoftPerformer performer;
    protected SoftChannel softchannel = null;
    protected boolean on = false;
    private boolean audiostarted = false;
    private boolean started = false;
    private boolean stopping = false;
    private float osc_attenuation = 0.0f;
    private ModelOscillatorStream osc_stream;
    private int osc_stream_nrofchannels;
    private float[][] osc_buff = new float[2][];
    private boolean osc_stream_off_transmitted = false;
    private boolean out_mixer_end = false;
    private float out_mixer_left = 0.0f;
    private float out_mixer_right = 0.0f;
    private float out_mixer_effect1 = 0.0f;
    private float out_mixer_effect2 = 0.0f;
    private float last_out_mixer_left = 0.0f;
    private float last_out_mixer_right = 0.0f;
    private float last_out_mixer_effect1 = 0.0f;
    private float last_out_mixer_effect2 = 0.0f;
    protected ModelConnectionBlock[] extendedConnectionBlocks = null;
    private ModelConnectionBlock[] connections;
    private double[] connections_last = new double[50];
    private double[][][] connections_src = new double[50][3][];
    private int[][] connections_src_kc = new int[50][3];
    private double[][] connections_dst = new double[50][];
    private boolean soundoff = false;
    private float lastMuteValue = 0.0f;
    private float lastSoloMuteValue = 0.0f;
    protected double[] co_noteon_keynumber = new double[1];
    protected double[] co_noteon_velocity = new double[1];
    protected double[] co_noteon_on = new double[1];
    private SoftControl co_noteon = new SoftControl(){
        double[] keynumber;
        double[] velocity;
        double[] on;
        {
            this.keynumber = SoftVoice.this.co_noteon_keynumber;
            this.velocity = SoftVoice.this.co_noteon_velocity;
            this.on = SoftVoice.this.co_noteon_on;
        }

        public double[] get(int instance, String name) {
            if (name == null) {
                return null;
            }
            if (name.equals("keynumber")) {
                return this.keynumber;
            }
            if (name.equals("velocity")) {
                return this.velocity;
            }
            if (name.equals("on")) {
                return this.on;
            }
            return null;
        }
    };
    private double[] co_mixer_active = new double[1];
    private double[] co_mixer_gain = new double[1];
    private double[] co_mixer_pan = new double[1];
    private double[] co_mixer_balance = new double[1];
    private double[] co_mixer_reverb = new double[1];
    private double[] co_mixer_chorus = new double[1];
    private SoftControl co_mixer = new SoftControl(){
        double[] active;
        double[] gain;
        double[] pan;
        double[] balance;
        double[] reverb;
        double[] chorus;
        {
            this.active = SoftVoice.this.co_mixer_active;
            this.gain = SoftVoice.this.co_mixer_gain;
            this.pan = SoftVoice.this.co_mixer_pan;
            this.balance = SoftVoice.this.co_mixer_balance;
            this.reverb = SoftVoice.this.co_mixer_reverb;
            this.chorus = SoftVoice.this.co_mixer_chorus;
        }

        public double[] get(int instance, String name) {
            if (name == null) {
                return null;
            }
            if (name.equals("active")) {
                return this.active;
            }
            if (name.equals("gain")) {
                return this.gain;
            }
            if (name.equals("pan")) {
                return this.pan;
            }
            if (name.equals("balance")) {
                return this.balance;
            }
            if (name.equals("reverb")) {
                return this.reverb;
            }
            if (name.equals("chorus")) {
                return this.chorus;
            }
            return null;
        }
    };
    private double[] co_osc_pitch = new double[1];
    private SoftControl co_osc = new SoftControl(){
        double[] pitch;
        {
            this.pitch = SoftVoice.this.co_osc_pitch;
        }

        public double[] get(int instance, String name) {
            if (name == null) {
                return null;
            }
            if (name.equals("pitch")) {
                return this.pitch;
            }
            return null;
        }
    };
    private double[] co_filter_freq = new double[1];
    private double[] co_filter_type = new double[1];
    private double[] co_filter_q = new double[1];
    private SoftControl co_filter = new SoftControl(){
        double[] freq;
        double[] ftype;
        double[] q;
        {
            this.freq = SoftVoice.this.co_filter_freq;
            this.ftype = SoftVoice.this.co_filter_type;
            this.q = SoftVoice.this.co_filter_q;
        }

        public double[] get(int instance, String name) {
            if (name == null) {
                return null;
            }
            if (name.equals("freq")) {
                return this.freq;
            }
            if (name.equals("type")) {
                return this.ftype;
            }
            if (name.equals("q")) {
                return this.q;
            }
            return null;
        }
    };
    protected SoftResamplerStreamer resampler;
    private int nrofchannels;

    public SoftVoice(SoftSynthesizer synth2) {
        this.synthesizer = synth2;
        this.filter_left = new SoftFilter(synth2.getFormat().getSampleRate());
        this.filter_right = new SoftFilter(synth2.getFormat().getSampleRate());
        this.nrofchannels = synth2.getFormat().getChannels();
    }

    private int getValueKC(ModelIdentifier id) {
        if (id.getObject().equals("midi_cc")) {
            int ic = Integer.parseInt(id.getVariable());
            if (ic != 0 && ic != 32 && ic < 120) {
                return ic;
            }
        } else if (id.getObject().equals("midi_rpn")) {
            if (id.getVariable().equals("1")) {
                return 120;
            }
            if (id.getVariable().equals("2")) {
                return 121;
            }
        }
        return -1;
    }

    private double[] getValue(ModelIdentifier id) {
        SoftControl o = this.objects.get(id.getObject());
        if (o == null) {
            return null;
        }
        return o.get(id.getInstance(), id.getVariable());
    }

    private double transformValue(double value, ModelSource src) {
        if (src.getTransform() != null) {
            return src.getTransform().transform(value);
        }
        return value;
    }

    private double transformValue(double value, ModelDestination dst) {
        if (dst.getTransform() != null) {
            return dst.getTransform().transform(value);
        }
        return value;
    }

    private double processKeyBasedController(double value, int keycontrol) {
        if (keycontrol == -1) {
            return value;
        }
        if (this.softchannel.keybasedcontroller_active != null && this.softchannel.keybasedcontroller_active[this.note] != null && this.softchannel.keybasedcontroller_active[this.note][keycontrol]) {
            double key_controlvalue = this.softchannel.keybasedcontroller_value[this.note][keycontrol];
            if (keycontrol == 10 || keycontrol == 91 || keycontrol == 93) {
                return key_controlvalue;
            }
            if ((value += key_controlvalue * 2.0 - 1.0) > 1.0) {
                value = 1.0;
            } else if (value < 0.0) {
                value = 0.0;
            }
        }
        return value;
    }

    private void processConnection(int ix) {
        ModelConnectionBlock conn = this.connections[ix];
        double[][] src = this.connections_src[ix];
        double[] dst = this.connections_dst[ix];
        if (dst == null || Double.isInfinite(dst[0])) {
            return;
        }
        double value = conn.getScale();
        if (this.softchannel.keybasedcontroller_active == null) {
            ModelSource[] srcs = conn.getSources();
            for (int i = 0; i < srcs.length && (value *= this.transformValue(src[i][0], srcs[i])) != 0.0; ++i) {
            }
        } else {
            ModelSource[] srcs = conn.getSources();
            int[] src_kc = this.connections_src_kc[ix];
            for (int i = 0; i < srcs.length && (value *= this.transformValue(this.processKeyBasedController(src[i][0], src_kc[i]), srcs[i])) != 0.0; ++i) {
            }
        }
        value = this.transformValue(value, conn.getDestination());
        dst[0] = dst[0] - this.connections_last[ix] + value;
        this.connections_last[ix] = value;
    }

    protected void updateTuning(SoftTuning newtuning) {
        this.tunedKey = this.tuning.getTuning(this.note) / 100.0;
        if (!this.portamento) {
            this.co_noteon_keynumber[0] = this.tunedKey * 0.0078125;
            int[] c = this.performer.midi_connections[4];
            if (c == null) {
                return;
            }
            for (int i = 0; i < c.length; ++i) {
                this.processConnection(c[i]);
            }
        }
    }

    protected void setNote(int noteNumber) {
        this.note = noteNumber;
        this.tunedKey = this.tuning.getTuning(noteNumber) / 100.0;
    }

    protected void noteOn(int noteNumber, int velocity, int delay) {
        int i;
        this.sustain = false;
        this.sostenuto = false;
        this.portamento = false;
        this.soundoff = false;
        this.on = true;
        this.active = true;
        this.started = true;
        this.noteOn_noteNumber = noteNumber;
        this.noteOn_velocity = velocity;
        this.delay = delay;
        this.lastMuteValue = 0.0f;
        this.lastSoloMuteValue = 0.0f;
        this.setNote(noteNumber);
        this.co_noteon_keynumber[0] = this.performer.forcedKeynumber ? 0.0 : this.tunedKey * 0.0078125;
        this.co_noteon_velocity[0] = this.performer.forcedVelocity ? 0.0 : (double)((float)velocity * 0.0078125f);
        this.co_mixer_active[0] = 0.0;
        this.co_mixer_gain[0] = 0.0;
        this.co_mixer_pan[0] = 0.0;
        this.co_mixer_balance[0] = 0.0;
        this.co_mixer_reverb[0] = 0.0;
        this.co_mixer_chorus[0] = 0.0;
        this.co_osc_pitch[0] = 0.0;
        this.co_filter_freq[0] = 0.0;
        this.co_filter_q[0] = 0.0;
        this.co_filter_type[0] = 0.0;
        this.co_noteon_on[0] = 1.0;
        this.eg.reset();
        this.lfo.reset();
        this.filter_left.reset();
        this.filter_right.reset();
        this.objects.put("master", this.synthesizer.getMainMixer().co_master);
        this.objects.put("eg", this.eg);
        this.objects.put("lfo", this.lfo);
        this.objects.put("noteon", this.co_noteon);
        this.objects.put("osc", this.co_osc);
        this.objects.put("mixer", this.co_mixer);
        this.objects.put("filter", this.co_filter);
        this.connections = this.performer.connections;
        if (this.connections_last == null || this.connections_last.length < this.connections.length) {
            this.connections_last = new double[this.connections.length];
        }
        if (this.connections_src == null || this.connections_src.length < this.connections.length) {
            this.connections_src = new double[this.connections.length][][];
            this.connections_src_kc = new int[this.connections.length][];
        }
        if (this.connections_dst == null || this.connections_dst.length < this.connections.length) {
            this.connections_dst = new double[this.connections.length][];
        }
        for (i = 0; i < this.connections.length; ++i) {
            ModelConnectionBlock conn = this.connections[i];
            this.connections_last[i] = 0.0;
            if (conn.getSources() != null) {
                ModelSource[] srcs = conn.getSources();
                if (this.connections_src[i] == null || this.connections_src[i].length < srcs.length) {
                    this.connections_src[i] = new double[srcs.length][];
                    this.connections_src_kc[i] = new int[srcs.length];
                }
                double[][] src = this.connections_src[i];
                int[] src_kc = this.connections_src_kc[i];
                this.connections_src[i] = src;
                for (int j = 0; j < srcs.length; ++j) {
                    src_kc[j] = this.getValueKC(srcs[j].getIdentifier());
                    src[j] = this.getValue(srcs[j].getIdentifier());
                }
            }
            this.connections_dst[i] = (double[])(conn.getDestination() != null ? this.getValue(conn.getDestination().getIdentifier()) : null);
        }
        for (i = 0; i < this.connections.length; ++i) {
            this.processConnection(i);
        }
        if (this.extendedConnectionBlocks != null) {
            for (ModelConnectionBlock connection : this.extendedConnectionBlocks) {
                ModelDestination dest;
                ModelTransform t;
                ModelTransform t2;
                double x;
                double value = 0.0;
                if (this.softchannel.keybasedcontroller_active == null) {
                    for (ModelSource src : connection.getSources()) {
                        x = this.getValue(src.getIdentifier())[0];
                        t2 = src.getTransform();
                        if (t2 == null) {
                            value += x;
                            continue;
                        }
                        value += t2.transform(x);
                    }
                } else {
                    for (ModelSource src : connection.getSources()) {
                        x = this.getValue(src.getIdentifier())[0];
                        x = this.processKeyBasedController(x, this.getValueKC(src.getIdentifier()));
                        t2 = src.getTransform();
                        if (t2 == null) {
                            value += x;
                            continue;
                        }
                        value += t2.transform(x);
                    }
                }
                if ((t = (dest = connection.getDestination()).getTransform()) != null) {
                    value = t.transform(value);
                }
                double[] dArray = this.getValue(dest.getIdentifier());
                dArray[0] = dArray[0] + value;
            }
        }
        this.eg.init(this.synthesizer);
        this.lfo.init(this.synthesizer);
    }

    protected void setPolyPressure(int pressure) {
        int[] c = this.performer.midi_connections[2];
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            this.processConnection(c[i]);
        }
    }

    protected void setChannelPressure(int pressure) {
        int[] c = this.performer.midi_connections[1];
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            this.processConnection(c[i]);
        }
    }

    protected void controlChange(int controller, int value) {
        int[] c = this.performer.midi_ctrl_connections[controller];
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            this.processConnection(c[i]);
        }
    }

    protected void nrpnChange(int controller, int value) {
        int[] c = this.performer.midi_nrpn_connections.get(controller);
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            this.processConnection(c[i]);
        }
    }

    protected void rpnChange(int controller, int value) {
        int[] c = this.performer.midi_rpn_connections.get(controller);
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            this.processConnection(c[i]);
        }
    }

    protected void setPitchBend(int bend) {
        int[] c = this.performer.midi_connections[0];
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            this.processConnection(c[i]);
        }
    }

    protected void setMute(boolean mute) {
        this.co_mixer_gain[0] = this.co_mixer_gain[0] - (double)this.lastMuteValue;
        this.lastMuteValue = mute ? -960.0f : 0.0f;
        this.co_mixer_gain[0] = this.co_mixer_gain[0] + (double)this.lastMuteValue;
    }

    protected void setSoloMute(boolean mute) {
        this.co_mixer_gain[0] = this.co_mixer_gain[0] - (double)this.lastSoloMuteValue;
        this.lastSoloMuteValue = mute ? -960.0f : 0.0f;
        this.co_mixer_gain[0] = this.co_mixer_gain[0] + (double)this.lastSoloMuteValue;
    }

    protected void shutdown() {
        if (this.co_noteon_on[0] < -0.5) {
            return;
        }
        this.on = false;
        this.co_noteon_on[0] = -1.0;
        int[] c = this.performer.midi_connections[3];
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            this.processConnection(c[i]);
        }
    }

    protected void soundOff() {
        this.on = false;
        this.soundoff = true;
    }

    protected void noteOff(int velocity) {
        if (!this.on) {
            return;
        }
        this.on = false;
        this.noteOff_velocity = velocity;
        if (this.softchannel.sustain) {
            this.sustain = true;
            return;
        }
        if (this.sostenuto) {
            return;
        }
        this.co_noteon_on[0] = 0.0;
        int[] c = this.performer.midi_connections[3];
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            this.processConnection(c[i]);
        }
    }

    protected void redamp() {
        if (this.co_noteon_on[0] > 0.5) {
            return;
        }
        if (this.co_noteon_on[0] < -0.5) {
            return;
        }
        this.sustain = true;
        this.co_noteon_on[0] = 1.0;
        int[] c = this.performer.midi_connections[3];
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            this.processConnection(c[i]);
        }
    }

    protected void processControlLogic() {
        if (this.stopping) {
            this.active = false;
            this.stopping = false;
            this.audiostarted = false;
            if (this.osc_stream != null) {
                try {
                    this.osc_stream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.stealer_channel != null) {
                this.stealer_channel.initVoice(this, this.stealer_performer, this.stealer_voiceID, this.stealer_noteNumber, this.stealer_velocity, 0, this.stealer_extendedConnectionBlocks, this.stealer_channelmixer, this.stealer_releaseTriggered);
                this.stealer_releaseTriggered = false;
                this.stealer_channel = null;
                this.stealer_performer = null;
                this.stealer_voiceID = -1;
                this.stealer_noteNumber = 0;
                this.stealer_velocity = 0;
                this.stealer_extendedConnectionBlocks = null;
                this.stealer_channelmixer = null;
            }
        }
        if (this.started) {
            this.audiostarted = true;
            ModelOscillator osc = this.performer.oscillators[0];
            this.osc_stream_off_transmitted = false;
            if (osc instanceof ModelWavetable) {
                try {
                    this.resampler.open((ModelWavetable)osc, this.synthesizer.getFormat().getSampleRate());
                    this.osc_stream = this.resampler;
                }
                catch (IOException e) {}
            } else {
                this.osc_stream = osc.open(this.synthesizer.getFormat().getSampleRate());
            }
            this.osc_attenuation = osc.getAttenuation();
            this.osc_stream_nrofchannels = osc.getChannels();
            if (this.osc_buff == null || this.osc_buff.length < this.osc_stream_nrofchannels) {
                this.osc_buff = new float[this.osc_stream_nrofchannels][];
            }
            if (this.osc_stream != null) {
                this.osc_stream.noteOn(this.softchannel, this, this.noteOn_noteNumber, this.noteOn_velocity);
            }
        }
        if (this.audiostarted) {
            if (this.portamento) {
                double note_delta = this.tunedKey - this.co_noteon_keynumber[0] * 128.0;
                double note_delta_a = Math.abs(note_delta);
                if (note_delta_a < 1.0E-10) {
                    this.co_noteon_keynumber[0] = this.tunedKey * 0.0078125;
                    this.portamento = false;
                } else {
                    if (note_delta_a > this.softchannel.portamento_time) {
                        note_delta = Math.signum(note_delta) * this.softchannel.portamento_time;
                    }
                    this.co_noteon_keynumber[0] = this.co_noteon_keynumber[0] + note_delta * 0.0078125;
                }
                int[] c = this.performer.midi_connections[4];
                if (c == null) {
                    return;
                }
                for (int i = 0; i < c.length; ++i) {
                    this.processConnection(c[i]);
                }
            }
            this.eg.processControlLogic();
            this.lfo.processControlLogic();
            for (int i = 0; i < this.performer.ctrl_connections.length; ++i) {
                this.processConnection(this.performer.ctrl_connections[i]);
            }
            this.osc_stream.setPitch((float)this.co_osc_pitch[0]);
            int filter_type = (int)this.co_filter_type[0];
            double filter_freq = this.co_filter_freq[0] == 13500.0 ? 19912.126958213175 : 440.0 * Math.exp((this.co_filter_freq[0] - 6900.0) * (Math.log(2.0) / 1200.0));
            double q = this.co_filter_q[0] / 10.0;
            this.filter_left.setFilterType(filter_type);
            this.filter_left.setFrequency(filter_freq);
            this.filter_left.setResonance(q);
            this.filter_right.setFilterType(filter_type);
            this.filter_right.setFrequency(filter_freq);
            this.filter_right.setResonance(q);
            float gain = (float)Math.exp(((double)(-this.osc_attenuation) + this.co_mixer_gain[0]) * (Math.log(10.0) / 200.0));
            if (this.co_mixer_gain[0] <= -960.0) {
                gain = 0.0f;
            }
            if (this.soundoff) {
                this.stopping = true;
                gain = 0.0f;
            }
            this.volume = (int)(Math.sqrt(gain) * 128.0);
            double pan = this.co_mixer_pan[0] * 0.001;
            if (pan < 0.0) {
                pan = 0.0;
            } else if (pan > 1.0) {
                pan = 1.0;
            }
            if (pan == 0.5) {
                this.out_mixer_right = this.out_mixer_left = gain * 0.70710677f;
            } else {
                this.out_mixer_left = gain * (float)Math.cos(pan * Math.PI * 0.5);
                this.out_mixer_right = gain * (float)Math.sin(pan * Math.PI * 0.5);
            }
            double balance = this.co_mixer_balance[0] * 0.001;
            if (balance != 0.5) {
                if (balance > 0.5) {
                    this.out_mixer_left = (float)((double)this.out_mixer_left * ((1.0 - balance) * 2.0));
                } else {
                    this.out_mixer_right = (float)((double)this.out_mixer_right * (balance * 2.0));
                }
            }
            if (this.synthesizer.reverb_on) {
                this.out_mixer_effect1 = (float)(this.co_mixer_reverb[0] * 0.001);
                this.out_mixer_effect1 *= gain;
            } else {
                this.out_mixer_effect1 = 0.0f;
            }
            if (this.synthesizer.chorus_on) {
                this.out_mixer_effect2 = (float)(this.co_mixer_chorus[0] * 0.001);
                this.out_mixer_effect2 *= gain;
            } else {
                this.out_mixer_effect2 = 0.0f;
            }
            boolean bl = this.out_mixer_end = this.co_mixer_active[0] < 0.5;
            if (!this.on && !this.osc_stream_off_transmitted) {
                this.osc_stream_off_transmitted = true;
                if (this.osc_stream != null) {
                    this.osc_stream.noteOff(this.noteOff_velocity);
                }
            }
        }
        if (this.started) {
            this.last_out_mixer_left = this.out_mixer_left;
            this.last_out_mixer_right = this.out_mixer_right;
            this.last_out_mixer_effect1 = this.out_mixer_effect1;
            this.last_out_mixer_effect2 = this.out_mixer_effect2;
            this.started = false;
        }
    }

    protected void mixAudioStream(SoftAudioBuffer in, SoftAudioBuffer out, SoftAudioBuffer dout, float amp_from, float amp_to) {
        int bufferlen = in.getSize();
        if ((double)amp_from < 1.0E-9 && (double)amp_to < 1.0E-9) {
            return;
        }
        if (dout != null && this.delay != 0) {
            if (amp_from == amp_to) {
                float[] fout = out.array();
                float[] fin = in.array();
                int j = 0;
                int i = this.delay;
                while (i < bufferlen) {
                    int n = i++;
                    fout[n] = fout[n] + fin[j++] * amp_to;
                }
                fout = dout.array();
                i = 0;
                while (i < this.delay) {
                    int n = i++;
                    fout[n] = fout[n] + fin[j++] * amp_to;
                }
            } else {
                float amp = amp_from;
                float amp_delta = (amp_to - amp_from) / (float)bufferlen;
                float[] fout = out.array();
                float[] fin = in.array();
                int j = 0;
                int i = this.delay;
                while (i < bufferlen) {
                    int n = i++;
                    fout[n] = fout[n] + fin[j++] * (amp += amp_delta);
                }
                fout = dout.array();
                i = 0;
                while (i < this.delay) {
                    int n = i++;
                    fout[n] = fout[n] + fin[j++] * (amp += amp_delta);
                }
            }
        } else if (amp_from == amp_to) {
            float[] fout = out.array();
            float[] fin = in.array();
            for (int i = 0; i < bufferlen; ++i) {
                int n = i;
                fout[n] = fout[n] + fin[i] * amp_to;
            }
        } else {
            float amp = amp_from;
            float amp_delta = (amp_to - amp_from) / (float)bufferlen;
            float[] fout = out.array();
            float[] fin = in.array();
            for (int i = 0; i < bufferlen; ++i) {
                int n = i;
                fout[n] = fout[n] + fin[i] * (amp += amp_delta);
            }
        }
    }

    protected void processAudioLogic(SoftAudioBuffer[] buffer) {
        if (!this.audiostarted) {
            return;
        }
        int bufferlen = buffer[0].getSize();
        try {
            int ret;
            this.osc_buff[0] = buffer[10].array();
            if (this.nrofchannels != 1) {
                this.osc_buff[1] = buffer[11].array();
            }
            if ((ret = this.osc_stream.read(this.osc_buff, 0, bufferlen)) == -1) {
                this.stopping = true;
                return;
            }
            if (ret != bufferlen) {
                Arrays.fill(this.osc_buff[0], ret, bufferlen, 0.0f);
                if (this.nrofchannels != 1) {
                    Arrays.fill(this.osc_buff[1], ret, bufferlen, 0.0f);
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        SoftAudioBuffer left = buffer[0];
        SoftAudioBuffer right = buffer[1];
        SoftAudioBuffer mono = buffer[2];
        SoftAudioBuffer eff1 = buffer[6];
        SoftAudioBuffer eff2 = buffer[7];
        SoftAudioBuffer dleft = buffer[3];
        SoftAudioBuffer dright = buffer[4];
        SoftAudioBuffer dmono = buffer[5];
        SoftAudioBuffer deff1 = buffer[8];
        SoftAudioBuffer deff2 = buffer[9];
        SoftAudioBuffer leftdry = buffer[10];
        SoftAudioBuffer rightdry = buffer[11];
        if (this.osc_stream_nrofchannels == 1) {
            rightdry = null;
        }
        if (!Double.isInfinite(this.co_filter_freq[0])) {
            this.filter_left.processAudio(leftdry);
            if (rightdry != null) {
                this.filter_right.processAudio(rightdry);
            }
        }
        if (this.nrofchannels == 1) {
            this.out_mixer_left = (this.out_mixer_left + this.out_mixer_right) / 2.0f;
            this.mixAudioStream(leftdry, left, dleft, this.last_out_mixer_left, this.out_mixer_left);
            if (rightdry != null) {
                this.mixAudioStream(rightdry, left, dleft, this.last_out_mixer_left, this.out_mixer_left);
            }
        } else if (rightdry == null && this.last_out_mixer_left == this.last_out_mixer_right && this.out_mixer_left == this.out_mixer_right) {
            this.mixAudioStream(leftdry, mono, dmono, this.last_out_mixer_left, this.out_mixer_left);
        } else {
            this.mixAudioStream(leftdry, left, dleft, this.last_out_mixer_left, this.out_mixer_left);
            if (rightdry != null) {
                this.mixAudioStream(rightdry, right, dright, this.last_out_mixer_right, this.out_mixer_right);
            } else {
                this.mixAudioStream(leftdry, right, dright, this.last_out_mixer_right, this.out_mixer_right);
            }
        }
        if (rightdry == null) {
            this.mixAudioStream(leftdry, eff1, deff1, this.last_out_mixer_effect1, this.out_mixer_effect1);
            this.mixAudioStream(leftdry, eff2, deff2, this.last_out_mixer_effect2, this.out_mixer_effect2);
        } else {
            this.mixAudioStream(leftdry, eff1, deff1, this.last_out_mixer_effect1 * 0.5f, this.out_mixer_effect1 * 0.5f);
            this.mixAudioStream(leftdry, eff2, deff2, this.last_out_mixer_effect2 * 0.5f, this.out_mixer_effect2 * 0.5f);
            this.mixAudioStream(rightdry, eff1, deff1, this.last_out_mixer_effect1 * 0.5f, this.out_mixer_effect1 * 0.5f);
            this.mixAudioStream(rightdry, eff2, deff2, this.last_out_mixer_effect2 * 0.5f, this.out_mixer_effect2 * 0.5f);
        }
        this.last_out_mixer_left = this.out_mixer_left;
        this.last_out_mixer_right = this.out_mixer_right;
        this.last_out_mixer_effect1 = this.out_mixer_effect1;
        this.last_out_mixer_effect2 = this.out_mixer_effect2;
        if (this.out_mixer_end) {
            this.stopping = true;
        }
    }
}

