/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftAbstractResampler;

public class SoftSincResampler
extends SoftAbstractResampler {
    float[][][] sinc_table;
    int sinc_scale_size = 100;
    int sinc_table_fsize = 800;
    int sinc_table_size = 30;
    int sinc_table_center = this.sinc_table_size / 2;

    public SoftSincResampler() {
        this.sinc_table = new float[this.sinc_scale_size][this.sinc_table_fsize][];
        for (int s = 0; s < this.sinc_scale_size; ++s) {
            float scale = (float)(1.0 / (1.0 + Math.pow(s, 1.1) / 10.0));
            for (int i = 0; i < this.sinc_table_fsize; ++i) {
                this.sinc_table[s][i] = SoftSincResampler.sincTable(this.sinc_table_size, (float)(-i) / (float)this.sinc_table_fsize, scale);
            }
        }
    }

    public static double sinc(double x) {
        return x == 0.0 ? 1.0 : Math.sin(Math.PI * x) / (Math.PI * x);
    }

    public static float[] wHanning(int size, float offset) {
        float[] window_table = new float[size];
        for (int k = 0; k < size; ++k) {
            window_table[k] = (float)(-0.5 * Math.cos(Math.PI * 2 * (double)((float)k + offset) / (double)size) + 0.5);
        }
        return window_table;
    }

    public static float[] sincTable(int size, float offset, float scale) {
        int center = size / 2;
        float[] w = SoftSincResampler.wHanning(size, offset);
        for (int k = 0; k < size; ++k) {
            int n = k;
            w[n] = (float)((double)w[n] * (SoftSincResampler.sinc(((float)(-center + k) + offset) * scale) * (double)scale));
        }
        return w;
    }

    public int getPadding() {
        return this.sinc_table_size / 2 + 2;
    }

    public void interpolate(float[] in, float[] in_offset, float in_end, float[] startpitch, float pitchstep, float[] out, int[] out_offset, int out_end) {
        float pitch = startpitch[0];
        float ix = in_offset[0];
        int ox = out_offset[0];
        float ix_end = in_end;
        int ox_end = out_end;
        int max_p = this.sinc_scale_size - 1;
        if (pitchstep == 0.0f) {
            int p = (int)((pitch - 1.0f) * 10.0f);
            if (p < 0) {
                p = 0;
            } else if (p > max_p) {
                p = max_p;
            }
            float[][] sinc_table_f = this.sinc_table[p];
            while (ix < ix_end && ox < ox_end) {
                int iix = (int)ix;
                float[] sinc_table = sinc_table_f[(int)((ix - (float)iix) * (float)this.sinc_table_fsize)];
                int xx = iix - this.sinc_table_center;
                float y = 0.0f;
                int i = 0;
                while (i < this.sinc_table_size) {
                    y += in[xx] * sinc_table[i];
                    ++i;
                    ++xx;
                }
                out[ox++] = y;
                ix += pitch;
            }
        } else {
            while (ix < ix_end && ox < ox_end) {
                int iix = (int)ix;
                int p = (int)((pitch - 1.0f) * 10.0f);
                if (p < 0) {
                    p = 0;
                } else if (p > max_p) {
                    p = max_p;
                }
                float[][] sinc_table_f = this.sinc_table[p];
                float[] sinc_table = sinc_table_f[(int)((ix - (float)iix) * (float)this.sinc_table_fsize)];
                int xx = iix - this.sinc_table_center;
                float y = 0.0f;
                int i = 0;
                while (i < this.sinc_table_size) {
                    y += in[xx] * sinc_table[i];
                    ++i;
                    ++xx;
                }
                out[ox++] = y;
                ix += pitch;
                pitch += pitchstep;
            }
        }
        in_offset[0] = ix;
        out_offset[0] = ox;
        startpitch[0] = pitch;
    }
}

