/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

class COMMarkerSegment
extends MarkerSegment {
    private static final String ENCODING = "ISO-8859-1";

    COMMarkerSegment(JPEGBuffer buffer) throws IOException {
        super(buffer);
        this.loadData(buffer);
    }

    COMMarkerSegment(String comment) {
        super(254);
        this.data = comment.getBytes();
    }

    COMMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(254);
        if (node instanceof IIOMetadataNode) {
            IIOMetadataNode ourNode = (IIOMetadataNode)node;
            this.data = (byte[])ourNode.getUserObject();
        }
        if (this.data == null) {
            String comment = node.getAttributes().getNamedItem("comment").getNodeValue();
            if (comment != null) {
                this.data = comment.getBytes();
            } else {
                throw new IIOInvalidTreeException("Empty comment node!", node);
            }
        }
    }

    String getComment() {
        try {
            return new String(this.data, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode("com");
        node.setAttribute("comment", this.getComment());
        if (this.data != null) {
            node.setUserObject(this.data.clone());
        }
        return node;
    }

    void write(ImageOutputStream ios) throws IOException {
        this.length = 2 + this.data.length;
        this.writeTag(ios);
        ios.write(this.data);
    }

    void print() {
        this.printTag("COM");
        System.out.println("<" + this.getComment() + ">");
    }
}

