/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class AdobeMarkerSegment
extends MarkerSegment {
    int version;
    int flags0;
    int flags1;
    int transform;
    private static final int ID_SIZE = 5;

    AdobeMarkerSegment(int transform) {
        super(238);
        this.version = 101;
        this.flags0 = 0;
        this.flags1 = 0;
        this.transform = transform;
    }

    AdobeMarkerSegment(JPEGBuffer buffer) throws IOException {
        super(buffer);
        buffer.bufPtr += 5;
        this.version = (buffer.buf[buffer.bufPtr++] & 0xFF) << 8;
        this.version |= buffer.buf[buffer.bufPtr++] & 0xFF;
        this.flags0 = (buffer.buf[buffer.bufPtr++] & 0xFF) << 8;
        this.flags0 |= buffer.buf[buffer.bufPtr++] & 0xFF;
        this.flags1 = (buffer.buf[buffer.bufPtr++] & 0xFF) << 8;
        this.flags1 |= buffer.buf[buffer.bufPtr++] & 0xFF;
        this.transform = buffer.buf[buffer.bufPtr++] & 0xFF;
        buffer.bufAvail -= this.length;
    }

    AdobeMarkerSegment(Node node) throws IIOInvalidTreeException {
        this(0);
        this.updateFromNativeNode(node, true);
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode("app14Adobe");
        node.setAttribute("version", Integer.toString(this.version));
        node.setAttribute("flags0", Integer.toString(this.flags0));
        node.setAttribute("flags1", Integer.toString(this.flags1));
        node.setAttribute("transform", Integer.toString(this.transform));
        return node;
    }

    void updateFromNativeNode(Node node, boolean fromScratch) throws IIOInvalidTreeException {
        NamedNodeMap attrs = node.getAttributes();
        this.transform = AdobeMarkerSegment.getAttributeValue(node, attrs, "transform", 0, 2, true);
        int count = attrs.getLength();
        if (count > 4) {
            throw new IIOInvalidTreeException("Adobe APP14 node cannot have > 4 attributes", node);
        }
        if (count > 1) {
            int value = AdobeMarkerSegment.getAttributeValue(node, attrs, "version", 100, 255, false);
            this.version = value != -1 ? value : this.version;
            value = AdobeMarkerSegment.getAttributeValue(node, attrs, "flags0", 0, 65535, false);
            this.flags0 = value != -1 ? value : this.flags0;
            value = AdobeMarkerSegment.getAttributeValue(node, attrs, "flags1", 0, 65535, false);
            this.flags1 = value != -1 ? value : this.flags1;
        }
    }

    void write(ImageOutputStream ios) throws IOException {
        this.length = 14;
        this.writeTag(ios);
        byte[] id = new byte[]{65, 100, 111, 98, 101};
        ios.write(id);
        AdobeMarkerSegment.write2bytes(ios, this.version);
        AdobeMarkerSegment.write2bytes(ios, this.flags0);
        AdobeMarkerSegment.write2bytes(ios, this.flags1);
        ios.write(this.transform);
    }

    static void writeAdobeSegment(ImageOutputStream ios, int transform) throws IOException {
        new AdobeMarkerSegment(transform).write(ios);
    }

    void print() {
        this.printTag("Adobe APP14");
        System.out.print("Version: ");
        System.out.println(this.version);
        System.out.print("Flags0: 0x");
        System.out.println(Integer.toHexString(this.flags0));
        System.out.print("Flags1: 0x");
        System.out.println(Integer.toHexString(this.flags1));
        System.out.print("Transform: ");
        System.out.println(this.transform);
    }
}

