/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.CommandHandler;
import com.sun.corba.se.impl.activation.ServerTool;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.Activator;
import com.sun.corba.se.spi.activation.ActivatorHelper;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class ListORBs
implements CommandHandler {
    static final int illegalServerId = -1;

    ListORBs() {
    }

    public String getCommandName() {
        return "orblist";
    }

    public void printCommandHelp(PrintStream out, boolean helpType) {
        if (!helpType) {
            out.println(CorbaResourceUtil.getText("servertool.orbidmap"));
        } else {
            out.println(CorbaResourceUtil.getText("servertool.orbidmap1"));
        }
    }

    public boolean processCommand(String[] cmdArgs, ORB orb, PrintStream out) {
        int serverId = -1;
        try {
            if (cmdArgs.length == 2) {
                if (cmdArgs[0].equals("-serverid")) {
                    serverId = Integer.valueOf(cmdArgs[1]);
                } else if (cmdArgs[0].equals("-applicationName")) {
                    serverId = ServerTool.getServerIdForAlias(orb, cmdArgs[1]);
                }
            }
            if (serverId == -1) {
                return true;
            }
            Activator activator = ActivatorHelper.narrow(orb.resolve_initial_references("ServerActivator"));
            String[] orbList = activator.getORBNames(serverId);
            out.println(CorbaResourceUtil.getText("servertool.orbidmap2"));
            for (int i = 0; i < orbList.length; ++i) {
                out.println("\t " + orbList[i]);
            }
        }
        catch (ServerNotRegistered ex) {
            out.println("\tno such server found.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

