/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.ext.CompoundTextSupport;

public class COMPOUND_TEXT_Decoder
extends CharsetDecoder {
    private static final int NORMAL_BYTES = 0;
    private static final int NONSTANDARD_BYTES = 1;
    private static final int VERSION_SEQUENCE_V = 2;
    private static final int VERSION_SEQUENCE_TERM = 3;
    private static final int ESCAPE_SEQUENCE = 4;
    private static final int CHARSET_NGIIF = 5;
    private static final int CHARSET_NLIIF = 6;
    private static final int CHARSET_NLIF = 7;
    private static final int CHARSET_NRIIF = 8;
    private static final int CHARSET_NRIF = 9;
    private static final int CHARSET_NONSTANDARD_FOML = 10;
    private static final int CHARSET_NONSTANDARD_OML = 11;
    private static final int CHARSET_NONSTANDARD_ML = 12;
    private static final int CHARSET_NONSTANDARD_L = 13;
    private static final int CHARSET_NONSTANDARD = 14;
    private static final int CHARSET_LIIF = 15;
    private static final int CHARSET_LIF = 16;
    private static final int CHARSET_RIIF = 17;
    private static final int CHARSET_RIF = 18;
    private static final int CONTROL_SEQUENCE_PIF = 19;
    private static final int CONTROL_SEQUENCE_IF = 20;
    private static final int EXTENSION_ML = 21;
    private static final int EXTENSION_L = 22;
    private static final int EXTENSION = 23;
    private static final int ESCAPE_SEQUENCE_OTHER = 24;
    private static final String ERR_LATIN1 = "ISO8859_1 unsupported";
    private static final String ERR_ILLSTATE = "Illegal state";
    private static final String ERR_ESCBYTE = "Illegal byte in 0x1B escape sequence";
    private static final String ERR_ENCODINGBYTE = "Illegal byte in non-standard character set name";
    private static final String ERR_CTRLBYTE = "Illegal byte in 0x9B control sequence";
    private static final String ERR_CTRLPI = "P following I in 0x9B control sequence";
    private static final String ERR_VERSTART = "Versioning escape sequence can only appear at start of byte stream";
    private static final String ERR_VERMANDATORY = "Cannot parse mandatory extensions";
    private static final String ERR_ENCODING = "Unknown encoding: ";
    private static final String ERR_FLUSH = "Escape sequence, control sequence, or ML extension not terminated";
    private int state = 0;
    private int ext_count;
    private int ext_offset;
    private boolean versionSequenceAllowed = true;
    private byte[] byteBuf = new byte[1];
    private ByteBuffer inBB = ByteBuffer.allocate(16);
    private ByteArrayOutputStream queue = new ByteArrayOutputStream();
    private ByteArrayOutputStream encodingQueue = new ByteArrayOutputStream();
    private CharsetDecoder glDecoder;
    private CharsetDecoder grDecoder;
    private CharsetDecoder nonStandardDecoder;
    private CharsetDecoder lastDecoder;
    private boolean glHigh = false;
    private boolean grHigh = true;
    private ByteBuffer fbb = ByteBuffer.allocate(0);

    public COMPOUND_TEXT_Decoder(Charset cs) {
        super(cs, 1.0f, 1.0f);
        try {
            this.glDecoder = Charset.forName("ASCII").newDecoder();
            this.grDecoder = Charset.forName("ISO8859_1").newDecoder();
        }
        catch (IllegalArgumentException e) {
            this.error(ERR_LATIN1);
        }
        this.initDecoder(this.glDecoder);
        this.initDecoder(this.grDecoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult decodeLoop(ByteBuffer src, CharBuffer des) {
        int inOff;
        CoderResult cr = CoderResult.UNDERFLOW;
        byte[] input = src.array();
        int inEnd = src.arrayOffset() + src.limit();
        try {
            for (inOff = src.arrayOffset() + src.position(); inOff < inEnd && cr.isUnderflow(); ++inOff) {
                cr = this.handleByte((short)(input[inOff] & 0xFF), des);
            }
            CoderResult coderResult = cr;
            return coderResult;
        }
        finally {
            src.position(inOff - src.arrayOffset());
        }
    }

    private CoderResult handleByte(short newByte, CharBuffer cb) {
        CoderResult cr = CoderResult.UNDERFLOW;
        switch (this.state) {
            case 0: {
                cr = this.normalBytes(newByte, cb);
                break;
            }
            case 1: {
                cr = this.nonStandardBytes(newByte, cb);
                break;
            }
            case 2: 
            case 3: {
                cr = this.versionSequence(newByte);
                break;
            }
            case 4: {
                cr = this.escapeSequence(newByte);
                break;
            }
            case 5: {
                cr = this.charset94N(newByte);
                break;
            }
            case 6: 
            case 7: {
                cr = this.charset94NL(newByte, cb);
                break;
            }
            case 8: 
            case 9: {
                cr = this.charset94NR(newByte, cb);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                cr = this.charsetNonStandard(newByte, cb);
                break;
            }
            case 15: 
            case 16: {
                cr = this.charset9496L(newByte, cb);
                break;
            }
            case 17: 
            case 18: {
                cr = this.charset9496R(newByte, cb);
                break;
            }
            case 19: 
            case 20: {
                cr = this.controlSequence(newByte);
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                cr = this.extension(newByte);
                break;
            }
            case 24: {
                cr = this.escapeSequenceOther(newByte);
                break;
            }
            default: {
                this.error(ERR_ILLSTATE);
            }
        }
        return cr;
    }

    private CoderResult normalBytes(short newByte, CharBuffer cb) {
        CoderResult cr = CoderResult.UNDERFLOW;
        if (newByte >= 0 && newByte <= 31 || newByte >= 128 && newByte <= 159) {
            char newChar;
            switch (newByte) {
                case 27: {
                    this.state = 4;
                    this.queue.write(newByte);
                    return cr;
                }
                case 155: {
                    this.state = 19;
                    this.versionSequenceAllowed = false;
                    this.queue.write(newByte);
                    return cr;
                }
                case 9: {
                    this.versionSequenceAllowed = false;
                    newChar = '\t';
                    break;
                }
                case 10: {
                    this.versionSequenceAllowed = false;
                    newChar = '\n';
                    break;
                }
                default: {
                    this.versionSequenceAllowed = false;
                    return cr;
                }
            }
            if (!cb.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            cb.put(newChar);
        } else {
            boolean high;
            CharsetDecoder decoder;
            this.versionSequenceAllowed = false;
            if (newByte >= 32 && newByte <= 127) {
                decoder = this.glDecoder;
                high = this.glHigh;
            } else {
                decoder = this.grDecoder;
                high = this.grHigh;
            }
            if (this.lastDecoder != null && decoder != this.lastDecoder) {
                cr = this.flushDecoder(this.lastDecoder, cb);
            }
            this.lastDecoder = decoder;
            if (decoder != null) {
                byte b = (byte)newByte;
                b = high ? (byte)(b | 0x80) : (byte)(b & 0x7F);
                this.inBB.put(b);
                this.inBB.flip();
                cr = decoder.decode(this.inBB, cb, false);
                if (!this.inBB.hasRemaining() || cr.isMalformed()) {
                    this.inBB.clear();
                } else {
                    int pos = this.inBB.limit();
                    this.inBB.clear();
                    this.inBB.position(pos);
                }
            } else if (cb.remaining() < this.replacement().length()) {
                cb.put(this.replacement());
            } else {
                return CoderResult.OVERFLOW;
            }
        }
        return cr;
    }

    private CoderResult nonStandardBytes(short newByte, CharBuffer cb) {
        CoderResult cr = CoderResult.UNDERFLOW;
        if (this.nonStandardDecoder != null) {
            this.inBB.put((byte)newByte);
            this.inBB.flip();
            cr = this.nonStandardDecoder.decode(this.inBB, cb, false);
            if (!this.inBB.hasRemaining()) {
                this.inBB.clear();
            } else {
                int pos = this.inBB.limit();
                this.inBB.clear();
                this.inBB.position(pos);
            }
        } else if (cb.remaining() < this.replacement().length()) {
            cb.put(this.replacement());
        } else {
            return CoderResult.OVERFLOW;
        }
        ++this.ext_offset;
        if (this.ext_offset >= this.ext_count) {
            this.ext_count = 0;
            this.ext_offset = 0;
            this.state = 0;
            cr = this.flushDecoder(this.nonStandardDecoder, cb);
            this.nonStandardDecoder = null;
        }
        return cr;
    }

    private CoderResult escapeSequence(short newByte) {
        switch (newByte) {
            case 35: {
                this.state = 2;
                break;
            }
            case 36: {
                this.state = 5;
                this.versionSequenceAllowed = false;
                break;
            }
            case 37: {
                this.state = 10;
                this.versionSequenceAllowed = false;
                break;
            }
            case 40: {
                this.state = 15;
                this.versionSequenceAllowed = false;
                break;
            }
            case 41: 
            case 45: {
                this.state = 17;
                this.versionSequenceAllowed = false;
                break;
            }
            default: {
                return this.escapeSequenceOther(newByte);
            }
        }
        this.queue.write(newByte);
        return CoderResult.UNDERFLOW;
    }

    private CoderResult escapeSequenceOther(short newByte) {
        if (newByte >= 32 && newByte <= 47) {
            this.state = 24;
            this.versionSequenceAllowed = false;
            this.queue.write(newByte);
        } else if (newByte >= 48 && newByte <= 126) {
            this.state = 0;
            this.versionSequenceAllowed = false;
            this.queue.reset();
        } else {
            return this.malformedInput(ERR_ESCBYTE);
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult controlSequence(short newByte) {
        if (newByte >= 48 && newByte <= 63) {
            if (this.state == 20) {
                return this.malformedInput(ERR_CTRLPI);
            }
            this.queue.write(newByte);
        } else if (newByte >= 32 && newByte <= 47) {
            this.state = 20;
            this.queue.write(newByte);
        } else if (newByte >= 64 && newByte <= 126) {
            this.state = 0;
            this.queue.reset();
        } else {
            return this.malformedInput(ERR_CTRLBYTE);
        }
        return CoderResult.UNDERFLOW;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoderResult versionSequence(short newByte) {
        if (this.state == 2) {
            if (newByte < 32 || newByte > 47) return this.escapeSequenceOther(newByte);
            this.state = 3;
            this.queue.write(newByte);
            return CoderResult.UNDERFLOW;
        } else {
            switch (newByte) {
                case 48: {
                    if (!this.versionSequenceAllowed) {
                        return this.malformedInput(ERR_VERSTART);
                    }
                    this.versionSequenceAllowed = false;
                    this.state = 0;
                    this.queue.reset();
                    return CoderResult.UNDERFLOW;
                }
                case 49: {
                    return this.malformedInput(this.versionSequenceAllowed ? ERR_VERMANDATORY : ERR_VERSTART);
                }
                default: {
                    return this.escapeSequenceOther(newByte);
                }
            }
        }
    }

    private CoderResult charset94N(short newByte) {
        switch (newByte) {
            case 40: {
                this.state = 6;
                break;
            }
            case 41: {
                this.state = 8;
                break;
            }
            default: {
                return this.escapeSequenceOther(newByte);
            }
        }
        this.queue.write(newByte);
        return CoderResult.UNDERFLOW;
    }

    private CoderResult charset94NL(short newByte, CharBuffer cb) {
        if (newByte < 33 || newByte > (this.state == 6 ? (short)35 : 47)) {
            if (newByte >= 64 && newByte <= 126) {
                return this.switchDecoder(newByte, cb);
            }
            return this.escapeSequenceOther(newByte);
        }
        this.state = 7;
        this.queue.write(newByte);
        return CoderResult.UNDERFLOW;
    }

    private CoderResult charset94NR(short newByte, CharBuffer cb) {
        if (newByte < 33 || newByte > (this.state == 8 ? (short)35 : 47)) {
            if (newByte >= 64 && newByte <= 126) {
                return this.switchDecoder(newByte, cb);
            }
            return this.escapeSequenceOther(newByte);
        }
        this.state = 9;
        this.queue.write(newByte);
        return CoderResult.UNDERFLOW;
    }

    private CoderResult charset9496L(short newByte, CharBuffer cb) {
        if (newByte >= 33 && newByte <= (this.state == 15 ? (short)35 : 47)) {
            this.state = 16;
            this.queue.write(newByte);
            return CoderResult.UNDERFLOW;
        }
        if (newByte >= 64 && newByte <= 126) {
            return this.switchDecoder(newByte, cb);
        }
        return this.escapeSequenceOther(newByte);
    }

    private CoderResult charset9496R(short newByte, CharBuffer cb) {
        if (newByte >= 33 && newByte <= (this.state == 17 ? (short)35 : 47)) {
            this.state = 18;
            this.queue.write(newByte);
            return CoderResult.UNDERFLOW;
        }
        if (newByte >= 64 && newByte <= 126) {
            return this.switchDecoder(newByte, cb);
        }
        return this.escapeSequenceOther(newByte);
    }

    private CoderResult charsetNonStandard(short newByte, CharBuffer cb) {
        switch (this.state) {
            case 10: {
                if (newByte == 47) {
                    this.state = 11;
                    this.queue.write(newByte);
                    break;
                }
                return this.escapeSequenceOther(newByte);
            }
            case 11: {
                if (newByte >= 48 && newByte <= 52) {
                    this.state = 12;
                    this.queue.write(newByte);
                    break;
                }
                if (newByte >= 53 && newByte <= 63) {
                    this.state = 21;
                    this.queue.write(newByte);
                    break;
                }
                return this.escapeSequenceOther(newByte);
            }
            case 12: {
                this.ext_count = (newByte & 0x7F) * 128;
                this.state = 13;
                break;
            }
            case 13: {
                this.ext_count += newByte & 0x7F;
                this.state = this.ext_count > 0 ? 14 : 0;
                break;
            }
            case 14: {
                if (newByte == 63 || newByte == 42) {
                    this.queue.reset();
                    return this.malformedInput(ERR_ENCODINGBYTE);
                }
                ++this.ext_offset;
                if (this.ext_offset >= this.ext_count) {
                    this.ext_count = 0;
                    this.ext_offset = 0;
                    this.state = 0;
                    this.queue.reset();
                    this.encodingQueue.reset();
                    break;
                }
                if (newByte == 2) {
                    return this.switchDecoder((short)0, cb);
                }
                this.encodingQueue.write(newByte);
                break;
            }
            default: {
                this.error(ERR_ILLSTATE);
            }
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult extension(short newByte) {
        switch (this.state) {
            case 21: {
                this.ext_count = (newByte & 0x7F) * 128;
                this.state = 22;
                break;
            }
            case 22: {
                this.ext_count += newByte & 0x7F;
                this.state = this.ext_count > 0 ? 23 : 0;
                break;
            }
            case 23: {
                ++this.ext_offset;
                if (this.ext_offset < this.ext_count) break;
                this.ext_count = 0;
                this.ext_offset = 0;
                this.state = 0;
                this.queue.reset();
                break;
            }
            default: {
                this.error(ERR_ILLSTATE);
            }
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult switchDecoder(short lastByte, CharBuffer cb) {
        CoderResult cr = CoderResult.UNDERFLOW;
        CharsetDecoder decoder = null;
        boolean high = false;
        byte[] encoding = null;
        if (lastByte != 0) {
            this.queue.write(lastByte);
        }
        byte[] escSequence = this.queue.toByteArray();
        this.queue.reset();
        if (this.state == 14) {
            encoding = this.encodingQueue.toByteArray();
            this.encodingQueue.reset();
            decoder = CompoundTextSupport.getNonStandardDecoder(escSequence, encoding);
        } else {
            decoder = CompoundTextSupport.getStandardDecoder(escSequence);
            high = CompoundTextSupport.getHighBit(escSequence);
        }
        if (decoder != null) {
            this.initDecoder(decoder);
        } else if (this.unmappableCharacterAction() == CodingErrorAction.REPORT) {
            int badInputLength = 1;
            if (encoding != null) {
                badInputLength = encoding.length;
            } else if (escSequence.length > 0) {
                badInputLength = escSequence.length;
            }
            return CoderResult.unmappableForLength(badInputLength);
        }
        if (this.state == 6 || this.state == 7 || this.state == 15 || this.state == 16) {
            if (this.lastDecoder == this.glDecoder) {
                cr = this.flushDecoder(this.glDecoder, cb);
            }
            this.glDecoder = this.lastDecoder = decoder;
            this.glHigh = high;
            this.state = 0;
        } else if (this.state == 8 || this.state == 9 || this.state == 17 || this.state == 18) {
            if (this.lastDecoder == this.grDecoder) {
                cr = this.flushDecoder(this.grDecoder, cb);
            }
            this.grDecoder = this.lastDecoder = decoder;
            this.grHigh = high;
            this.state = 0;
        } else if (this.state == 14) {
            if (this.lastDecoder != null) {
                cr = this.flushDecoder(this.lastDecoder, cb);
                this.lastDecoder = null;
            }
            this.nonStandardDecoder = decoder;
            this.state = 1;
        } else {
            this.error(ERR_ILLSTATE);
        }
        return cr;
    }

    private CoderResult flushDecoder(CharsetDecoder dec, CharBuffer cb) {
        dec.decode(this.fbb, cb, true);
        CoderResult cr = dec.flush(cb);
        dec.reset();
        return cr;
    }

    private CoderResult malformedInput(String msg) {
        int badInputLength = this.queue.size() + 1;
        this.queue.reset();
        return CoderResult.malformedForLength(badInputLength);
    }

    private void error(String msg) {
        throw new InternalError(msg);
    }

    protected CoderResult implFlush(CharBuffer out) {
        CoderResult cr = CoderResult.UNDERFLOW;
        if (this.lastDecoder != null) {
            cr = this.flushDecoder(this.lastDecoder, out);
        }
        if (this.state != 0) {
            cr = CoderResult.malformedForLength(0);
        }
        this.reset();
        return cr;
    }

    protected void implReset() {
        this.state = 0;
        this.ext_offset = 0;
        this.ext_count = 0;
        this.versionSequenceAllowed = true;
        this.queue.reset();
        this.encodingQueue.reset();
        this.lastDecoder = null;
        this.nonStandardDecoder = null;
        this.glHigh = false;
        this.grHigh = true;
        try {
            this.glDecoder = Charset.forName("ASCII").newDecoder();
            this.grDecoder = Charset.forName("ISO8859_1").newDecoder();
        }
        catch (IllegalArgumentException e) {
            this.error(ERR_LATIN1);
        }
        this.initDecoder(this.glDecoder);
        this.initDecoder(this.grDecoder);
    }

    protected void implOnMalformedInput(CodingErrorAction newAction) {
        if (this.glDecoder != null) {
            this.glDecoder.onMalformedInput(newAction);
        }
        if (this.grDecoder != null) {
            this.grDecoder.onMalformedInput(newAction);
        }
        if (this.nonStandardDecoder != null) {
            this.nonStandardDecoder.onMalformedInput(newAction);
        }
    }

    protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
        if (this.glDecoder != null) {
            this.glDecoder.onUnmappableCharacter(newAction);
        }
        if (this.grDecoder != null) {
            this.grDecoder.onUnmappableCharacter(newAction);
        }
        if (this.nonStandardDecoder != null) {
            this.nonStandardDecoder.onUnmappableCharacter(newAction);
        }
    }

    protected void implReplaceWith(String newReplacement) {
        if (this.glDecoder != null) {
            this.glDecoder.replaceWith(newReplacement);
        }
        if (this.grDecoder != null) {
            this.grDecoder.replaceWith(newReplacement);
        }
        if (this.nonStandardDecoder != null) {
            this.nonStandardDecoder.replaceWith(newReplacement);
        }
    }

    private void initDecoder(CharsetDecoder dec) {
        dec.onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(this.replacement());
    }
}

