/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class CipherSpi {
    protected abstract void engineSetMode(String var1) throws NoSuchAlgorithmException;

    protected abstract void engineSetPadding(String var1) throws NoSuchPaddingException;

    protected abstract int engineGetBlockSize();

    protected abstract int engineGetOutputSize(int var1);

    protected abstract byte[] engineGetIV();

    protected abstract AlgorithmParameters engineGetParameters();

    protected abstract void engineInit(int var1, Key var2, SecureRandom var3) throws InvalidKeyException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameterSpec var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract void engineInit(int var1, Key var2, AlgorithmParameters var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract byte[] engineUpdate(byte[] var1, int var2, int var3);

    protected abstract int engineUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException;

    protected int engineUpdate(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        try {
            return this.bufferCrypt(input, output, true);
        }
        catch (IllegalBlockSizeException e) {
            throw new ProviderException("Internal error in update()");
        }
        catch (BadPaddingException e) {
            throw new ProviderException("Internal error in update()");
        }
    }

    protected abstract byte[] engineDoFinal(byte[] var1, int var2, int var3) throws IllegalBlockSizeException, BadPaddingException;

    protected abstract int engineDoFinal(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException;

    protected int engineDoFinal(ByteBuffer input, ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.bufferCrypt(input, output, false);
    }

    static int getTempArraySize(int totalSize) {
        return Math.min(4096, totalSize);
    }

    private int bufferCrypt(ByteBuffer input, ByteBuffer output, boolean isUpdate) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int inOfs;
        byte[] inArray;
        int inLen;
        if (input == null || output == null) {
            throw new NullPointerException("Input and output buffers must not be null");
        }
        int inPos = input.position();
        int inLimit = input.limit();
        if (isUpdate && inLen == 0) {
            return 0;
        }
        int outLenNeeded = this.engineGetOutputSize(inLen);
        if (output.remaining() < outLenNeeded) {
            throw new ShortBufferException("Need at least " + outLenNeeded + " bytes of space in output buffer");
        }
        boolean a1 = input.hasArray();
        boolean a2 = output.hasArray();
        if (a1 && a2) {
            byte[] inArray2 = input.array();
            int inOfs2 = input.arrayOffset() + inPos;
            byte[] outArray = output.array();
            int outPos = output.position();
            int outOfs = output.arrayOffset() + outPos;
            int n = isUpdate ? this.engineUpdate(inArray2, inOfs2, inLen, outArray, outOfs) : this.engineDoFinal(inArray2, inOfs2, inLen, outArray, outOfs);
            input.position(inLimit);
            output.position(outPos + n);
            return n;
        }
        if (!a1 && a2) {
            int chunk;
            int outPos = output.position();
            byte[] outArray = output.array();
            int outOfs = output.arrayOffset() + outPos;
            byte[] inArray3 = new byte[CipherSpi.getTempArraySize(inLen)];
            int total = 0;
            for (inLen = inLimit - inPos; inLen > 0; inLen -= chunk) {
                chunk = Math.min(inLen, inArray3.length);
                input.get(inArray3, 0, chunk);
                int n = isUpdate || inLen != chunk ? this.engineUpdate(inArray3, 0, chunk, outArray, outOfs) : this.engineDoFinal(inArray3, 0, chunk, outArray, outOfs);
                total += n;
                outOfs += n;
            }
            output.position(outPos + total);
            return total;
        }
        if (a1) {
            inArray = input.array();
            inOfs = input.arrayOffset() + inPos;
        } else {
            inArray = new byte[CipherSpi.getTempArraySize(inLen)];
            inOfs = 0;
        }
        byte[] outArray = new byte[CipherSpi.getTempArraySize(outLenNeeded)];
        int outSize = outArray.length;
        int total = 0;
        boolean resized = false;
        while (inLen > 0) {
            int chunk = Math.min(inLen, outSize);
            if (!a1 && !resized) {
                input.get(inArray, 0, chunk);
                inOfs = 0;
            }
            try {
                int n = isUpdate || inLen != chunk ? this.engineUpdate(inArray, inOfs, chunk, outArray, 0) : this.engineDoFinal(inArray, inOfs, chunk, outArray, 0);
                resized = false;
                inOfs += chunk;
                inLen -= chunk;
                output.put(outArray, 0, n);
                total += n;
            }
            catch (ShortBufferException e) {
                if (resized) {
                    throw (ProviderException)new ProviderException("Could not determine buffer size").initCause(e);
                }
                resized = true;
                int newOut = this.engineGetOutputSize(chunk);
                outArray = new byte[newOut];
            }
        }
        input.position(inLimit);
        return total;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException();
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }
}

