/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.util.concurrent.Semaphore;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioLine;
import org.classpath.icedtea.pulseaudio.PulseAudioMixer;
import org.classpath.icedtea.pulseaudio.Stream;

abstract class PulseAudioDataLine
extends PulseAudioLine
implements DataLine {
    protected static final int DEFAULT_BUFFER_SIZE = 50000;
    protected String streamName;
    protected boolean isStarted = false;
    protected boolean dataWritten = false;
    protected AudioFormat[] supportedFormats = null;
    protected AudioFormat currentFormat = null;
    protected AudioFormat defaultFormat = null;
    protected boolean sendEvents = true;
    protected int bufferSize = 0;
    protected long framesSinceOpen = 0L;
    protected EventLoop eventLoop = null;
    protected Semaphore semaphore = new Semaphore(0);
    protected Stream stream;
    boolean writeInterrupted = false;

    PulseAudioDataLine() {
    }

    protected void open(AudioFormat format, int bufferSize) throws LineUnavailableException {
        if (this.isOpen()) {
            throw new IllegalStateException("Line is already open");
        }
        PulseAudioMixer mixer = PulseAudioMixer.getInstance();
        if (!mixer.isOpen()) {
            mixer.open();
        }
        this.eventLoop = EventLoop.getEventLoop();
        this.createStream(format);
        this.addStreamListeners();
        this.connect(null, bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStream(AudioFormat format) throws LineUnavailableException {
        for (AudioFormat myFormat : this.supportedFormats) {
            if (!format.matches(myFormat)) continue;
            float sampleRate = format.getSampleRate();
            if (sampleRate == -1.0f) {
                sampleRate = 44100.0f;
            }
            String formatString = (String)myFormat.getProperty("PulseAudioFormatKey");
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                this.stream = new Stream(this.eventLoop.getContextPointer(), this.streamName, Stream.Format.valueOf(formatString), (int)sampleRate, myFormat.getChannels());
            }
            this.currentFormat = format;
            this.isOpen = true;
        }
        if (!this.isOpen()) {
            throw new IllegalArgumentException("Invalid format");
        }
    }

    private void addStreamListeners() {
        Stream.StateListener openCloseListener = new Stream.StateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update() {
                Object object = PulseAudioDataLine.this.eventLoop.threadLock;
                synchronized (object) {
                    if (PulseAudioDataLine.this.stream.getState() == Stream.State.READY) {
                        if (PulseAudioDataLine.this.sendEvents) {
                            PulseAudioDataLine.this.fireLineEvent(new LineEvent(PulseAudioDataLine.this, LineEvent.Type.OPEN, PulseAudioDataLine.this.framesSinceOpen));
                        }
                        PulseAudioDataLine.this.semaphore.release();
                    } else if (PulseAudioDataLine.this.stream.getState() == Stream.State.TERMINATED || PulseAudioDataLine.this.stream.getState() == Stream.State.FAILED) {
                        if (PulseAudioDataLine.this.sendEvents) {
                            PulseAudioDataLine.this.fireLineEvent(new LineEvent(PulseAudioDataLine.this, LineEvent.Type.CLOSE, PulseAudioDataLine.this.framesSinceOpen));
                        }
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.notifyAll();
                        }
                        PulseAudioDataLine.this.semaphore.release();
                    }
                }
            }
        };
        this.stream.addStateListener(openCloseListener);
        Stream.UnderflowListener stoppedListener = new Stream.UnderflowListener(){

            @Override
            public void update() {
                PulseAudioDataLine.this.dataWritten = false;
                PulseAudioDataLine.this.fireLineEvent(new LineEvent(PulseAudioDataLine.this, LineEvent.Type.STOP, PulseAudioDataLine.this.framesSinceOpen));
            }
        };
        this.stream.addUnderflowListener(stoppedListener);
        Stream.PlaybackStartedListener startedListener = new Stream.PlaybackStartedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update() {
                if (!PulseAudioDataLine.this.dataWritten) {
                    PulseAudioDataLine.this.fireLineEvent(new LineEvent(PulseAudioDataLine.this, LineEvent.Type.START, PulseAudioDataLine.this.framesSinceOpen));
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        this.notifyAll();
                    }
                }
                PulseAudioDataLine.this.dataWritten = true;
            }
        };
        this.stream.addPlaybackStartedListener(startedListener);
        Stream.WriteListener writeNotifier = new Stream.WriteListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update() {
                Object object = PulseAudioDataLine.this.eventLoop.threadLock;
                synchronized (object) {
                    PulseAudioDataLine.this.eventLoop.threadLock.notifyAll();
                }
            }
        };
        this.stream.addWriteListener(writeNotifier);
        Stream.CorkListener corkListener = new Stream.CorkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update() {
                Object object = PulseAudioDataLine.this.eventLoop.threadLock;
                synchronized (object) {
                    PulseAudioDataLine.this.eventLoop.threadLock.notifyAll();
                }
            }
        };
        this.stream.addCorkListener(corkListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(Stream masterStream, int bufferSize) throws LineUnavailableException {
        try {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                this.connectLine(bufferSize, masterStream);
            }
        }
        catch (LineUnavailableException e) {
            this.stream.free();
            this.stream = null;
            throw e;
        }
        this.bufferSize = bufferSize;
        try {
            this.semaphore.acquire();
            Object e = this.eventLoop.threadLock;
            synchronized (e) {
                if (this.stream.getState() != Stream.State.READY) {
                    this.stream.disconnect();
                    this.stream.free();
                    throw new LineUnavailableException("unable to obtain a line");
                }
            }
        }
        catch (InterruptedException e) {
            throw new LineUnavailableException("unable to prepare stream");
        }
    }

    protected void open(AudioFormat format) throws LineUnavailableException {
        this.open(format, 50000);
    }

    @Override
    public void open() throws LineUnavailableException {
        assert (this.defaultFormat != null);
        this.open(this.defaultFormat, 50000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.disconnect();
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("unable to prepare stream");
        }
        object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.free();
        }
        super.close();
        this.isStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnectforSynchronization(Stream masterStream) throws LineUnavailableException {
        this.sendEvents = false;
        this.drain();
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.stream.disconnect();
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("unable to prepare stream");
        }
        this.createStream(this.getFormat());
        this.addStreamListeners();
        this.connect(masterStream, this.getBufferSize());
        this.sendEvents = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Operation op;
        if (!this.isOpen()) {
            throw new IllegalStateException("Line must be open()ed before it can be start()ed");
        }
        if (this.isStarted) {
            return;
        }
        if (this.dataWritten && !this.isStarted) {
            this.fireLineEvent(new LineEvent(this, LineEvent.Type.START, this.framesSinceOpen));
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            op = this.stream.unCork();
        }
        op.waitForCompletion();
        op.releaseReference();
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
        this.isStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        Operation op;
        if (!this.isOpen()) {
            return;
        }
        this.writeInterrupted = true;
        if (!this.isStarted) {
            return;
        }
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            op = this.stream.cork();
            if (this.dataWritten && this.isStarted) {
                this.fireLineEvent(new LineEvent(this, LineEvent.Type.STOP, this.framesSinceOpen));
            }
        }
        op.waitForCompletion();
        op.releaseReference();
        this.isStarted = false;
    }

    @Override
    public boolean isActive() {
        return this.isStarted;
    }

    @Override
    public boolean isRunning() {
        return this.isStarted && this.dataWritten;
    }

    protected abstract void connectLine(int var1, Stream var2) throws LineUnavailableException;

    public Stream getStream() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Line must be open");
        }
        return this.stream;
    }

    @Override
    public int getBufferSize() {
        if (!this.isOpen()) {
            return 50000;
        }
        return this.bufferSize;
    }

    @Override
    public AudioFormat getFormat() {
        if (!this.isOpen()) {
            return this.defaultFormat;
        }
        return this.currentFormat;
    }

    @Override
    public float getLevel() {
        return -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String streamName) {
        if (this.isOpen()) {
            Operation o;
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                o = this.stream.setName(streamName);
            }
            o.waitForCompletion();
            o.releaseReference();
        }
        this.streamName = streamName;
    }

    public String getName() {
        return this.streamName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytesInBuffer() {
        Operation o;
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            o = this.stream.updateTimingInfo();
        }
        o.waitForCompletion();
        o.releaseReference();
        return this.stream.bytesInBuffer();
    }
}

