/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultCaret;

public class HTMLPane
extends JEditorPane {
    private boolean hasSelection = false;

    public HTMLPane() {
        this.setContentType("text/html");
        this.setEditable(false);
        ((DefaultCaret)this.getCaret()).setUpdatePolicy(1);
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                HTMLPane.this.setHasSelection(e.getDot() != e.getMark());
            }
        });
    }

    public synchronized void setHasSelection(boolean b) {
        this.hasSelection = b;
    }

    public synchronized boolean getHasSelection() {
        return this.hasSelection;
    }

    public void setText(String text) {
        if (!this.getHasSelection()) {
            String textColor = String.format("%06x", this.getForeground().getRGB() & 0xFFFFFF);
            super.setText("<html><body text=#" + textColor + ">" + text + "</body></html>");
        }
    }
}

