/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbKdcRep;
import sun.security.krb5.internal.ASRep;
import sun.security.krb5.internal.ASReq;
import sun.security.krb5.internal.EncASRepPart;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.EType;
import sun.security.util.DerValue;

public class KrbAsRep
extends KrbKdcRep {
    private ASRep rep;
    private Credentials creds;
    private boolean DEBUG = Krb5.DEBUG;

    KrbAsRep(byte[] ibuf, EncryptionKey[] keys, KrbAsReq asReq) throws KrbException, Asn1Exception, IOException {
        if (keys == null) {
            throw new KrbException(400);
        }
        DerValue encoding = new DerValue(ibuf);
        ASReq req = asReq.getMessage();
        ASRep rep = null;
        try {
            rep = new ASRep(encoding);
        }
        catch (Asn1Exception e) {
            KrbException ke;
            rep = null;
            KRBError err = new KRBError(encoding);
            String errStr = err.getErrorString();
            String eText = null;
            if (errStr != null && errStr.length() > 0) {
                eText = errStr.charAt(errStr.length() - 1) == '\u0000' ? errStr.substring(0, errStr.length() - 1) : errStr;
            }
            if (eText == null) {
                ke = new KrbException(err);
            } else {
                if (this.DEBUG) {
                    System.out.println("KRBError received: " + eText);
                }
                ke = new KrbException(err, eText);
            }
            ke.initCause(e);
            throw ke;
        }
        int encPartKeyType = rep.encPart.getEType();
        EncryptionKey dkey = EncryptionKey.findKey(encPartKeyType, keys);
        if (dkey == null) {
            throw new KrbException(400, "Cannot find key of appropriate type to decrypt AS REP - " + EType.toString(encPartKeyType));
        }
        byte[] enc_as_rep_bytes = rep.encPart.decrypt(dkey, 3);
        byte[] enc_as_rep_part = rep.encPart.reset(enc_as_rep_bytes, true);
        encoding = new DerValue(enc_as_rep_part);
        EncASRepPart enc_part = new EncASRepPart(encoding);
        rep.ticket.sname.setRealm(rep.ticket.realm);
        rep.encKDCRepPart = enc_part;
        KrbAsRep.check(req, rep);
        this.creds = new Credentials(rep.ticket, req.reqBody.cname, rep.ticket.sname, enc_part.key, enc_part.flags, enc_part.authtime, enc_part.starttime, enc_part.endtime, enc_part.renewTill, enc_part.caddr);
        if (this.DEBUG) {
            System.out.println(">>> KrbAsRep cons in KrbAsReq.getReply " + req.reqBody.cname.getNameString());
        }
        this.rep = rep;
        this.creds = this.creds;
    }

    public Credentials getCreds() {
        return this.creds;
    }

    public sun.security.krb5.internal.ccache.Credentials setCredentials() {
        return new sun.security.krb5.internal.ccache.Credentials(this.rep);
    }
}

