/*
 * Decompiled with CFR 0.152.
 */
package sun.net.spi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import sun.misc.REException;
import sun.misc.RegexpPool;
import sun.net.NetProperties;
import sun.security.action.LoadLibraryAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxySelector
extends ProxySelector {
    static final String[][] props = new String[][]{{"http", "http.proxy", "proxy", "socksProxy"}, {"https", "https.proxy", "proxy", "socksProxy"}, {"ftp", "ftp.proxy", "ftpProxy", "proxy", "socksProxy"}, {"gopher", "gopherProxy", "socksProxy"}, {"socket", "socksProxy"}};
    private static boolean hasSystemProxies = false;
    private static Properties defprops = new Properties();
    private static NonProxyInfo ftpNonProxyInfo;
    private static NonProxyInfo httpNonProxyInfo;
    private static final Pattern p6;
    private static final long L_DIGIT;
    private static final long H_DIGIT = 0L;
    private int number;

    @Override
    public List<Proxy> select(URI uri) {
        String auth;
        if (uri == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        String protocol = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        if (host == null && (auth = uri.getAuthority()) != null) {
            int i = auth.indexOf(64);
            if (i >= 0) {
                auth = auth.substring(i + 1);
            }
            if ((i = auth.lastIndexOf(58)) >= 0) {
                try {
                    port = Integer.parseInt(auth.substring(i + 1));
                }
                catch (NumberFormatException e) {
                    port = -1;
                }
                auth = auth.substring(0, i);
            }
            host = auth;
        }
        if (protocol == null || host == null) {
            throw new IllegalArgumentException("protocol = " + protocol + " host = " + host);
        }
        ArrayList<Proxy> proxyl = new ArrayList<Proxy>(1);
        if (this.isLoopback(host)) {
            proxyl.add(Proxy.NO_PROXY);
            return proxyl;
        }
        NonProxyInfo pinfo = null;
        if ("http".equalsIgnoreCase(protocol)) {
            pinfo = httpNonProxyInfo;
        } else if ("https".equalsIgnoreCase(protocol)) {
            pinfo = httpNonProxyInfo;
        } else if ("ftp".equalsIgnoreCase(protocol)) {
            pinfo = ftpNonProxyInfo;
        }
        final String proto = protocol;
        final NonProxyInfo nprop = pinfo;
        final String urlhost = host.toLowerCase();
        Proxy p = (Proxy)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                String phost = null;
                int pport = 0;
                String nphosts = null;
                InetSocketAddress saddr = null;
                for (int i = 0; i < props.length; ++i) {
                    int j;
                    if (!props[i][0].equalsIgnoreCase(proto)) continue;
                    for (j = 1; j < props[i].length && ((phost = NetProperties.get(props[i][j] + "Host")) == null || phost.length() == 0); ++j) {
                    }
                    if (phost == null || phost.length() == 0) {
                        String sproto;
                        Proxy sproxy;
                        if (hasSystemProxies && (sproxy = DefaultProxySelector.this.getSystemProxy(sproto = proto.equalsIgnoreCase("socket") ? "socks" : proto, urlhost)) != null) {
                            return sproxy;
                        }
                        return Proxy.NO_PROXY;
                    }
                    if (nprop != null) {
                        nphosts = NetProperties.get(nprop.property);
                        NonProxyInfo sproto = nprop;
                        synchronized (sproto) {
                            if (nphosts == null) {
                                nprop.hostsSource = null;
                                nprop.hostsPool = null;
                            } else if (!nphosts.equals(nprop.hostsSource)) {
                                RegexpPool pool = new RegexpPool();
                                StringTokenizer st = new StringTokenizer(nphosts, "|", false);
                                try {
                                    while (st.hasMoreTokens()) {
                                        pool.add(st.nextToken().toLowerCase(), Boolean.TRUE);
                                    }
                                }
                                catch (REException ex) {
                                    // empty catch block
                                }
                                nprop.hostsPool = pool;
                                nprop.hostsSource = nphosts;
                            }
                            if (nprop.hostsPool != null && nprop.hostsPool.match(urlhost) != null) {
                                return Proxy.NO_PROXY;
                            }
                        }
                    }
                    if ((pport = NetProperties.getInteger(props[i][j] + "Port", 0).intValue()) == 0 && j < props[i].length - 1) {
                        for (int k = 1; k < props[i].length - 1; ++k) {
                            if (k == j || pport != 0) continue;
                            pport = NetProperties.getInteger(props[i][k] + "Port", 0);
                        }
                    }
                    if (pport == 0) {
                        pport = j == props[i].length - 1 ? DefaultProxySelector.this.defaultPort("socket") : DefaultProxySelector.this.defaultPort(proto);
                    }
                    saddr = InetSocketAddress.createUnresolved(phost, pport);
                    if (j == props[i].length - 1) {
                        return new Proxy(Proxy.Type.SOCKS, saddr);
                    }
                    return new Proxy(Proxy.Type.HTTP, saddr);
                }
                return Proxy.NO_PROXY;
            }
        });
        proxyl.add(p);
        return proxyl;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (uri == null || sa == null || ioe == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
    }

    private int defaultPort(String protocol) {
        if ("http".equalsIgnoreCase(protocol)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(protocol)) {
            return 443;
        }
        if ("ftp".equalsIgnoreCase(protocol)) {
            return 80;
        }
        if ("socket".equalsIgnoreCase(protocol)) {
            return 1080;
        }
        if ("gopher".equalsIgnoreCase(protocol)) {
            return 80;
        }
        return -1;
    }

    private boolean isLoopback(String host) {
        if (host == null || host.length() == 0) {
            return false;
        }
        if (host.equalsIgnoreCase("localhost")) {
            return true;
        }
        if (host.startsWith("127.")) {
            int p = 4;
            int n = host.length();
            int q = this.scanByte(host, p, n);
            if (q <= p) {
                return false;
            }
            p = q;
            if ((q = this.scan(host, p, n, '.')) <= p) {
                return q == n && this.number > 0;
            }
            p = q;
            if ((q = this.scanByte(host, p, n)) <= p) {
                return false;
            }
            p = q;
            if ((q = this.scan(host, p, n, '.')) <= p) {
                return q == n && this.number > 0;
            }
            p = q;
            if ((q = this.scanByte(host, p, n)) <= p) {
                return false;
            }
            return q == n && this.number > 0;
        }
        if (host.endsWith(":1")) {
            return p6.matcher(host).matches();
        }
        return false;
    }

    private static long lowMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 63), 0);
        int l = Math.max(Math.min(last, 63), 0);
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private int scanByte(String input, int start, int n) {
        int p = start;
        int q = this.scan(input, p, n, L_DIGIT, 0L);
        if (q <= p) {
            return q;
        }
        this.number = Integer.parseInt(input.substring(p, q));
        if (this.number > 255) {
            return p;
        }
        return q;
    }

    private int scan(String input, int start, int end, char c) {
        if (start < end && input.charAt(start) == c) {
            return start + 1;
        }
        return start;
    }

    private int scan(String input, int start, int n, long lowMask, long highMask) {
        char c;
        int p;
        for (p = start; p < n && this.match(c = input.charAt(p), lowMask, highMask); ++p) {
        }
        return p;
    }

    private boolean match(char c, long lowMask, long highMask) {
        if (c < '@') {
            return (1L << c & lowMask) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & highMask) != 0L;
        }
        return false;
    }

    private static native boolean init();

    private native Proxy getSystemProxy(String var1, String var2);

    static {
        String key = "java.net.useSystemProxies";
        Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return NetProperties.getBoolean("java.net.useSystemProxies");
            }
        });
        if (b != null && b.booleanValue()) {
            AccessController.doPrivileged(new LoadLibraryAction("net"));
            hasSystemProxies = DefaultProxySelector.init();
        }
        ftpNonProxyInfo = new NonProxyInfo("ftp.nonProxyHosts", null, null);
        httpNonProxyInfo = new NonProxyInfo("http.nonProxyHosts", null, null);
        p6 = Pattern.compile("::1|(0:){7}1|(0:){1,6}:1");
        L_DIGIT = DefaultProxySelector.lowMask('0', '9');
    }

    static class NonProxyInfo {
        String hostsSource;
        RegexpPool hostsPool;
        String property;

        NonProxyInfo(String p, String s, RegexpPool pool) {
            this.property = p;
            this.hostsSource = s;
            this.hostsPool = pool;
        }
    }
}

