/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.VMOption;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;
import sun.management.Util;

public class VMOptionCompositeData
extends LazyCompositeData {
    private final VMOption option;
    private static final CompositeType vmOptionCompositeType;
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String WRITEABLE = "writeable";
    private static final String ORIGIN = "origin";
    private static final String[] vmOptionItemNames;

    private VMOptionCompositeData(VMOption option) {
        this.option = option;
    }

    public VMOption getVMOption() {
        return this.option;
    }

    public static CompositeData toCompositeData(VMOption option) {
        VMOptionCompositeData vcd = new VMOptionCompositeData(option);
        return vcd.getCompositeData();
    }

    protected CompositeData getCompositeData() {
        Object[] vmOptionItemValues = new Object[]{this.option.getName(), this.option.getValue(), new Boolean(this.option.isWriteable()), this.option.getOrigin().toString()};
        try {
            return new CompositeDataSupport(vmOptionCompositeType, vmOptionItemNames, vmOptionItemValues);
        }
        catch (OpenDataException e) {
            throw Util.newInternalError(e);
        }
    }

    static CompositeType getVMOptionCompositeType() {
        return vmOptionCompositeType;
    }

    public static String getName(CompositeData cd) {
        return VMOptionCompositeData.getString(cd, NAME);
    }

    public static String getValue(CompositeData cd) {
        return VMOptionCompositeData.getString(cd, VALUE);
    }

    public static VMOption.Origin getOrigin(CompositeData cd) {
        String o = VMOptionCompositeData.getString(cd, ORIGIN);
        return Enum.valueOf(VMOption.Origin.class, o);
    }

    public static boolean isWriteable(CompositeData cd) {
        return VMOptionCompositeData.getBoolean(cd, WRITEABLE);
    }

    public static void validateCompositeData(CompositeData cd) {
        if (cd == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!VMOptionCompositeData.isTypeMatched(vmOptionCompositeType, cd.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for VMOption");
        }
    }

    static {
        try {
            vmOptionCompositeType = (CompositeType)MappedMXBeanType.toOpenType(VMOption.class);
        }
        catch (OpenDataException e) {
            throw Util.newInternalError(e);
        }
        vmOptionItemNames = new String[]{NAME, VALUE, WRITEABLE, ORIGIN};
    }
}

