/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import sun.java2d.pisces.LineSink;
import sun.java2d.pisces.PiscesMath;
import sun.java2d.pisces.Transform4;

public class Stroker
extends LineSink {
    private static final int MOVE_TO = 0;
    private static final int LINE_TO = 1;
    private static final int CLOSE = 2;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    LineSink output;
    int lineWidth;
    int capStyle;
    int joinStyle;
    int miterLimit;
    Transform4 transform;
    int m00;
    int m01;
    int m10;
    int m11;
    int lineWidth2;
    long scaledLineWidth2;
    int numPenSegments;
    int[] pen_dx;
    int[] pen_dy;
    boolean[] penIncluded;
    int[] join;
    int[] offset = new int[2];
    int[] reverse = new int[100];
    int[] miter = new int[2];
    long miterLimitSq;
    int prev;
    int rindex;
    boolean started;
    boolean lineToOrigin;
    boolean joinToOrigin;
    int sx0;
    int sy0;
    int sx1;
    int sy1;
    int x0;
    int y0;
    int x1;
    int y1;
    int mx0;
    int my0;
    int mx1;
    int my1;
    int omx;
    int omy;
    int lx0;
    int ly0;
    int lx1;
    int ly1;
    int lx0p;
    int ly0p;
    int px0;
    int py0;
    double m00_2_m01_2;
    double m10_2_m11_2;
    double m00_m10_m01_m11;
    private static final long ROUND_JOIN_THRESHOLD = 1000L;
    private static final long ROUND_JOIN_INTERNAL_THRESHOLD = 1000000000L;
    boolean joinSegment = false;

    public Stroker() {
    }

    public Stroker(LineSink output, int lineWidth, int capStyle, int joinStyle, int miterLimit, Transform4 transform) {
        this.setOutput(output);
        this.setParameters(lineWidth, capStyle, joinStyle, miterLimit, transform);
    }

    public void setOutput(LineSink output) {
        this.output = output;
    }

    public void setParameters(int lineWidth, int capStyle, int joinStyle, int miterLimit, Transform4 transform) {
        this.lineWidth = lineWidth;
        this.lineWidth2 = lineWidth >> 1;
        this.scaledLineWidth2 = (long)transform.m00 * (long)this.lineWidth2;
        this.capStyle = capStyle;
        this.joinStyle = joinStyle;
        this.miterLimit = miterLimit;
        this.transform = transform;
        this.m00 = transform.m00;
        this.m01 = transform.m01;
        this.m10 = transform.m10;
        this.m11 = transform.m11;
        this.m00_2_m01_2 = (double)this.m00 * (double)this.m00 + (double)this.m01 * (double)this.m01;
        this.m10_2_m11_2 = (double)this.m10 * (double)this.m10 + (double)this.m11 * (double)this.m11;
        this.m00_m10_m01_m11 = (double)this.m00 * (double)this.m10 + (double)this.m01 * (double)this.m11;
        double dm00 = (double)this.m00 / 65536.0;
        double dm01 = (double)this.m01 / 65536.0;
        double dm10 = (double)this.m10 / 65536.0;
        double dm11 = (double)this.m11 / 65536.0;
        double determinant = dm00 * dm11 - dm01 * dm10;
        if (joinStyle == 0) {
            double limit = (double)miterLimit / 65536.0 * ((double)this.lineWidth2 / 65536.0) * determinant;
            double limitSq = limit * limit;
            this.miterLimitSq = (long)(limitSq * 65536.0 * 65536.0);
        }
        this.numPenSegments = (int)(3.14159f * (float)lineWidth / 65536.0f);
        if (this.pen_dx == null || this.pen_dx.length < this.numPenSegments) {
            this.pen_dx = new int[this.numPenSegments];
            this.pen_dy = new int[this.numPenSegments];
            this.penIncluded = new boolean[this.numPenSegments];
            this.join = new int[2 * this.numPenSegments];
        }
        for (int i = 0; i < this.numPenSegments; ++i) {
            double r = (double)lineWidth / 2.0;
            double theta = (double)i * 2.0 * Math.PI / (double)this.numPenSegments;
            double cos = Math.cos(theta);
            double sin = Math.sin(theta);
            this.pen_dx[i] = (int)(r * (dm00 * cos + dm01 * sin));
            this.pen_dy[i] = (int)(r * (dm10 * cos + dm11 * sin));
        }
        this.prev = 2;
        this.rindex = 0;
        this.started = false;
        this.lineToOrigin = false;
    }

    private void computeOffset(int x0, int y0, int x1, int y1, int[] m) {
        int dx;
        int dy;
        long lx = (long)x1 - (long)x0;
        long ly = (long)y1 - (long)y0;
        if (this.m00 > 0 && this.m00 == this.m11 && this.m01 == 0 & this.m10 == 0) {
            long ilen = PiscesMath.hypot(lx, ly);
            if (ilen == 0L) {
                dy = 0;
                dx = 0;
            } else {
                dx = (int)(ly * this.scaledLineWidth2 / ilen >> 16);
                dy = (int)(-(lx * this.scaledLineWidth2) / ilen >> 16);
            }
        } else {
            double dlx = x1 - x0;
            double dly = y1 - y0;
            double det = (double)this.m00 * (double)this.m11 - (double)this.m01 * (double)this.m10;
            int sdet = det > 0.0 ? 1 : -1;
            double a = dly * (double)this.m00 - dlx * (double)this.m10;
            double b = dly * (double)this.m01 - dlx * (double)this.m11;
            double dh = PiscesMath.hypot(a, b);
            double div = (double)(sdet * this.lineWidth2) / (65536.0 * dh);
            double ddx = dly * this.m00_2_m01_2 - dlx * this.m00_m10_m01_m11;
            double ddy = dly * this.m00_m10_m01_m11 - dlx * this.m10_2_m11_2;
            dx = (int)(ddx * div);
            dy = (int)(ddy * div);
        }
        m[0] = dx;
        m[1] = dy;
    }

    private void ensureCapacity(int newrindex) {
        if (this.reverse.length < newrindex) {
            int[] tmp = new int[Math.max(newrindex, 6 * this.reverse.length / 5)];
            System.arraycopy(this.reverse, 0, tmp, 0, this.rindex);
            this.reverse = tmp;
        }
    }

    private boolean isCCW(int x0, int y0, int x1, int y1, int x2, int y2) {
        int dx0 = x1 - x0;
        int dy1 = y2 - y1;
        int dy0 = y1 - y0;
        int dx1 = x2 - x1;
        return (long)dx0 * (long)dy1 < (long)dy0 * (long)dx1;
    }

    private boolean side(int x, int y, int x0, int y0, int x1, int y1) {
        long ly0 = y0;
        long ly1 = y1;
        long lx = x;
        long lx1 = x1;
        long lx0 = x0;
        long ly = y;
        return (ly0 - ly1) * lx + (lx1 - lx0) * ly + (lx0 * ly1 - lx1 * ly0) > 0L;
    }

    private int computeRoundJoin(int cx, int cy, int xa, int ya, int xb, int yb, int side, boolean flip, int[] join) {
        int py;
        int px;
        int ncoords = 0;
        boolean centerSide = side == 0 ? this.side(cx, cy, xa, ya, xb, yb) : side == 1;
        for (int i = 0; i < this.numPenSegments; ++i) {
            px = cx + this.pen_dx[i];
            py = cy + this.pen_dy[i];
            boolean penSide = this.side(px, py, xa, ya, xb, yb);
            this.penIncluded[i] = penSide != centerSide;
        }
        int start = -1;
        int end = -1;
        for (int i = 0; i < this.numPenSegments; ++i) {
            if (this.penIncluded[i] && !this.penIncluded[(i + this.numPenSegments - 1) % this.numPenSegments]) {
                start = i;
            }
            if (!this.penIncluded[i] || this.penIncluded[(i + 1) % this.numPenSegments]) continue;
            end = i;
        }
        if (end < start) {
            end += this.numPenSegments;
        }
        if (start != -1 && end != -1) {
            long dxa = cx + this.pen_dx[start] - xa;
            long dya = cy + this.pen_dy[start] - ya;
            long dxb = cx + this.pen_dx[start] - xb;
            long dyb = cy + this.pen_dy[start] - yb;
            boolean rev = dxa * dxa + dya * dya > dxb * dxb + dyb * dyb;
            int i = rev ? end : start;
            int incr = rev ? -1 : 1;
            while (true) {
                int idx = i % this.numPenSegments;
                px = cx + this.pen_dx[idx];
                py = cy + this.pen_dy[idx];
                join[ncoords++] = px;
                join[ncoords++] = py;
                if (i == (rev ? start : end)) break;
                i += incr;
            }
        }
        return ncoords / 2;
    }

    private void drawRoundJoin(int x, int y, int omx, int omy, int mx, int my, int side, boolean flip, boolean rev, long threshold) {
        if (omx == 0 && omy == 0 || mx == 0 && my == 0) {
            return;
        }
        long domx = (long)omx - (long)mx;
        long domy = (long)omy - (long)my;
        long len = domx * domx + domy * domy;
        if (len < threshold) {
            return;
        }
        if (rev) {
            omx = -omx;
            omy = -omy;
            mx = -mx;
            my = -my;
        }
        int bx0 = x + omx;
        int by0 = y + omy;
        int bx1 = x + mx;
        int by1 = y + my;
        int npoints = this.computeRoundJoin(x, y, bx0, by0, bx1, by1, side, flip, this.join);
        for (int i = 0; i < npoints; ++i) {
            this.emitLineTo(this.join[2 * i], this.join[2 * i + 1], rev);
        }
    }

    private void computeMiter(int ix0, int iy0, int ix1, int iy1, int ix0p, int iy0p, int ix1p, int iy1p, int[] m) {
        long x1 = ix1;
        long x0 = ix0;
        long x10 = x1 - x0;
        long y1p = iy1p;
        long y0p = iy0p;
        long y10p = y1p - y0p;
        long x1p = ix1p;
        long x0p = ix0p;
        long x10p = x1p - x0p;
        long y1 = iy1;
        long y0 = iy0;
        long y10 = y1 - y0;
        long den = x10 * y10p - x10p * y10 >> 16;
        if (den == 0L) {
            m[0] = ix0;
            m[1] = iy0;
            return;
        }
        long t = x1p * (y0 - y0p) - x0 * y10p + x0p * (y1p - y0) >> 16;
        m[0] = (int)(x0 + t * x10 / den);
        m[1] = (int)(y0 + t * y10 / den);
    }

    private void drawMiter(int px0, int py0, int x0, int y0, int x1, int y1, int omx, int omy, int mx, int my, boolean rev) {
        if (mx == omx && my == omy) {
            return;
        }
        if (px0 == x0 && py0 == y0) {
            return;
        }
        if (x0 == x1 && y0 == y1) {
            return;
        }
        if (rev) {
            omx = -omx;
            omy = -omy;
            mx = -mx;
            my = -my;
        }
        this.computeMiter(px0 + omx, py0 + omy, x0 + omx, y0 + omy, x0 + mx, y0 + my, x1 + mx, y1 + my, this.miter);
        long dx = (long)this.miter[0] - (long)x0;
        long dy = (long)this.miter[1] - (long)y0;
        long a = dy * (long)this.m00 - dx * (long)this.m10 >> 16;
        long b = dy * (long)this.m01 - dx * (long)this.m11 >> 16;
        long lenSq = a * a + b * b;
        if (lenSq < this.miterLimitSq) {
            this.emitLineTo(this.miter[0], this.miter[1], rev);
        }
    }

    public void moveTo(int x0, int y0) {
        if (this.lineToOrigin) {
            this.lineToImpl(this.sx0, this.sy0, this.joinToOrigin);
            this.lineToOrigin = false;
        }
        if (this.prev == 1) {
            this.finish();
        }
        this.sx0 = this.x0 = x0;
        this.sy0 = this.y0 = y0;
        this.rindex = 0;
        this.started = false;
        this.joinSegment = false;
        this.prev = 0;
    }

    public void lineJoin() {
        this.joinSegment = true;
    }

    public void lineTo(int x1, int y1) {
        if (this.lineToOrigin) {
            if (x1 == this.sx0 && y1 == this.sy0) {
                return;
            }
            this.lineToImpl(this.sx0, this.sy0, this.joinToOrigin);
            this.lineToOrigin = false;
        } else {
            if (x1 == this.x0 && y1 == this.y0) {
                return;
            }
            if (x1 == this.sx0 && y1 == this.sy0) {
                this.lineToOrigin = true;
                this.joinToOrigin = this.joinSegment;
                this.joinSegment = false;
                return;
            }
        }
        this.lineToImpl(x1, y1, this.joinSegment);
        this.joinSegment = false;
    }

    private void lineToImpl(int x1, int y1, boolean joinSegment) {
        this.computeOffset(this.x0, this.y0, x1, y1, this.offset);
        int mx = this.offset[0];
        int my = this.offset[1];
        if (!this.started) {
            this.emitMoveTo(this.x0 + mx, this.y0 + my);
            this.sx1 = x1;
            this.sy1 = y1;
            this.mx0 = mx;
            this.my0 = my;
            this.started = true;
        } else {
            boolean ccw = this.isCCW(this.px0, this.py0, this.x0, this.y0, x1, y1);
            if (joinSegment) {
                if (this.joinStyle == 0) {
                    this.drawMiter(this.px0, this.py0, this.x0, this.y0, x1, y1, this.omx, this.omy, mx, my, ccw);
                } else if (this.joinStyle == 1) {
                    this.drawRoundJoin(this.x0, this.y0, this.omx, this.omy, mx, my, 0, false, ccw, 1000L);
                }
            } else {
                this.drawRoundJoin(this.x0, this.y0, this.omx, this.omy, mx, my, 0, false, ccw, 1000000000L);
            }
            this.emitLineTo(this.x0, this.y0, !ccw);
        }
        this.emitLineTo(this.x0 + mx, this.y0 + my, false);
        this.emitLineTo(x1 + mx, y1 + my, false);
        this.emitLineTo(this.x0 - mx, this.y0 - my, true);
        this.emitLineTo(x1 - mx, y1 - my, true);
        this.lx0 = x1 + mx;
        this.ly0 = y1 + my;
        this.lx0p = x1 - mx;
        this.ly0p = y1 - my;
        this.lx1 = x1;
        this.ly1 = y1;
        this.omx = mx;
        this.omy = my;
        this.px0 = this.x0;
        this.py0 = this.y0;
        this.x0 = x1;
        this.y0 = y1;
        this.prev = 1;
    }

    public void close() {
        if (this.lineToOrigin) {
            this.lineToOrigin = false;
        }
        if (!this.started) {
            this.finish();
            return;
        }
        this.computeOffset(this.x0, this.y0, this.sx0, this.sy0, this.offset);
        int mx = this.offset[0];
        int my = this.offset[1];
        boolean ccw = this.isCCW(this.px0, this.py0, this.x0, this.y0, this.sx0, this.sy0);
        if (this.joinSegment) {
            if (this.joinStyle == 0) {
                this.drawMiter(this.px0, this.py0, this.x0, this.y0, this.sx0, this.sy0, this.omx, this.omy, mx, my, ccw);
            } else if (this.joinStyle == 1) {
                this.drawRoundJoin(this.x0, this.y0, this.omx, this.omy, mx, my, 0, false, ccw, 1000L);
            }
        } else {
            this.drawRoundJoin(this.x0, this.y0, this.omx, this.omy, mx, my, 0, false, ccw, 1000000000L);
        }
        this.emitLineTo(this.x0, this.y0, !ccw);
        this.emitLineTo(this.x0 + mx, this.y0 + my);
        this.emitLineTo(this.sx0 + mx, this.sy0 + my);
        ccw = this.isCCW(this.x0, this.y0, this.sx0, this.sy0, this.sx1, this.sy1);
        if (!ccw) {
            if (this.joinStyle == 0) {
                this.drawMiter(this.x0, this.y0, this.sx0, this.sy0, this.sx1, this.sy1, mx, my, this.mx0, this.my0, false);
            } else if (this.joinStyle == 1) {
                this.drawRoundJoin(this.sx0, this.sy0, mx, my, this.mx0, this.my0, 0, false, false, 1000L);
            }
        }
        this.emitLineTo(this.sx0 + this.mx0, this.sy0 + this.my0);
        this.emitMoveTo(this.sx0, this.sy0);
        if (ccw) {
            if (this.joinStyle == 0) {
                this.drawMiter(this.x0, this.y0, this.sx0, this.sy0, this.sx1, this.sy1, -mx, -my, -this.mx0, -this.my0, false);
            } else if (this.joinStyle == 1) {
                this.drawRoundJoin(this.sx0, this.sy0, -mx, -my, -this.mx0, -this.my0, 0, true, false, 1000L);
            }
        }
        this.emitLineTo(this.sx0 - mx, this.sy0 - my);
        this.emitLineTo(this.x0 - mx, this.y0 - my);
        for (int i = this.rindex - 2; i >= 0; i -= 2) {
            this.emitLineTo(this.reverse[i], this.reverse[i + 1]);
        }
        this.x0 = this.sx0;
        this.y0 = this.sy0;
        this.rindex = 0;
        this.started = false;
        this.joinSegment = false;
        this.prev = 2;
        this.emitClose();
    }

    public void end() {
        if (this.lineToOrigin) {
            this.lineToImpl(this.sx0, this.sy0, this.joinToOrigin);
            this.lineToOrigin = false;
        }
        if (this.prev == 1) {
            this.finish();
        }
        this.output.end();
        this.joinSegment = false;
        this.prev = 0;
    }

    long lineLength(long ldx, long ldy) {
        long ldet = (long)this.m00 * (long)this.m11 - (long)this.m01 * (long)this.m10 >> 16;
        long la = (ldy * (long)this.m00 - ldx * (long)this.m10) / ldet;
        long lb = (ldy * (long)this.m01 - ldx * (long)this.m11) / ldet;
        long llen = (int)PiscesMath.hypot(la, lb);
        return llen;
    }

    private void finish() {
        int capy;
        int capx;
        long s;
        long llen;
        long ldy;
        if (this.capStyle == 1) {
            this.drawRoundJoin(this.x0, this.y0, this.omx, this.omy, -this.omx, -this.omy, 1, false, false, 1000L);
        } else if (this.capStyle == 2) {
            long ldx = this.px0 - this.x0;
            ldy = this.py0 - this.y0;
            llen = this.lineLength(ldx, ldy);
            s = llen == 0L ? 0L : (long)this.lineWidth2 * 65536L / llen;
            capx = this.x0 - (int)(ldx * s >> 16);
            capy = this.y0 - (int)(ldy * s >> 16);
            this.emitLineTo(capx + this.omx, capy + this.omy);
            this.emitLineTo(capx - this.omx, capy - this.omy);
        }
        for (int i = this.rindex - 2; i >= 0; i -= 2) {
            this.emitLineTo(this.reverse[i], this.reverse[i + 1]);
        }
        this.rindex = 0;
        if (this.capStyle == 1) {
            this.drawRoundJoin(this.sx0, this.sy0, -this.mx0, -this.my0, this.mx0, this.my0, 1, false, false, 1000L);
        } else if (this.capStyle == 2) {
            long ldx = this.sx1 - this.sx0;
            ldy = this.sy1 - this.sy0;
            llen = this.lineLength(ldx, ldy);
            s = llen == 0L ? 0L : (long)this.lineWidth2 * 65536L / llen;
            capx = this.sx0 - (int)(ldx * s >> 16);
            capy = this.sy0 - (int)(ldy * s >> 16);
            this.emitLineTo(capx - this.mx0, capy - this.my0);
            this.emitLineTo(capx + this.mx0, capy + this.my0);
        }
        this.emitClose();
        this.joinSegment = false;
    }

    private void emitMoveTo(int x0, int y0) {
        this.output.moveTo(x0, y0);
    }

    private void emitLineTo(int x1, int y1) {
        this.output.lineTo(x1, y1);
    }

    private void emitLineTo(int x1, int y1, boolean rev) {
        if (rev) {
            this.ensureCapacity(this.rindex + 2);
            this.reverse[this.rindex++] = x1;
            this.reverse[this.rindex++] = y1;
        } else {
            this.emitLineTo(x1, y1);
        }
    }

    private void emitClose() {
        this.output.close();
    }
}

