/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pisces.PiscesCache;

public class PiscesTileGenerator
implements AATileGenerator {
    public static final int TILE_SIZE = 32;
    PiscesCache cache;
    int x;
    int y;
    int maxalpha;
    byte[] alphaMap;
    static int prevMaxAlpha;
    static byte[] prevAlphaMap;

    public PiscesTileGenerator(PiscesCache cache, int maxalpha) {
        this.cache = cache;
        this.x = cache.bboxX0;
        this.y = cache.bboxY0;
        this.alphaMap = PiscesTileGenerator.getAlphaMap(maxalpha);
        this.maxalpha = maxalpha;
    }

    public static synchronized byte[] getAlphaMap(int maxalpha) {
        if (maxalpha != prevMaxAlpha) {
            int i;
            prevAlphaMap = new byte[maxalpha + 300];
            int halfmaxalpha = maxalpha >> 2;
            for (i = 0; i <= maxalpha; ++i) {
                PiscesTileGenerator.prevAlphaMap[i] = (byte)((i * 255 + halfmaxalpha) / maxalpha);
            }
            for (i = maxalpha; i < prevAlphaMap.length; ++i) {
                PiscesTileGenerator.prevAlphaMap[i] = -1;
            }
            prevMaxAlpha = maxalpha;
        }
        return prevAlphaMap;
    }

    public void getBbox(int[] bbox) {
        bbox[0] = this.cache.bboxX0;
        bbox[1] = this.cache.bboxY0;
        bbox[2] = this.cache.bboxX1;
        bbox[3] = this.cache.bboxY1;
    }

    public int getTileWidth() {
        return 32;
    }

    public int getTileHeight() {
        return 32;
    }

    public int getTypicalAlpha() {
        return 128;
    }

    public void nextTile() {
        if ((this.x += 32) >= this.cache.bboxX1) {
            this.x = this.cache.bboxX0;
            this.y += 32;
        }
    }

    public void getAlpha(byte[] tile, int offset, int rowstride) {
        int x0 = this.x;
        int x1 = x0 + 32;
        int y0 = this.y;
        int y1 = y0 + 32;
        if (x1 > this.cache.bboxX1) {
            x1 = this.cache.bboxX1;
        }
        if (y1 > this.cache.bboxY1) {
            y1 = this.cache.bboxY1;
        }
        y1 -= this.cache.bboxY0;
        int idx = offset;
        for (int cy = y0 -= this.cache.bboxY0; cy < y1; ++cy) {
            int pos = this.cache.rowOffsetsRLE[cy];
            int cx = this.cache.minTouched[cy];
            if (cx > x1) {
                cx = x1;
            }
            if (cx > x0) {
                for (int i = x0; i < cx; ++i) {
                    tile[idx++] = 0;
                }
            }
            while (cx < x1) {
                byte val;
                int runLen = 0;
                try {
                    val = this.alphaMap[this.cache.rowAARLE[pos] & 0xFF];
                    runLen = this.cache.rowAARLE[pos + 1] & 0xFF;
                }
                catch (RuntimeException e0) {
                    System.out.println("maxalpha = " + this.maxalpha);
                    System.out.println("tile[" + x0 + ", " + y0 + " => " + x1 + ", " + y1 + "]");
                    System.out.println("cx = " + cx + ", cy = " + cy);
                    System.out.println("idx = " + idx + ", pos = " + pos);
                    System.out.println("len = " + runLen);
                    this.cache.print(System.out);
                    e0.printStackTrace();
                    System.exit(1);
                    return;
                }
                if (runLen == 0) break;
                int rx0 = cx;
                int rx1 = cx += runLen;
                if (rx0 < x0) {
                    rx0 = x0;
                }
                if (rx1 > x1) {
                    rx1 = x1;
                }
                runLen = rx1 - rx0;
                while (--runLen >= 0) {
                    try {
                        tile[idx++] = val;
                    }
                    catch (RuntimeException e) {
                        System.out.println("maxalpha = " + this.maxalpha);
                        System.out.println("tile[" + x0 + ", " + y0 + " => " + x1 + ", " + y1 + "]");
                        System.out.println("cx = " + cx + ", cy = " + cy);
                        System.out.println("idx = " + idx + ", pos = " + pos);
                        System.out.println("rx0 = " + rx0 + ", rx1 = " + rx1);
                        System.out.println("len = " + runLen);
                        this.cache.print(System.out);
                        e.printStackTrace();
                        System.exit(1);
                        return;
                    }
                }
                pos += 2;
            }
            if (cx < x0) {
                cx = x0;
            }
            while (cx < x1) {
                tile[idx++] = 0;
                ++cx;
            }
            idx += rowstride - (x1 - x0);
        }
        this.nextTile();
    }

    static String hex(int v, int d) {
        String s = Integer.toHexString(v);
        while (s.length() < d) {
            s = "0" + s;
        }
        return s.substring(0, d);
    }

    public void dispose() {
    }
}

