/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11GraphicsEnvironment;
import sun.awt.image.OffScreenImage;
import sun.awt.image.SunVolatileImage;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.GLXSurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;

public class GLXGraphicsConfig
extends X11GraphicsConfig
implements OGLGraphicsConfig {
    private static ImageCapabilities imageCaps = new GLXImageCaps();
    private BufferCapabilities bufferCaps;
    private long pConfigInfo;
    private int oglCaps;
    private OGLContext context;

    private static native long getGLXConfigInfo(int var0, int var1);

    private static native int getOGLCapabilities(long var0);

    private native void initConfig(long var1, long var3);

    private GLXGraphicsConfig(X11GraphicsDevice device, int visualnum, long configInfo, int oglCaps) {
        super(device, visualnum, 0, 0, (oglCaps & 1) != 0);
        this.pConfigInfo = configInfo;
        this.initConfig(this.getAData(), configInfo);
        this.oglCaps = oglCaps;
        this.context = new OGLContext(OGLRenderQueue.getInstance());
    }

    public Object getProxyKey() {
        return this;
    }

    public SurfaceData createManagedSurface(int w, int h, int transparency) {
        return GLXSurfaceData.createData(this, w, h, this.getColorModel(transparency), null, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GLXGraphicsConfig getConfig(X11GraphicsDevice device, int visualnum) {
        if (!X11GraphicsEnvironment.isGLXAvailable()) {
            return null;
        }
        long cfginfo = 0L;
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            OGLContext.invalidateCurrentContext();
            GLXGetConfigInfo action = new GLXGetConfigInfo(device.getScreen(), visualnum);
            rq.flushAndInvokeNow(action);
            cfginfo = action.getConfigInfo();
        }
        finally {
            rq.unlock();
        }
        if (cfginfo == 0L) {
            return null;
        }
        int oglCaps = GLXGraphicsConfig.getOGLCapabilities(cfginfo);
        return new GLXGraphicsConfig(device, visualnum, cfginfo, oglCaps);
    }

    public final boolean isCapPresent(int cap) {
        return (this.oglCaps & cap) != 0;
    }

    public final long getNativeConfigInfo() {
        return this.pConfigInfo;
    }

    public final OGLContext getContext() {
        return this.context;
    }

    public BufferedImage createCompatibleImage(int width, int height) {
        DirectColorModel model = new DirectColorModel(24, 0xFF0000, 65280, 255);
        WritableRaster raster = ((ColorModel)model).createCompatibleWritableRaster(width, height);
        return new BufferedImage(model, raster, model.isAlphaPremultiplied(), null);
    }

    public ColorModel getColorModel(int transparency) {
        switch (transparency) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace cs = ColorSpace.getInstance(1000);
                return new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    public String toString() {
        return "GLXGraphicsConfig[dev=" + this.screen + ",vis=0x" + Integer.toHexString(this.visual) + "]";
    }

    public SurfaceData createSurfaceData(X11ComponentPeer peer) {
        return GLXSurfaceData.createData(peer);
    }

    public Image createAcceleratedImage(Component target, int width, int height) {
        ColorModel model = this.getColorModel(1);
        WritableRaster wr = model.createCompatibleWritableRaster(width, height);
        return new OffScreenImage(target, model, wr, model.isAlphaPremultiplied());
    }

    public long createBackBuffer(X11ComponentPeer peer, int numBuffers, BufferCapabilities caps) throws AWTException {
        if (numBuffers > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities configCaps = this.getBufferCapabilities();
        if (!configCaps.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (caps.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
        return 1L;
    }

    public void destroyBackBuffer(long backBuffer) {
    }

    public VolatileImage createBackBufferImage(Component target, long backBuffer) {
        return new SunVolatileImage(target, target.getWidth(), target.getHeight(), Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(X11ComponentPeer peer, Component target, VolatileImage xBackBuffer, BufferCapabilities.FlipContents flipAction) {
        if (flipAction == BufferCapabilities.FlipContents.COPIED) {
            Graphics g = peer.getGraphics();
            try {
                g.drawImage(xBackBuffer, 0, 0, null);
            }
            finally {
                g.dispose();
            }
            return;
        }
        if (flipAction == BufferCapabilities.FlipContents.PRIOR) {
            return;
        }
        OGLSurfaceData.swapBuffers(peer.getContentWindow());
        if (flipAction == BufferCapabilities.FlipContents.BACKGROUND) {
            Graphics g = xBackBuffer.getGraphics();
            try {
                g.setColor(target.getBackground());
                g.fillRect(0, 0, xBackBuffer.getWidth(), xBackBuffer.getHeight());
            }
            finally {
                g.dispose();
            }
        }
    }

    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = new GLXBufferCaps(this.isDoubleBuffered());
        }
        return this.bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    private static class GLXImageCaps
    extends ImageCapabilities {
        private GLXImageCaps() {
            super(true);
        }

        public boolean isTrueVolatile() {
            return true;
        }
    }

    private static class GLXBufferCaps
    extends BufferCapabilities {
        public GLXBufferCaps(boolean dblBuf) {
            super(imageCaps, imageCaps, dblBuf ? BufferCapabilities.FlipContents.UNDEFINED : null);
        }
    }

    private static class GLXGetConfigInfo
    implements Runnable {
        private int screen;
        private int visual;
        private long cfginfo;

        private GLXGetConfigInfo(int screen, int visual) {
            this.screen = screen;
            this.visual = visual;
        }

        public void run() {
            this.cfginfo = GLXGraphicsConfig.getGLXConfigInfo(this.screen, this.visual);
        }

        public long getConfigInfo() {
            return this.cfginfo;
        }
    }
}

