/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.Composite;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.CustomComponent;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.SpanIterator;

class OpaqueCopyArgbToAny
extends Blit {
    OpaqueCopyArgbToAny() {
        super(SurfaceType.IntArgb, CompositeType.SrcNoEa, SurfaceType.Any);
    }

    public void Blit(SurfaceData src, SurfaceData dst, Composite comp, Region clip, int srcx, int srcy, int dstx, int dsty, int w, int h) {
        Raster srcRast = src.getRaster(srcx, srcy, w, h);
        IntegerComponentRaster icr = (IntegerComponentRaster)srcRast;
        int[] srcPix = icr.getDataStorage();
        WritableRaster dstRast = (WritableRaster)dst.getRaster(dstx, dsty, w, h);
        ColorModel dstCM = dst.getColorModel();
        Region roi = CustomComponent.getRegionOfInterest(src, dst, clip, srcx, srcy, dstx, dsty, w, h);
        SpanIterator si = roi.getSpanIterator();
        Object dstPix = null;
        int srcScan = icr.getScanlineStride();
        srcx -= dstx;
        srcy -= dsty;
        int[] span = new int[4];
        while (si.nextSpan(span)) {
            int rowoff = icr.getDataOffset(0) + (srcy + span[1]) * srcScan + (srcx + span[0]);
            for (int y = span[1]; y < span[3]; ++y) {
                int off = rowoff;
                for (int x = span[0]; x < span[2]; ++x) {
                    dstPix = dstCM.getDataElements(srcPix[off++], dstPix);
                    dstRast.setDataElements(x, y, dstPix);
                }
                rowoff += srcScan;
            }
        }
    }
}

