/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import sun.awt.X11.XAtom;
import sun.awt.X11.XSelection;
import sun.awt.X11.XToolkit;
import sun.awt.datatransfer.ClipboardTransferable;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.SunClipboard;
import sun.security.action.GetIntegerAction;

public class XClipboard
extends SunClipboard
implements Runnable {
    private final XSelection selection;
    private static final Object classLock = new Object();
    private static final int defaultPollInterval = 200;
    private static int pollInterval;
    private static Set listenedClipboards;

    public XClipboard(String name, String selectionName) {
        super(name);
        this.selection = new XSelection(XAtom.get(selectionName), this);
    }

    public void run() {
        this.lostOwnershipImpl();
    }

    protected synchronized void setContentsNative(Transferable contents) {
        SortedMap formatMap = DataTransferer.getInstance().getFormatsForTransferable(contents, DataTransferer.adaptFlavorMap(flavorMap));
        DataTransferer.getInstance();
        long[] formats = DataTransferer.keysToLongArray(formatMap);
        if (!this.selection.setOwner(contents, formatMap, formats, XToolkit.getCurrentServerTime())) {
            this.owner = null;
            this.contents = null;
        }
    }

    public long getID() {
        return this.selection.getSelectionAtom().getAtom();
    }

    public synchronized Transferable getContents(Object requestor) {
        if (this.contents != null) {
            return this.contents;
        }
        return new ClipboardTransferable(this);
    }

    protected void clearNativeContext() {
        this.selection.reset();
    }

    protected long[] getClipboardFormats() {
        return this.selection.getTargets(XToolkit.getCurrentServerTime());
    }

    protected byte[] getClipboardData(long format) throws IOException {
        return this.selection.getData(format, XToolkit.getCurrentServerTime());
    }

    public void checkChange(long[] formats) {
        if (!this.selection.isOwner()) {
            super.checkChange(formats);
        }
    }

    void checkChangeHere(Transferable contents) {
        if (this.areFlavorListenersRegistered()) {
            super.checkChange(DataTransferer.getInstance().getFormatsForTransferableAsArray(contents, flavorMap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerClipboardViewerChecked() {
        if (pollInterval <= 0 && (pollInterval = AccessController.doPrivileged(new GetIntegerAction("awt.datatransfer.clipboard.poll.interval", 200)).intValue()) <= 0) {
            pollInterval = 200;
        }
        this.selection.initializeSelectionForTrackingChanges();
        boolean mustSchedule = false;
        Object object = classLock;
        synchronized (object) {
            if (listenedClipboards == null) {
                listenedClipboards = new HashSet(2);
            }
            mustSchedule = listenedClipboards.isEmpty();
            listenedClipboards.add(this);
        }
        if (mustSchedule) {
            XToolkit.schedule(new CheckChangeTimerTask(), pollInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterClipboardViewerChecked() {
        this.selection.deinitializeSelectionForTrackingChanges();
        Object object = classLock;
        synchronized (object) {
            listenedClipboards.remove(this);
        }
    }

    private static class CheckChangeTimerTask
    implements Runnable {
        private CheckChangeTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            for (XClipboard clpbrd : listenedClipboards) {
                clpbrd.selection.getTargetsDelayed();
            }
            Object object = classLock;
            synchronized (object) {
                if (listenedClipboards != null && !listenedClipboards.isEmpty()) {
                    XToolkit.schedule(this, pollInterval);
                }
            }
        }
    }
}

