/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Window;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindowAccessor {
    private static Class windowClass;
    private static Field fieldIsAutoRequestFocus;
    private static Field fieldIsTrayIconWindow;
    private static final Logger log;

    private WindowAccessor() {
    }

    public static boolean isAutoRequestFocus(Window w) {
        try {
            return fieldIsAutoRequestFocus.getBoolean(w);
        }
        catch (IllegalAccessException e) {
            log.log(Level.FINE, "Unable to access the Window object", e);
            return true;
        }
    }

    public static boolean isTrayIconWindow(Window w) {
        try {
            return fieldIsTrayIconWindow.getBoolean(w);
        }
        catch (IllegalAccessException e) {
            log.log(Level.FINE, "Unable to access the Window object", e);
            return false;
        }
    }

    public static void setTrayIconWindow(Window w, boolean isTrayIconWindow) {
        try {
            fieldIsTrayIconWindow.set(w, isTrayIconWindow);
        }
        catch (IllegalAccessException e) {
            log.log(Level.FINE, "Unable to access the Window object", e);
        }
    }

    static {
        log = Logger.getLogger("sun.awt.WindowAccessor");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    windowClass = Class.forName("java.awt.Window");
                    fieldIsAutoRequestFocus = windowClass.getDeclaredField("autoRequestFocus");
                    fieldIsAutoRequestFocus.setAccessible(true);
                    fieldIsTrayIconWindow = windowClass.getDeclaredField("isTrayIconWindow");
                    fieldIsTrayIconWindow.setAccessible(true);
                }
                catch (NoSuchFieldException e) {
                    log.log(Level.FINE, "Unable to initialize WindowAccessor: ", e);
                }
                catch (ClassNotFoundException e) {
                    log.log(Level.FINE, "Unable to initialize WindowAccessor: ", e);
                }
                return null;
            }
        });
    }
}

