/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.util.HashMap;
import sun.applet.PluginDebug;

public class PluginObjectStore {
    private static HashMap<Integer, Object> objects = new HashMap();
    private static HashMap<Integer, Integer> counts = new HashMap();
    private static HashMap<Object, Integer> identifiers = new HashMap();
    private static int nextUniqueIdentifier = 1;

    public Object getObject(Integer identifier) {
        return objects.get(identifier);
    }

    public Integer getIdentifier(Object object) {
        if (object == null) {
            return 0;
        }
        return identifiers.get(object);
    }

    public boolean contains(Object object) {
        if (object == null) {
            return identifiers.containsKey(object);
        }
        return false;
    }

    public boolean contains(int identifier) {
        return objects.containsKey(identifier);
    }

    public void reference(Object object) {
        Integer identifier = identifiers.get(object);
        if (identifier == null) {
            objects.put(nextUniqueIdentifier, object);
            counts.put(nextUniqueIdentifier, 1);
            identifiers.put(object, nextUniqueIdentifier);
            ++nextUniqueIdentifier;
        } else {
            counts.put(identifier, counts.get(identifier) + 1);
        }
    }

    public void unreference(int identifier) {
        Integer currentCount = counts.get(identifier);
        if (currentCount == null) {
            return;
        }
        if (currentCount == 1) {
            Object object = objects.get(identifier);
            objects.remove(identifier);
            counts.remove(identifier);
            identifiers.remove(object);
        } else {
            counts.put(identifier, currentCount - 1);
        }
    }

    public void dump() {
        for (Integer key : objects.keySet()) {
            PluginDebug.debug(key + "::" + objects.get(key));
        }
    }
}

