/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import sun.applet.PluginDebug;
import sun.applet.PluginException;
import sun.applet.PluginMessageConsumer;
import sun.applet.PluginStreamHandler;

class PluginMessageHandlerWorker
extends Thread {
    private boolean free = true;
    private boolean isPriorityWorker = false;
    private int id;
    private String message = null;
    private SecurityManager sm;
    PluginStreamHandler streamHandler = null;
    PluginMessageConsumer consumer = null;

    public PluginMessageHandlerWorker(PluginMessageConsumer consumer, PluginStreamHandler streamHandler, int id, SecurityManager sm, boolean isPriorityWorker) {
        this.id = id;
        this.streamHandler = streamHandler;
        this.sm = sm;
        this.isPriorityWorker = isPriorityWorker;
        this.consumer = consumer;
        PluginDebug.debug("Worker " + this.id + " (priority=" + isPriorityWorker + ") created.");
    }

    public void setmessage(String message) {
        this.message = message;
    }

    @Override
    public void run() {
        while (true) {
            if (this.message != null) {
                PluginDebug.debug("Consumer (priority=" + this.isPriorityWorker + ") thread " + this.id + " consuming " + this.message);
                this.busy();
                try {
                    this.streamHandler.handleMessage(this.message);
                }
                catch (PluginException pe) {
                    // empty catch block
                }
                this.message = null;
                PluginDebug.debug("Consumption (priority=" + this.isPriorityWorker + ") completed by consumer thread " + this.id);
                this.free();
                continue;
            }
            try {
                Thread.sleep(Integer.MAX_VALUE);
                PluginDebug.debug("Consumer thread " + this.id + " sleeping...");
                continue;
            }
            catch (InterruptedException ie) {
                PluginDebug.debug("Consumer thread " + this.id + " woken...");
                continue;
            }
            break;
        }
    }

    public int getWorkerId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void busy() {
        PluginMessageHandlerWorker pluginMessageHandlerWorker = this;
        synchronized (pluginMessageHandlerWorker) {
            this.free = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        PluginMessageHandlerWorker pluginMessageHandlerWorker = this;
        synchronized (pluginMessageHandlerWorker) {
            this.free = true;
            this.consumer.notifyWorkerIsFree(this);
        }
    }

    public boolean isPriority() {
        return this.isPriorityWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFree(boolean prioritized) {
        PluginMessageHandlerWorker pluginMessageHandlerWorker = this;
        synchronized (pluginMessageHandlerWorker) {
            return this.free && prioritized == this.isPriorityWorker;
        }
    }

    @Override
    public String toString() {
        return "Worker #" + this.id + "/IsPriority=" + this.isPriorityWorker + "/IsFree=" + this.free + "/Message=" + this.message;
    }
}

