/*
 * Decompiled with CFR 0.152.
 */
package org.omg.CORBA;

import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.Current;
import org.omg.CORBA.DynAny;
import org.omg.CORBA.DynArray;
import org.omg.CORBA.DynEnum;
import org.omg.CORBA.DynSequence;
import org.omg.CORBA.DynStruct;
import org.omg.CORBA.DynUnion;
import org.omg.CORBA.Environment;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ORBPackage.InconsistentTypeCode;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.Request;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.WrongTransaction;
import org.omg.CORBA.portable.OutputStream;

public abstract class ORB {
    private static final String ORBClassKey = "org.omg.CORBA.ORBClass";
    private static final String ORBSingletonClassKey = "org.omg.CORBA.ORBSingletonClass";
    private static final String defaultORB = "com.sun.corba.se.impl.orb.ORBImpl";
    private static final String defaultORBSingleton = "com.sun.corba.se.impl.orb.ORBSingleton";
    private static ORB singleton;

    private static String getSystemProperty(final String name) {
        String propValue = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                return System.getProperty(name);
            }
        });
        return propValue;
    }

    private static String getPropertyFromFile(final String name) {
        String propValue = (String)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Properties getFileProperties(String fileName) {
                try {
                    File propFile = new File(fileName);
                    if (!propFile.exists()) {
                        return null;
                    }
                    Properties props = new Properties();
                    FileInputStream fis = new FileInputStream(propFile);
                    try {
                        props.load(fis);
                    }
                    finally {
                        fis.close();
                    }
                    return props;
                }
                catch (Exception exc) {
                    return null;
                }
            }

            public java.lang.Object run() {
                String value;
                String userHome = System.getProperty("user.home");
                String fileName = userHome + File.separator + "orb.properties";
                Properties props = this.getFileProperties(fileName);
                if (props != null && (value = props.getProperty(name)) != null) {
                    return value;
                }
                String javaHome = System.getProperty("java.home");
                fileName = javaHome + File.separator + "lib" + File.separator + "orb.properties";
                props = this.getFileProperties(fileName);
                if (props == null) {
                    return null;
                }
                return props.getProperty(name);
            }
        });
        return propValue;
    }

    public static synchronized ORB init() {
        if (singleton == null) {
            String className = ORB.getSystemProperty(ORBSingletonClassKey);
            if (className == null) {
                className = ORB.getPropertyFromFile(ORBSingletonClassKey);
            }
            if (className == null) {
                className = defaultORBSingleton;
            }
            singleton = ORB.create_impl(className);
        }
        return singleton;
    }

    private static ORB create_impl(String className) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            return (ORB)Class.forName(className, true, cl).newInstance();
        }
        catch (Throwable ex) {
            INITIALIZE systemException = new INITIALIZE("can't instantiate default ORB implementation " + className);
            systemException.initCause(ex);
            throw systemException;
        }
    }

    public static ORB init(String[] args, Properties props) {
        String className = null;
        if (props != null) {
            className = props.getProperty(ORBClassKey);
        }
        if (className == null) {
            className = ORB.getSystemProperty(ORBClassKey);
        }
        if (className == null) {
            className = ORB.getPropertyFromFile(ORBClassKey);
        }
        if (className == null) {
            className = defaultORB;
        }
        ORB orb = ORB.create_impl(className);
        orb.set_parameters(args, props);
        return orb;
    }

    public static ORB init(Applet app, Properties props) {
        String className = app.getParameter(ORBClassKey);
        if (className == null && props != null) {
            className = props.getProperty(ORBClassKey);
        }
        if (className == null) {
            className = ORB.getSystemProperty(ORBClassKey);
        }
        if (className == null) {
            className = ORB.getPropertyFromFile(ORBClassKey);
        }
        if (className == null) {
            className = defaultORB;
        }
        ORB orb = ORB.create_impl(className);
        orb.set_parameters(app, props);
        return orb;
    }

    protected abstract void set_parameters(String[] var1, Properties var2);

    protected abstract void set_parameters(Applet var1, Properties var2);

    public void connect(Object obj) {
        throw new NO_IMPLEMENT();
    }

    public void destroy() {
        throw new NO_IMPLEMENT();
    }

    public void disconnect(Object obj) {
        throw new NO_IMPLEMENT();
    }

    public abstract String[] list_initial_services();

    public abstract Object resolve_initial_references(String var1) throws InvalidName;

    public abstract String object_to_string(Object var1);

    public abstract Object string_to_object(String var1);

    public abstract NVList create_list(int var1);

    public NVList create_operation_list(Object oper) {
        try {
            String opDefClassName = "org.omg.CORBA.OperationDef";
            Class<?> opDefClass = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            opDefClass = Class.forName(opDefClassName, true, cl);
            Class[] argc = new Class[]{opDefClass};
            Method meth = this.getClass().getMethod("create_operation_list", argc);
            java.lang.Object[] argx = new Object[]{oper};
            return (NVList)meth.invoke(this, argx);
        }
        catch (InvocationTargetException exs) {
            Throwable t = exs.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new NO_IMPLEMENT();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception exr) {
            throw new NO_IMPLEMENT();
        }
    }

    public abstract NamedValue create_named_value(String var1, Any var2, int var3);

    public abstract ExceptionList create_exception_list();

    public abstract ContextList create_context_list();

    public abstract Context get_default_context();

    public abstract Environment create_environment();

    public abstract OutputStream create_output_stream();

    public abstract void send_multiple_requests_oneway(Request[] var1);

    public abstract void send_multiple_requests_deferred(Request[] var1);

    public abstract boolean poll_next_response();

    public abstract Request get_next_response() throws WrongTransaction;

    public abstract TypeCode get_primitive_tc(TCKind var1);

    public abstract TypeCode create_struct_tc(String var1, String var2, StructMember[] var3);

    public abstract TypeCode create_union_tc(String var1, String var2, TypeCode var3, UnionMember[] var4);

    public abstract TypeCode create_enum_tc(String var1, String var2, String[] var3);

    public abstract TypeCode create_alias_tc(String var1, String var2, TypeCode var3);

    public abstract TypeCode create_exception_tc(String var1, String var2, StructMember[] var3);

    public abstract TypeCode create_interface_tc(String var1, String var2);

    public abstract TypeCode create_string_tc(int var1);

    public abstract TypeCode create_wstring_tc(int var1);

    public abstract TypeCode create_sequence_tc(int var1, TypeCode var2);

    @Deprecated
    public abstract TypeCode create_recursive_sequence_tc(int var1, int var2);

    public abstract TypeCode create_array_tc(int var1, TypeCode var2);

    public TypeCode create_native_tc(String id, String name) {
        throw new NO_IMPLEMENT();
    }

    public TypeCode create_abstract_interface_tc(String id, String name) {
        throw new NO_IMPLEMENT();
    }

    public TypeCode create_fixed_tc(short digits, short scale) {
        throw new NO_IMPLEMENT();
    }

    public TypeCode create_value_tc(String id, String name, short type_modifier, TypeCode concrete_base, ValueMember[] members) {
        throw new NO_IMPLEMENT();
    }

    public TypeCode create_recursive_tc(String id) {
        throw new NO_IMPLEMENT();
    }

    public TypeCode create_value_box_tc(String id, String name, TypeCode boxed_type) {
        throw new NO_IMPLEMENT();
    }

    public abstract Any create_any();

    @Deprecated
    public Current get_current() {
        throw new NO_IMPLEMENT();
    }

    public void run() {
        throw new NO_IMPLEMENT();
    }

    public void shutdown(boolean wait_for_completion) {
        throw new NO_IMPLEMENT();
    }

    public boolean work_pending() {
        throw new NO_IMPLEMENT();
    }

    public void perform_work() {
        throw new NO_IMPLEMENT();
    }

    public boolean get_service_information(short service_type, ServiceInformationHolder service_info) {
        throw new NO_IMPLEMENT();
    }

    @Deprecated
    public DynAny create_dyn_any(Any value) {
        throw new NO_IMPLEMENT();
    }

    @Deprecated
    public DynAny create_basic_dyn_any(TypeCode type) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    @Deprecated
    public DynStruct create_dyn_struct(TypeCode type) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    @Deprecated
    public DynSequence create_dyn_sequence(TypeCode type) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    @Deprecated
    public DynArray create_dyn_array(TypeCode type) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    @Deprecated
    public DynUnion create_dyn_union(TypeCode type) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    @Deprecated
    public DynEnum create_dyn_enum(TypeCode type) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    public Policy create_policy(int type, Any val) throws PolicyError {
        throw new NO_IMPLEMENT();
    }
}

