/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthRootPaneUI
extends BasicRootPaneUI
implements SynthUI {
    private SynthStyle style;

    SynthRootPaneUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SynthRootPaneUI();
    }

    protected void installDefaults(JRootPane c) {
        this.updateStyle(c);
    }

    protected void uninstallDefaults(JRootPane root) {
        SynthContext context = this.getContext(root, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle && oldStyle != null) {
            this.uninstallKeyboardActions((JRootPane)c);
            this.installKeyboardActions((JRootPane)c);
        }
        context.dispose();
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintRootPaneBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintRootPaneBorder(context, g, x, y, w, h);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JRootPane)e.getSource());
        }
        super.propertyChange(e);
    }
}

