/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import sun.swing.BakedArrayList;
import sun.swing.plaf.synth.DefaultSynthStyle;
import sun.swing.plaf.synth.StyleAssociation;

class DefaultSynthStyleFactory
extends SynthStyleFactory {
    public static final int NAME = 0;
    public static final int REGION = 1;
    private List<StyleAssociation> _styles;
    private BakedArrayList _tmpList = new BakedArrayList(5);
    private Map _resolvedStyles;
    private SynthStyle _defaultStyle;

    DefaultSynthStyleFactory() {
        this._styles = new ArrayList<StyleAssociation>();
        this._resolvedStyles = new HashMap();
    }

    public synchronized void addStyle(DefaultSynthStyle style, String path, int type) throws PatternSyntaxException {
        if (path == null) {
            path = ".*";
        }
        if (type == 0) {
            this._styles.add(StyleAssociation.createStyleAssociation(path, style, type));
        } else if (type == 1) {
            this._styles.add(StyleAssociation.createStyleAssociation(path.toLowerCase(), style, type));
        }
    }

    public synchronized SynthStyle getStyle(JComponent c, Region id) {
        BakedArrayList matches = this._tmpList;
        matches.clear();
        this.getMatchingStyles(matches, c, id);
        if (matches.size() == 0) {
            return this.getDefaultStyle();
        }
        matches.cacheHashCode();
        SynthStyle style = this.getCachedStyle(matches);
        if (style == null && (style = this.mergeStyles(matches)) != null) {
            this.cacheStyle(matches, style);
        }
        return style;
    }

    private SynthStyle getDefaultStyle() {
        if (this._defaultStyle == null) {
            this._defaultStyle = new DefaultSynthStyle();
            ((DefaultSynthStyle)this._defaultStyle).setFont(new FontUIResource("Dialog", 0, 12));
        }
        return this._defaultStyle;
    }

    private void getMatchingStyles(List matches, JComponent c, Region id) {
        String idName = id.getLowerCaseName();
        String cName = c.getName();
        if (cName == null) {
            cName = "";
        }
        for (int counter = this._styles.size() - 1; counter >= 0; --counter) {
            StyleAssociation sa;
            String path = (sa = this._styles.get(counter)).getID() == 0 ? cName : idName;
            if (!sa.matches(path) || matches.indexOf(sa.getStyle()) != -1) continue;
            matches.add(sa.getStyle());
        }
    }

    private void cacheStyle(List styles, SynthStyle style) {
        BakedArrayList cachedStyles = new BakedArrayList(styles);
        this._resolvedStyles.put(cachedStyles, style);
    }

    private SynthStyle getCachedStyle(List styles) {
        if (styles.size() == 0) {
            return null;
        }
        return (SynthStyle)this._resolvedStyles.get(styles);
    }

    private SynthStyle mergeStyles(List styles) {
        int size = styles.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (SynthStyle)((DefaultSynthStyle)styles.get(0)).clone();
        }
        DefaultSynthStyle style = (DefaultSynthStyle)styles.get(size - 1);
        style = (DefaultSynthStyle)style.clone();
        for (int counter = size - 2; counter >= 0; --counter) {
            style = ((DefaultSynthStyle)styles.get(counter)).addTo(style);
        }
        return style;
    }
}

