/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.shell.ShellFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private JFileChooser filechooser = null;
    private Vector fileCache = new Vector(50);
    private LoadFilesThread loadThread = null;
    private Vector files = null;
    private Vector directories = null;
    private int fetchID = 0;
    private PropertyChangeSupport changeSupport;
    private boolean busy = false;

    public BasicDirectoryModel(JFileChooser filechooser) {
        this.filechooser = filechooser;
        this.validateFileCache();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop == "directoryChanged" || prop == "fileViewChanged" || prop == "fileFilterChanged" || prop == "FileHidingChanged" || prop == "fileSelectionChanged") {
            this.validateFileCache();
        } else if ("UI".equals(prop)) {
            BasicFileChooserUI ui;
            BasicDirectoryModel model;
            Object old = e.getOldValue();
            if (old instanceof BasicFileChooserUI && (model = (ui = (BasicFileChooserUI)old).getModel()) != null) {
                model.invalidateFileCache();
            }
        } else if ("JFileChooserDialogIsClosingProperty".equals(prop)) {
            this.invalidateFileCache();
        }
    }

    public void invalidateFileCache() {
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.loadThread.cancelRunnables();
            this.loadThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getDirectories() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.directories != null) {
                return this.directories;
            }
            Vector<File> fls = this.getFiles();
            return this.directories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getFiles() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.files != null) {
                return this.files;
            }
            this.files = new Vector();
            this.directories = new Vector();
            this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
            for (int i = 0; i < this.getSize(); ++i) {
                File f = (File)this.fileCache.get(i);
                if (this.filechooser.isTraversable(f)) {
                    this.directories.add(f);
                    continue;
                }
                this.files.add(f);
            }
            return this.files;
        }
    }

    public void validateFileCache() {
        File currentDirectory = this.filechooser.getCurrentDirectory();
        if (currentDirectory == null) {
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.loadThread.cancelRunnables();
        }
        this.setBusy(true, ++this.fetchID);
        this.loadThread = new LoadFilesThread(currentDirectory, this.fetchID);
        this.loadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(File oldFile, File newFile) {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (oldFile.renameTo(newFile)) {
                this.validateFileCache();
                return true;
            }
            return false;
        }
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    @Override
    public int getSize() {
        return this.fileCache.size();
    }

    public boolean contains(Object o) {
        return this.fileCache.contains(o);
    }

    public int indexOf(Object o) {
        return this.fileCache.indexOf(o);
    }

    @Override
    public Object getElementAt(int index) {
        return this.fileCache.get(index);
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    protected void sort(Vector<? extends File> v) {
        ShellFolder.sortFiles(v);
    }

    protected boolean lt(File a, File b) {
        int diff = a.getName().toLowerCase().compareTo(b.getName().toLowerCase());
        if (diff != 0) {
            return diff < 0;
        }
        return a.getName().compareTo(b.getName()) < 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private synchronized void setBusy(final boolean busy, int fid) {
        if (fid == this.fetchID) {
            boolean oldValue = this.busy;
            this.busy = busy;
            if (this.changeSupport != null && busy != oldValue) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BasicDirectoryModel.this.firePropertyChange("busy", !busy, busy);
                    }
                });
            }
        }
    }

    class DoChangeContents
    implements Runnable {
        private List addFiles;
        private List remFiles;
        private boolean doFire = true;
        private int fid;
        private int addStart = 0;
        private int remStart = 0;
        private int change;

        public DoChangeContents(List addFiles, int addStart, List remFiles, int remStart, int fid) {
            this.addFiles = addFiles;
            this.addStart = addStart;
            this.remFiles = remFiles;
            this.remStart = remStart;
            this.fid = fid;
        }

        synchronized void cancel() {
            this.doFire = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (BasicDirectoryModel.this.fetchID == this.fid && this.doFire) {
                int remSize = this.remFiles == null ? 0 : this.remFiles.size();
                int addSize = this.addFiles == null ? 0 : this.addFiles.size();
                Vector vector = BasicDirectoryModel.this.fileCache;
                synchronized (vector) {
                    if (remSize > 0) {
                        BasicDirectoryModel.this.fileCache.removeAll(this.remFiles);
                    }
                    if (addSize > 0) {
                        BasicDirectoryModel.this.fileCache.addAll(this.addStart, this.addFiles);
                    }
                    BasicDirectoryModel.this.files = null;
                    BasicDirectoryModel.this.directories = null;
                }
                if (remSize > 0 && addSize == 0) {
                    BasicDirectoryModel.this.fireIntervalRemoved(BasicDirectoryModel.this, this.remStart, this.remStart + remSize - 1);
                } else if (addSize > 0 && remSize == 0 && BasicDirectoryModel.this.fileCache.size() > addSize) {
                    BasicDirectoryModel.this.fireIntervalAdded(BasicDirectoryModel.this, this.addStart, this.addStart + addSize - 1);
                } else {
                    BasicDirectoryModel.this.fireContentsChanged();
                }
            }
        }
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory;
        int fid;
        Vector runnables;

        public LoadFilesThread(File currentDirectory, int fid) {
            super("Basic L&F File Loading Thread");
            this.currentDirectory = null;
            this.runnables = new Vector(10);
            this.currentDirectory = currentDirectory;
            this.fid = fid;
        }

        private void invokeLater(Runnable runnable) {
            this.runnables.addElement(runnable);
            SwingUtilities.invokeLater(runnable);
        }

        public void run() {
            this.run0();
            BasicDirectoryModel.this.setBusy(false, this.fid);
        }

        public void run0() {
            block21: {
                try {
                    FileSystemView fileSystem = BasicDirectoryModel.this.filechooser.getFileSystemView();
                    File[] list = fileSystem.getFiles(this.currentDirectory, BasicDirectoryModel.this.filechooser.isFileHidingEnabled());
                    Vector<File> acceptsList = new Vector<File>();
                    if (this.isInterrupted()) {
                        return;
                    }
                    for (int i = 0; i < list.length; ++i) {
                        if (!BasicDirectoryModel.this.filechooser.accept(list[i])) continue;
                        acceptsList.addElement(list[i]);
                    }
                    if (this.isInterrupted()) {
                        return;
                    }
                    BasicDirectoryModel.this.sort(acceptsList);
                    Vector<File> newDirectories = new Vector<File>(50);
                    Vector<File> newFiles = new Vector<File>();
                    for (int i = 0; i < acceptsList.size(); ++i) {
                        File f = (File)acceptsList.elementAt(i);
                        boolean isTraversable = BasicDirectoryModel.this.filechooser.isTraversable(f);
                        if (isTraversable) {
                            newDirectories.addElement(f);
                        } else if (!isTraversable && BasicDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                            newFiles.addElement(f);
                        }
                        if (!this.isInterrupted()) continue;
                        return;
                    }
                    Vector<File> newFileCache = new Vector<File>(newDirectories);
                    newFileCache.addAll(newFiles);
                    int newSize = newFileCache.size();
                    int oldSize = BasicDirectoryModel.this.fileCache.size();
                    if (newSize > oldSize) {
                        int start = oldSize;
                        int end = newSize;
                        block4: for (int i = 0; i < oldSize; ++i) {
                            if (newFileCache.get(i).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                            start = i;
                            for (int j = i; j < newSize; ++j) {
                                if (!newFileCache.get(j).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                                end = j;
                                break block4;
                            }
                            break;
                        }
                        if (start >= 0 && end > start && ((Object)newFileCache.subList(end, newSize)).equals(BasicDirectoryModel.this.fileCache.subList(start, oldSize))) {
                            if (this.isInterrupted()) {
                                return;
                            }
                            this.invokeLater(new DoChangeContents(newFileCache.subList(start, end), start, null, 0, this.fid));
                            newFileCache = null;
                        }
                    } else if (newSize < oldSize) {
                        int start = -1;
                        int end = -1;
                        for (int i = 0; i < newSize; ++i) {
                            if (newFileCache.get(i).equals(BasicDirectoryModel.this.fileCache.get(i))) continue;
                            start = i;
                            end = i + oldSize - newSize;
                            break;
                        }
                        if (start >= 0 && end > start && ((Object)BasicDirectoryModel.this.fileCache.subList(end, oldSize)).equals(newFileCache.subList(start, newSize))) {
                            if (this.isInterrupted()) {
                                return;
                            }
                            this.invokeLater(new DoChangeContents(null, 0, new Vector(BasicDirectoryModel.this.fileCache.subList(start, end)), start, this.fid));
                            newFileCache = null;
                        }
                    }
                    if (newFileCache != null && !BasicDirectoryModel.this.fileCache.equals(newFileCache)) {
                        if (this.isInterrupted()) {
                            this.cancelRunnables(this.runnables);
                        }
                        this.invokeLater(new DoChangeContents(newFileCache, 0, BasicDirectoryModel.this.fileCache, 0, this.fid));
                    }
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof InterruptedException) break block21;
                    throw e;
                }
            }
        }

        public void cancelRunnables(Vector runnables) {
            for (int i = 0; i < runnables.size(); ++i) {
                ((DoChangeContents)runnables.elementAt(i)).cancel();
            }
        }

        public void cancelRunnables() {
            this.cancelRunnables(this.runnables);
        }
    }
}

