/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanPermission
extends Permission {
    private static final long serialVersionUID = -2416928705275160661L;
    private static final int AddNotificationListener = 1;
    private static final int GetAttribute = 2;
    private static final int GetClassLoader = 4;
    private static final int GetClassLoaderFor = 8;
    private static final int GetClassLoaderRepository = 16;
    private static final int GetDomains = 32;
    private static final int GetMBeanInfo = 64;
    private static final int GetObjectInstance = 128;
    private static final int Instantiate = 256;
    private static final int Invoke = 512;
    private static final int IsInstanceOf = 1024;
    private static final int QueryMBeans = 2048;
    private static final int QueryNames = 4096;
    private static final int RegisterMBean = 8192;
    private static final int RemoveNotificationListener = 16384;
    private static final int SetAttribute = 32768;
    private static final int UnregisterMBean = 65536;
    private static final int NONE = 0;
    private static final int ALL = 131071;
    private String actions;
    private transient int mask;
    private transient String classNamePrefix;
    private transient boolean classNameExactMatch;
    private transient String member;
    private transient ObjectName objectName;

    private void parseActions() {
        if (this.actions == null) {
            throw new IllegalArgumentException("MBeanPermission: actions can't be null");
        }
        if (this.actions.equals("")) {
            throw new IllegalArgumentException("MBeanPermission: actions can't be empty");
        }
        int mask = MBeanPermission.getMask(this.actions);
        if ((mask & 0x1FFFF) != mask) {
            throw new IllegalArgumentException("Invalid actions mask");
        }
        if (mask == 0) {
            throw new IllegalArgumentException("Invalid actions mask");
        }
        this.mask = mask;
    }

    private void parseName() {
        String name = this.getName();
        if (name == null) {
            throw new IllegalArgumentException("MBeanPermission name cannot be null");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("MBeanPermission name cannot be empty");
        }
        int openingBracket = name.indexOf("[");
        if (openingBracket == -1) {
            this.objectName = ObjectName.WILDCARD;
        } else {
            if (!name.endsWith("]")) {
                throw new IllegalArgumentException("MBeanPermission: The ObjectName in the target name must be included in square brackets");
            }
            try {
                String on = name.substring(openingBracket + 1, name.length() - 1);
                this.objectName = on.equals("") ? ObjectName.WILDCARD : (on.equals("-") ? null : new ObjectName(on));
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("MBeanPermission: The target name does not specify a valid ObjectName");
            }
            name = name.substring(0, openingBracket);
        }
        int poundSign = name.indexOf("#");
        if (poundSign == -1) {
            this.setMember("*");
        } else {
            String memberName = name.substring(poundSign + 1);
            this.setMember(memberName);
            name = name.substring(0, poundSign);
        }
        this.setClassName(name);
    }

    private void initName(String className, String member, ObjectName objectName) {
        this.setClassName(className);
        this.setMember(member);
        this.objectName = objectName;
    }

    private void setClassName(String className) {
        if (className == null || className.equals("-")) {
            this.classNamePrefix = null;
            this.classNameExactMatch = false;
        } else if (className.equals("") || className.equals("*")) {
            this.classNamePrefix = "";
            this.classNameExactMatch = false;
        } else if (className.endsWith(".*")) {
            this.classNamePrefix = className.substring(0, className.length() - 1);
            this.classNameExactMatch = false;
        } else {
            this.classNamePrefix = className;
            this.classNameExactMatch = true;
        }
    }

    private void setMember(String member) {
        this.member = member == null || member.equals("-") ? null : (member.equals("") ? "*" : member);
    }

    public MBeanPermission(String name, String actions2) {
        super(name);
        this.parseName();
        this.actions = actions2;
        this.parseActions();
    }

    public MBeanPermission(String className, String member, ObjectName objectName, String actions2) {
        super(MBeanPermission.makeName(className, member, objectName));
        this.initName(className, member, objectName);
        this.actions = actions2;
        this.parseActions();
    }

    private static String makeName(String className, String member, ObjectName objectName) {
        StringBuilder name = new StringBuilder();
        if (className == null) {
            className = "-";
        }
        name.append(className);
        if (member == null) {
            member = "-";
        }
        name.append("#" + member);
        if (objectName == null) {
            name.append("[-]");
        } else {
            name.append("[").append(objectName.getCanonicalName()).append("]");
        }
        if (name.length() == 0) {
            return "*";
        }
        return name.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = MBeanPermission.getActions(this.mask);
        }
        return this.actions;
    }

    private static String getActions(int mask) {
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        if ((mask & 1) == 1) {
            comma = true;
            sb.append("addNotificationListener");
        }
        if ((mask & 2) == 2) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("getAttribute");
        }
        if ((mask & 4) == 4) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("getClassLoader");
        }
        if ((mask & 8) == 8) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("getClassLoaderFor");
        }
        if ((mask & 0x10) == 16) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("getClassLoaderRepository");
        }
        if ((mask & 0x20) == 32) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("getDomains");
        }
        if ((mask & 0x40) == 64) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("getMBeanInfo");
        }
        if ((mask & 0x80) == 128) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("getObjectInstance");
        }
        if ((mask & 0x100) == 256) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("instantiate");
        }
        if ((mask & 0x200) == 512) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("invoke");
        }
        if ((mask & 0x400) == 1024) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("isInstanceOf");
        }
        if ((mask & 0x800) == 2048) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("queryMBeans");
        }
        if ((mask & 0x1000) == 4096) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("queryNames");
        }
        if ((mask & 0x2000) == 8192) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("registerMBean");
        }
        if ((mask & 0x4000) == 16384) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("removeNotificationListener");
        }
        if ((mask & 0x8000) == 32768) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("setAttribute");
        }
        if ((mask & 0x10000) == 65536) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("unregisterMBean");
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getActions().hashCode();
    }

    private static int getMask(String action) {
        int mask = 0;
        if (action == null) {
            return mask;
        }
        if (action.equals("*")) {
            return 131071;
        }
        char[] a = action.toCharArray();
        int i = a.length - 1;
        if (i < 0) {
            return mask;
        }
        while (i != -1) {
            int matchlen;
            char c;
            while (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --i;
            }
            if (i >= 25 && a[i - 25] == 'r' && a[i - 24] == 'e' && a[i - 23] == 'm' && a[i - 22] == 'o' && a[i - 21] == 'v' && a[i - 20] == 'e' && a[i - 19] == 'N' && a[i - 18] == 'o' && a[i - 17] == 't' && a[i - 16] == 'i' && a[i - 15] == 'f' && a[i - 14] == 'i' && a[i - 13] == 'c' && a[i - 12] == 'a' && a[i - 11] == 't' && a[i - 10] == 'i' && a[i - 9] == 'o' && a[i - 8] == 'n' && a[i - 7] == 'L' && a[i - 6] == 'i' && a[i - 5] == 's' && a[i - 4] == 't' && a[i - 3] == 'e' && a[i - 2] == 'n' && a[i - 1] == 'e' && a[i] == 'r') {
                matchlen = 26;
                mask |= 0x4000;
            } else if (i >= 23 && a[i - 23] == 'g' && a[i - 22] == 'e' && a[i - 21] == 't' && a[i - 20] == 'C' && a[i - 19] == 'l' && a[i - 18] == 'a' && a[i - 17] == 's' && a[i - 16] == 's' && a[i - 15] == 'L' && a[i - 14] == 'o' && a[i - 13] == 'a' && a[i - 12] == 'd' && a[i - 11] == 'e' && a[i - 10] == 'r' && a[i - 9] == 'R' && a[i - 8] == 'e' && a[i - 7] == 'p' && a[i - 6] == 'o' && a[i - 5] == 's' && a[i - 4] == 'i' && a[i - 3] == 't' && a[i - 2] == 'o' && a[i - 1] == 'r' && a[i] == 'y') {
                matchlen = 24;
                mask |= 0x10;
            } else if (i >= 22 && a[i - 22] == 'a' && a[i - 21] == 'd' && a[i - 20] == 'd' && a[i - 19] == 'N' && a[i - 18] == 'o' && a[i - 17] == 't' && a[i - 16] == 'i' && a[i - 15] == 'f' && a[i - 14] == 'i' && a[i - 13] == 'c' && a[i - 12] == 'a' && a[i - 11] == 't' && a[i - 10] == 'i' && a[i - 9] == 'o' && a[i - 8] == 'n' && a[i - 7] == 'L' && a[i - 6] == 'i' && a[i - 5] == 's' && a[i - 4] == 't' && a[i - 3] == 'e' && a[i - 2] == 'n' && a[i - 1] == 'e' && a[i] == 'r') {
                matchlen = 23;
                mask |= 1;
            } else if (i >= 16 && a[i - 16] == 'g' && a[i - 15] == 'e' && a[i - 14] == 't' && a[i - 13] == 'C' && a[i - 12] == 'l' && a[i - 11] == 'a' && a[i - 10] == 's' && a[i - 9] == 's' && a[i - 8] == 'L' && a[i - 7] == 'o' && a[i - 6] == 'a' && a[i - 5] == 'd' && a[i - 4] == 'e' && a[i - 3] == 'r' && a[i - 2] == 'F' && a[i - 1] == 'o' && a[i] == 'r') {
                matchlen = 17;
                mask |= 8;
            } else if (i >= 16 && a[i - 16] == 'g' && a[i - 15] == 'e' && a[i - 14] == 't' && a[i - 13] == 'O' && a[i - 12] == 'b' && a[i - 11] == 'j' && a[i - 10] == 'e' && a[i - 9] == 'c' && a[i - 8] == 't' && a[i - 7] == 'I' && a[i - 6] == 'n' && a[i - 5] == 's' && a[i - 4] == 't' && a[i - 3] == 'a' && a[i - 2] == 'n' && a[i - 1] == 'c' && a[i] == 'e') {
                matchlen = 17;
                mask |= 0x80;
            } else if (i >= 14 && a[i - 14] == 'u' && a[i - 13] == 'n' && a[i - 12] == 'r' && a[i - 11] == 'e' && a[i - 10] == 'g' && a[i - 9] == 'i' && a[i - 8] == 's' && a[i - 7] == 't' && a[i - 6] == 'e' && a[i - 5] == 'r' && a[i - 4] == 'M' && a[i - 3] == 'B' && a[i - 2] == 'e' && a[i - 1] == 'a' && a[i] == 'n') {
                matchlen = 15;
                mask |= 0x10000;
            } else if (i >= 13 && a[i - 13] == 'g' && a[i - 12] == 'e' && a[i - 11] == 't' && a[i - 10] == 'C' && a[i - 9] == 'l' && a[i - 8] == 'a' && a[i - 7] == 's' && a[i - 6] == 's' && a[i - 5] == 'L' && a[i - 4] == 'o' && a[i - 3] == 'a' && a[i - 2] == 'd' && a[i - 1] == 'e' && a[i] == 'r') {
                matchlen = 14;
                mask |= 4;
            } else if (i >= 12 && a[i - 12] == 'r' && a[i - 11] == 'e' && a[i - 10] == 'g' && a[i - 9] == 'i' && a[i - 8] == 's' && a[i - 7] == 't' && a[i - 6] == 'e' && a[i - 5] == 'r' && a[i - 4] == 'M' && a[i - 3] == 'B' && a[i - 2] == 'e' && a[i - 1] == 'a' && a[i] == 'n') {
                matchlen = 13;
                mask |= 0x2000;
            } else if (i >= 11 && a[i - 11] == 'g' && a[i - 10] == 'e' && a[i - 9] == 't' && a[i - 8] == 'A' && a[i - 7] == 't' && a[i - 6] == 't' && a[i - 5] == 'r' && a[i - 4] == 'i' && a[i - 3] == 'b' && a[i - 2] == 'u' && a[i - 1] == 't' && a[i] == 'e') {
                matchlen = 12;
                mask |= 2;
            } else if (i >= 11 && a[i - 11] == 'g' && a[i - 10] == 'e' && a[i - 9] == 't' && a[i - 8] == 'M' && a[i - 7] == 'B' && a[i - 6] == 'e' && a[i - 5] == 'a' && a[i - 4] == 'n' && a[i - 3] == 'I' && a[i - 2] == 'n' && a[i - 1] == 'f' && a[i] == 'o') {
                matchlen = 12;
                mask |= 0x40;
            } else if (i >= 11 && a[i - 11] == 'i' && a[i - 10] == 's' && a[i - 9] == 'I' && a[i - 8] == 'n' && a[i - 7] == 's' && a[i - 6] == 't' && a[i - 5] == 'a' && a[i - 4] == 'n' && a[i - 3] == 'c' && a[i - 2] == 'e' && a[i - 1] == 'O' && a[i] == 'f') {
                matchlen = 12;
                mask |= 0x400;
            } else if (i >= 11 && a[i - 11] == 's' && a[i - 10] == 'e' && a[i - 9] == 't' && a[i - 8] == 'A' && a[i - 7] == 't' && a[i - 6] == 't' && a[i - 5] == 'r' && a[i - 4] == 'i' && a[i - 3] == 'b' && a[i - 2] == 'u' && a[i - 1] == 't' && a[i] == 'e') {
                matchlen = 12;
                mask |= 0x8000;
            } else if (i >= 10 && a[i - 10] == 'i' && a[i - 9] == 'n' && a[i - 8] == 's' && a[i - 7] == 't' && a[i - 6] == 'a' && a[i - 5] == 'n' && a[i - 4] == 't' && a[i - 3] == 'i' && a[i - 2] == 'a' && a[i - 1] == 't' && a[i] == 'e') {
                matchlen = 11;
                mask |= 0x100;
            } else if (i >= 10 && a[i - 10] == 'q' && a[i - 9] == 'u' && a[i - 8] == 'e' && a[i - 7] == 'r' && a[i - 6] == 'y' && a[i - 5] == 'M' && a[i - 4] == 'B' && a[i - 3] == 'e' && a[i - 2] == 'a' && a[i - 1] == 'n' && a[i] == 's') {
                matchlen = 11;
                mask |= 0x800;
            } else if (i >= 9 && a[i - 9] == 'g' && a[i - 8] == 'e' && a[i - 7] == 't' && a[i - 6] == 'D' && a[i - 5] == 'o' && a[i - 4] == 'm' && a[i - 3] == 'a' && a[i - 2] == 'i' && a[i - 1] == 'n' && a[i] == 's') {
                matchlen = 10;
                mask |= 0x20;
            } else if (i >= 9 && a[i - 9] == 'q' && a[i - 8] == 'u' && a[i - 7] == 'e' && a[i - 6] == 'r' && a[i - 5] == 'y' && a[i - 4] == 'N' && a[i - 3] == 'a' && a[i - 2] == 'm' && a[i - 1] == 'e' && a[i] == 's') {
                matchlen = 10;
                mask |= 0x1000;
            } else if (i >= 5 && a[i - 5] == 'i' && a[i - 4] == 'n' && a[i - 3] == 'v' && a[i - 2] == 'o' && a[i - 1] == 'k' && a[i] == 'e') {
                matchlen = 6;
                mask |= 0x200;
            } else {
                throw new IllegalArgumentException("Invalid permission: " + action);
            }
            boolean seencomma = false;
            while (i >= matchlen && !seencomma) {
                switch (a[i - matchlen]) {
                    case ',': {
                        seencomma = true;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid permission: " + action);
                    }
                }
                --i;
            }
            i -= matchlen;
        }
        return mask;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof MBeanPermission)) {
            return false;
        }
        MBeanPermission that = (MBeanPermission)p;
        if ((this.mask & 0x800) == 2048 ? ((this.mask | 0x1000) & that.mask) != that.mask : (this.mask & that.mask) != that.mask) {
            return false;
        }
        if (that.classNamePrefix != null) {
            if (this.classNamePrefix == null) {
                return false;
            }
            if (this.classNameExactMatch) {
                if (!that.classNameExactMatch) {
                    return false;
                }
                if (!that.classNamePrefix.equals(this.classNamePrefix)) {
                    return false;
                }
            } else if (!that.classNamePrefix.startsWith(this.classNamePrefix)) {
                return false;
            }
        }
        if (that.member != null) {
            if (this.member == null) {
                return false;
            }
            if (!this.member.equals("*") && !this.member.equals(that.member)) {
                return false;
            }
        }
        if (that.objectName != null) {
            if (this.objectName == null) {
                return false;
            }
            if (!this.objectName.apply(that.objectName) && !this.objectName.equals(that.objectName)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MBeanPermission)) {
            return false;
        }
        MBeanPermission that = (MBeanPermission)obj;
        return this.mask == that.mask && this.getName().equals(that.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.parseName();
        this.parseActions();
    }
}

