/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.Checksum;

public class CRC32
implements Checksum {
    private int crc;

    public void update(int b) {
        this.crc = CRC32.update(this.crc, b);
    }

    public void update(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.crc = CRC32.updateBytes(this.crc, b, off, len);
    }

    public void update(byte[] b) {
        this.crc = CRC32.updateBytes(this.crc, b, 0, b.length);
    }

    public void reset() {
        this.crc = 0;
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    private static native int update(int var0, int var1);

    private static native int updateBytes(int var0, byte[] var1, int var2, int var3);
}

