/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Short
extends Number
implements Comparable<Short> {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class<Short> TYPE = Class.getPrimitiveClass("short");
    private final short value;
    public static final int SIZE = 16;
    private static final long serialVersionUID = 7515723908773894738L;

    public static String toString(short s) {
        return Integer.toString(s, 10);
    }

    public static short parseShort(String s, int radix) throws NumberFormatException {
        int i = Integer.parseInt(s, radix);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Value out of range. Value:\"" + s + "\" Radix:" + radix);
        }
        return (short)i;
    }

    public static short parseShort(String s) throws NumberFormatException {
        return Short.parseShort(s, 10);
    }

    public static Short valueOf(String s, int radix) throws NumberFormatException {
        return new Short(Short.parseShort(s, radix));
    }

    public static Short valueOf(String s) throws NumberFormatException {
        return Short.valueOf(s, 10);
    }

    public static Short valueOf(short s) {
        int offset = 128;
        short sAsInt = s;
        if (sAsInt >= -128 && sAsInt <= 127) {
            return ShortCache.cache[sAsInt + 128];
        }
        return new Short(s);
    }

    public static Short decode(String nm) throws NumberFormatException {
        int i = Integer.decode(nm);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Value " + i + " out of range from input " + nm);
        }
        return (short)i;
    }

    public Short(short value) {
        this.value = value;
    }

    public Short(String s) throws NumberFormatException {
        this.value = Short.parseShort(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Short) {
            return this.value == (Short)obj;
        }
        return false;
    }

    @Override
    public int compareTo(Short anotherShort) {
        return this.value - anotherShort.value;
    }

    public static short reverseBytes(short i) {
        return (short)((i & 0xFF00) >> 8 | i << 8);
    }

    private static class ShortCache {
        static final Short[] cache = new Short[256];

        private ShortCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ShortCache.cache[i] = new Short((short)(i - 128));
            }
        }
    }
}

