/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.TypeResolver;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureDescriptor {
    private Reference<Class> classRef;
    private boolean expert;
    private boolean hidden;
    private boolean preferred;
    private String shortDescription;
    private String name;
    private String displayName;
    private Hashtable table;

    public FeatureDescriptor() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.getName();
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean preferred) {
        this.preferred = preferred;
    }

    public String getShortDescription() {
        if (this.shortDescription == null) {
            return this.getDisplayName();
        }
        return this.shortDescription;
    }

    public void setShortDescription(String text) {
        this.shortDescription = text;
    }

    public void setValue(String attributeName, Object value) {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        this.table.put(attributeName, value);
    }

    public Object getValue(String attributeName) {
        if (this.table == null) {
            return null;
        }
        return this.table.get(attributeName);
    }

    public Enumeration<String> attributeNames() {
        if (this.table == null) {
            this.table = new Hashtable();
        }
        return this.table.keys();
    }

    FeatureDescriptor(FeatureDescriptor x, FeatureDescriptor y) {
        this.expert = x.expert | y.expert;
        this.hidden = x.hidden | y.hidden;
        this.preferred = x.preferred | y.preferred;
        this.name = y.name;
        this.shortDescription = x.shortDescription;
        if (y.shortDescription != null) {
            this.shortDescription = y.shortDescription;
        }
        this.displayName = x.displayName;
        if (y.displayName != null) {
            this.displayName = y.displayName;
        }
        this.classRef = x.classRef;
        if (y.classRef != null) {
            this.classRef = y.classRef;
        }
        this.addTable(x.table);
        this.addTable(y.table);
    }

    FeatureDescriptor(FeatureDescriptor old) {
        this.expert = old.expert;
        this.hidden = old.hidden;
        this.preferred = old.preferred;
        this.name = old.name;
        this.shortDescription = old.shortDescription;
        this.displayName = old.displayName;
        this.classRef = old.classRef;
        this.addTable(old.table);
    }

    private void addTable(Hashtable t) {
        if (t == null) {
            return;
        }
        Enumeration keys = t.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = t.get(key);
            this.setValue(key, value);
        }
    }

    void setClass0(Class cls) {
        this.classRef = FeatureDescriptor.getWeakReference(cls);
    }

    Class getClass0() {
        return this.classRef != null ? this.classRef.get() : null;
    }

    static Reference createReference(Object obj, boolean soft) {
        Reference ref = null;
        if (obj != null) {
            ref = soft ? new SoftReference<Object>(obj) : new WeakReference<Object>(obj);
        }
        return ref;
    }

    static Reference createReference(Object obj) {
        return FeatureDescriptor.createReference(obj, false);
    }

    static Object getObject(Reference ref) {
        return ref == null ? null : ref.get();
    }

    static <T> Reference<T> getSoftReference(T object) {
        return object != null ? new SoftReference<T>(object) : null;
    }

    static <T> Reference<T> getWeakReference(T object) {
        return object != null ? new WeakReference<T>(object) : null;
    }

    static Class getReturnType(Class base, Method method) {
        if (base == null) {
            base = method.getDeclaringClass();
        }
        return TypeResolver.erase(TypeResolver.resolveInClass(base, method.getGenericReturnType()));
    }

    static Class[] getParameterTypes(Class base, Method method) {
        if (base == null) {
            base = method.getDeclaringClass();
        }
        return TypeResolver.erase(TypeResolver.resolveInClass(base, method.getGenericParameterTypes()));
    }
}

