/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

abstract class MultipleGradientPaintContext
implements PaintContext {
    protected ColorModel model;
    private static ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    protected static ColorModel cachedModel;
    protected static WeakReference<Raster> cached;
    protected Raster saved;
    protected MultipleGradientPaint.CycleMethod cycleMethod;
    protected MultipleGradientPaint.ColorSpaceType colorSpace;
    protected float a00;
    protected float a01;
    protected float a10;
    protected float a11;
    protected float a02;
    protected float a12;
    protected boolean isSimpleLookup;
    protected int fastGradientArraySize;
    protected int[] gradient;
    private int[][] gradients;
    private float[] normalizedIntervals;
    private float[] fractions;
    private int transparencyTest;
    private static final int[] SRGBtoLinearRGB;
    private static final int[] LinearRGBtoSRGB;
    protected static final int GRADIENT_SIZE = 256;
    protected static final int GRADIENT_SIZE_INDEX = 255;
    private static final int MAX_GRADIENT_ARRAY_SIZE = 5000;

    protected MultipleGradientPaintContext(MultipleGradientPaint mgp, ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform t, RenderingHints hints, float[] fractions, Color[] colors, MultipleGradientPaint.CycleMethod cycleMethod, MultipleGradientPaint.ColorSpaceType colorSpace) {
        int[][] gradients;
        AffineTransform tInv;
        if (deviceBounds == null) {
            throw new NullPointerException("Device bounds cannot be null");
        }
        if (userBounds == null) {
            throw new NullPointerException("User bounds cannot be null");
        }
        if (t == null) {
            throw new NullPointerException("Transform cannot be null");
        }
        if (hints == null) {
            throw new NullPointerException("RenderingHints cannot be null");
        }
        try {
            t.invert();
            tInv = t;
        }
        catch (NoninvertibleTransformException e) {
            tInv = new AffineTransform();
        }
        double[] m = new double[6];
        tInv.getMatrix(m);
        this.a00 = (float)m[0];
        this.a10 = (float)m[1];
        this.a01 = (float)m[2];
        this.a11 = (float)m[3];
        this.a02 = (float)m[4];
        this.a12 = (float)m[5];
        this.cycleMethod = cycleMethod;
        this.colorSpace = colorSpace;
        this.fractions = fractions;
        int[] gradient = mgp.gradient != null ? mgp.gradient.get() : null;
        int[][] nArray = gradients = mgp.gradients != null ? mgp.gradients.get() : (int[][])null;
        if (gradient == null && gradients == null) {
            this.calculateLookupData(colors);
            mgp.model = this.model;
            mgp.normalizedIntervals = this.normalizedIntervals;
            mgp.isSimpleLookup = this.isSimpleLookup;
            if (this.isSimpleLookup) {
                mgp.fastGradientArraySize = this.fastGradientArraySize;
                mgp.gradient = new SoftReference<int[]>(this.gradient);
            } else {
                mgp.gradients = new SoftReference<int[][]>(this.gradients);
            }
        } else {
            this.model = mgp.model;
            this.normalizedIntervals = mgp.normalizedIntervals;
            this.isSimpleLookup = mgp.isSimpleLookup;
            this.gradient = gradient;
            this.fastGradientArraySize = mgp.fastGradientArraySize;
            this.gradients = gradients;
        }
    }

    private void calculateLookupData(Color[] colors) {
        int i;
        Color[] normalizedColors;
        if (this.colorSpace == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
            normalizedColors = new Color[colors.length];
            for (i = 0; i < colors.length; ++i) {
                int argb = colors[i].getRGB();
                int a = argb >>> 24;
                int r = SRGBtoLinearRGB[argb >> 16 & 0xFF];
                int g = SRGBtoLinearRGB[argb >> 8 & 0xFF];
                int b = SRGBtoLinearRGB[argb & 0xFF];
                normalizedColors[i] = new Color(r, g, b, a);
            }
        } else {
            normalizedColors = colors;
        }
        this.normalizedIntervals = new float[this.fractions.length - 1];
        for (i = 0; i < this.normalizedIntervals.length; ++i) {
            this.normalizedIntervals[i] = this.fractions[i + 1] - this.fractions[i];
        }
        this.transparencyTest = -16777216;
        this.gradients = new int[this.normalizedIntervals.length][];
        float Imin = 1.0f;
        for (int i2 = 0; i2 < this.normalizedIntervals.length; ++i2) {
            Imin = Imin > this.normalizedIntervals[i2] ? this.normalizedIntervals[i2] : Imin;
        }
        int estimatedSize = 0;
        for (int i3 = 0; i3 < this.normalizedIntervals.length; ++i3) {
            estimatedSize = (int)((float)estimatedSize + this.normalizedIntervals[i3] / Imin * 256.0f);
        }
        if (estimatedSize > 5000) {
            this.calculateMultipleArrayGradient(normalizedColors);
        } else {
            this.calculateSingleArrayGradient(normalizedColors, Imin);
        }
        this.model = this.transparencyTest >>> 24 == 255 ? xrgbmodel : ColorModel.getRGBdefault();
    }

    private void calculateSingleArrayGradient(Color[] colors, float Imin) {
        int i;
        this.isSimpleLookup = true;
        int gradientsTot = 1;
        for (int i2 = 0; i2 < this.gradients.length; ++i2) {
            int nGradients = (int)(this.normalizedIntervals[i2] / Imin * 255.0f);
            gradientsTot += nGradients;
            this.gradients[i2] = new int[nGradients];
            int rgb1 = colors[i2].getRGB();
            int rgb2 = colors[i2 + 1].getRGB();
            this.interpolate(rgb1, rgb2, this.gradients[i2]);
            this.transparencyTest &= rgb1;
            this.transparencyTest &= rgb2;
        }
        this.gradient = new int[gradientsTot];
        int curOffset = 0;
        for (i = 0; i < this.gradients.length; ++i) {
            System.arraycopy(this.gradients[i], 0, this.gradient, curOffset, this.gradients[i].length);
            curOffset += this.gradients[i].length;
        }
        this.gradient[this.gradient.length - 1] = colors[colors.length - 1].getRGB();
        if (this.colorSpace == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
            for (i = 0; i < this.gradient.length; ++i) {
                this.gradient[i] = this.convertEntireColorLinearRGBtoSRGB(this.gradient[i]);
            }
        }
        this.fastGradientArraySize = this.gradient.length - 1;
    }

    private void calculateMultipleArrayGradient(Color[] colors) {
        this.isSimpleLookup = false;
        for (int i = 0; i < this.gradients.length; ++i) {
            this.gradients[i] = new int[256];
            int rgb1 = colors[i].getRGB();
            int rgb2 = colors[i + 1].getRGB();
            this.interpolate(rgb1, rgb2, this.gradients[i]);
            this.transparencyTest &= rgb1;
            this.transparencyTest &= rgb2;
        }
        if (this.colorSpace == MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
            for (int j = 0; j < this.gradients.length; ++j) {
                for (int i = 0; i < this.gradients[j].length; ++i) {
                    this.gradients[j][i] = this.convertEntireColorLinearRGBtoSRGB(this.gradients[j][i]);
                }
            }
        }
    }

    private void interpolate(int rgb1, int rgb2, int[] output) {
        float stepSize = 1.0f / (float)output.length;
        int a1 = rgb1 >> 24 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int da = (rgb2 >> 24 & 0xFF) - a1;
        int dr = (rgb2 >> 16 & 0xFF) - r1;
        int dg = (rgb2 >> 8 & 0xFF) - g1;
        int db = (rgb2 & 0xFF) - b1;
        for (int i = 0; i < output.length; ++i) {
            output[i] = (int)((double)((float)a1 + (float)(i * da) * stepSize) + 0.5) << 24 | (int)((double)((float)r1 + (float)(i * dr) * stepSize) + 0.5) << 16 | (int)((double)((float)g1 + (float)(i * dg) * stepSize) + 0.5) << 8 | (int)((double)((float)b1 + (float)(i * db) * stepSize) + 0.5);
        }
    }

    private int convertEntireColorLinearRGBtoSRGB(int rgb) {
        int a1 = rgb >> 24 & 0xFF;
        int r1 = rgb >> 16 & 0xFF;
        int g1 = rgb >> 8 & 0xFF;
        int b1 = rgb & 0xFF;
        r1 = LinearRGBtoSRGB[r1];
        g1 = LinearRGBtoSRGB[g1];
        b1 = LinearRGBtoSRGB[b1];
        return a1 << 24 | r1 << 16 | g1 << 8 | b1;
    }

    protected final int indexIntoGradientsArrays(float position) {
        if (this.cycleMethod == MultipleGradientPaint.CycleMethod.NO_CYCLE) {
            if (position > 1.0f) {
                position = 1.0f;
            } else if (position < 0.0f) {
                position = 0.0f;
            }
        } else if (this.cycleMethod == MultipleGradientPaint.CycleMethod.REPEAT) {
            if ((position -= (float)((int)position)) < 0.0f) {
                position += 1.0f;
            }
        } else {
            if (position < 0.0f) {
                position = -position;
            }
            int part = (int)position;
            position -= (float)part;
            if ((part & 1) == 1) {
                position = 1.0f - position;
            }
        }
        if (this.isSimpleLookup) {
            return this.gradient[(int)(position * (float)this.fastGradientArraySize)];
        }
        for (int i = 0; i < this.gradients.length; ++i) {
            if (!(position < this.fractions[i + 1])) continue;
            float delta = position - this.fractions[i];
            int index = (int)(delta / this.normalizedIntervals[i] * 255.0f);
            return this.gradients[i][index];
        }
        return this.gradients[this.gradients.length - 1][255];
    }

    private static int convertSRGBtoLinearRGB(int color) {
        float input = (float)color / 255.0f;
        float output = input <= 0.04045f ? input / 12.92f : (float)Math.pow(((double)input + 0.055) / 1.055, 2.4);
        return Math.round(output * 255.0f);
    }

    private static int convertLinearRGBtoSRGB(int color) {
        float input = (float)color / 255.0f;
        float output = (double)input <= 0.0031308 ? input * 12.92f : 1.055f * (float)Math.pow(input, 0.4166666666666667) - 0.055f;
        return Math.round(output * 255.0f);
    }

    public final Raster getRaster(int x, int y, int w, int h) {
        Raster raster = this.saved;
        if (raster == null || raster.getWidth() < w || raster.getHeight() < h) {
            this.saved = raster = MultipleGradientPaintContext.getCachedRaster(this.model, w, h);
        }
        DataBufferInt rasterDB = (DataBufferInt)raster.getDataBuffer();
        int[] pixels = rasterDB.getData(0);
        int off = rasterDB.getOffset();
        int scanlineStride = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int adjust = scanlineStride - w;
        this.fillRaster(pixels, off, adjust, x, y, w, h);
        return raster;
    }

    protected abstract void fillRaster(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static synchronized Raster getCachedRaster(ColorModel cm, int w, int h) {
        Raster ras;
        if (cm == cachedModel && cached != null && (ras = (Raster)cached.get()) != null && ras.getWidth() >= w && ras.getHeight() >= h) {
            cached = null;
            return ras;
        }
        return cm.createCompatibleWritableRaster(w, h);
    }

    private static synchronized void putCachedRaster(ColorModel cm, Raster ras) {
        Raster cras;
        if (cached != null && (cras = (Raster)cached.get()) != null) {
            int cw = cras.getWidth();
            int ch = cras.getHeight();
            int iw = ras.getWidth();
            int ih = ras.getHeight();
            if (cw >= iw && ch >= ih) {
                return;
            }
            if (cw * ch >= iw * ih) {
                return;
            }
        }
        cachedModel = cm;
        cached = new WeakReference<Raster>(ras);
    }

    public final void dispose() {
        if (this.saved != null) {
            MultipleGradientPaintContext.putCachedRaster(this.model, this.saved);
            this.saved = null;
        }
    }

    public final ColorModel getColorModel() {
        return this.model;
    }

    static {
        SRGBtoLinearRGB = new int[256];
        LinearRGBtoSRGB = new int[256];
        for (int k = 0; k < 256; ++k) {
            MultipleGradientPaintContext.SRGBtoLinearRGB[k] = MultipleGradientPaintContext.convertSRGBtoLinearRGB(k);
            MultipleGradientPaintContext.LinearRGBtoSRGB[k] = MultipleGradientPaintContext.convertLinearRGBtoSRGB(k);
        }
    }
}

