/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.UnsolicitedNotification;

final class UnsolicitedResponseImpl
implements UnsolicitedNotification {
    private String oid;
    private String[] referrals;
    private byte[] extensionValue;
    private NamingException exception;
    private Control[] controls;
    private static final long serialVersionUID = 5913778898401784775L;

    UnsolicitedResponseImpl(String oid, byte[] berVal, Vector ref, int status, String msg, String matchedDN, Control[] controls) {
        this.oid = oid;
        this.extensionValue = berVal;
        if (ref != null && ref.size() > 0) {
            int len = ref.size();
            this.referrals = new String[len];
            for (int i = 0; i < len; ++i) {
                this.referrals[i] = (String)ref.elementAt(i);
            }
        }
        this.exception = LdapCtx.mapErrorCode(status, msg);
        this.controls = controls;
    }

    public String getID() {
        return this.oid;
    }

    public byte[] getEncodedValue() {
        return this.extensionValue;
    }

    public String[] getReferrals() {
        return this.referrals;
    }

    public NamingException getException() {
        return this.exception;
    }

    public Control[] getControls() throws NamingException {
        return this.controls;
    }
}

