/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BerDecoder;
import java.io.IOException;
import java.util.Vector;
import javax.naming.CommunicationException;

final class LdapRequest {
    LdapRequest next;
    int msgId;
    private int gotten = 0;
    private Vector replies = new Vector(3);
    private boolean cancelled = false;
    private boolean pauseAfterReceipt = false;
    private boolean completed = false;

    LdapRequest(int msgId, boolean pause) {
        this.msgId = msgId;
        this.pauseAfterReceipt = pause;
    }

    synchronized void cancel() {
        this.cancelled = true;
        this.notify();
    }

    synchronized boolean addReplyBer(BerDecoder ber) {
        if (this.cancelled) {
            return false;
        }
        this.replies.addElement(ber);
        try {
            ber.parseSeq(null);
            ber.parseInt();
            this.completed = ber.peekByte() == 101;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ber.reset();
        this.notify();
        return this.pauseAfterReceipt;
    }

    synchronized BerDecoder getReplyBer() throws CommunicationException {
        if (this.cancelled) {
            throw new CommunicationException("Request: " + this.msgId + " cancelled");
        }
        if (this.gotten < this.replies.size()) {
            BerDecoder answer = (BerDecoder)this.replies.elementAt(this.gotten);
            this.replies.setElementAt(null, this.gotten);
            ++this.gotten;
            return answer;
        }
        return null;
    }

    synchronized boolean hasSearchCompleted() {
        return this.completed;
    }
}

