/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Histogram;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

class Coding
implements Constants,
Comparable,
CodingMethod,
Histogram.BitMetric {
    public static final int B_MAX = 5;
    public static final int H_MAX = 256;
    public static final int S_MAX = 2;
    private final int B;
    private final int H;
    private final int L;
    private final int S;
    private final int del;
    private final int min;
    private final int max;
    private final int umin;
    private final int umax;
    private final int[] byteMin;
    private final int[] byteMax;
    private static HashMap codeMap;
    private static final byte[] byteBitWidths;
    static boolean verboseStringForDebug;

    private static int saturate32(long x) {
        if (x > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (x < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)x;
    }

    private static long codeRangeLong(int B, int H) {
        return Coding.codeRangeLong(B, H, B);
    }

    private static long codeRangeLong(int B, int H, int nMax) {
        assert (nMax >= 0 && nMax <= B);
        assert (B >= 1 && B <= 5);
        assert (H >= 1 && H <= 256);
        if (nMax == 0) {
            return 0L;
        }
        if (B == 1) {
            return H;
        }
        int L = 256 - H;
        long sum = 0L;
        long H_i = 1L;
        for (int n = 1; n <= nMax; ++n) {
            sum += H_i;
            H_i *= (long)H;
        }
        sum *= (long)L;
        if (nMax == B) {
            sum += H_i;
        }
        return sum;
    }

    public static int codeMax(int B, int H, int S, int nMax) {
        long range = Coding.codeRangeLong(B, H, nMax);
        if (range == 0L) {
            return -1;
        }
        if (S == 0 || range >= 0x100000000L) {
            return Coding.saturate32(range - 1L);
        }
        long maxPos = range - 1L;
        while (Coding.isNegativeCode(maxPos, S)) {
            --maxPos;
        }
        if (maxPos < 0L) {
            return -1;
        }
        int smax = Coding.decodeSign32(maxPos, S);
        if (smax < 0) {
            return Integer.MAX_VALUE;
        }
        return smax;
    }

    public static int codeMin(int B, int H, int S, int nMax) {
        long range = Coding.codeRangeLong(B, H, nMax);
        if (range >= 0x100000000L && nMax == B) {
            return Integer.MIN_VALUE;
        }
        if (S == 0) {
            return 0;
        }
        int Smask = (1 << S) - 1;
        long maxNeg = range - 1L;
        while (!Coding.isNegativeCode(maxNeg, S)) {
            --maxNeg;
        }
        if (maxNeg < 0L) {
            return 0;
        }
        return Coding.decodeSign32(maxNeg, S);
    }

    private static long toUnsigned32(int sx) {
        return (long)sx << 32 >>> 32;
    }

    private static boolean isNegativeCode(long ux, int S) {
        assert (S > 0);
        assert (ux >= -1L);
        int Smask = (1 << S) - 1;
        return ((int)ux + 1 & Smask) == 0;
    }

    private static boolean hasNegativeCode(int sx, int S) {
        assert (S > 0);
        return 0 > sx && sx >= ~(-1 >>> S);
    }

    private static int decodeSign32(long ux, int S) {
        assert (ux == Coding.toUnsigned32((int)ux)) : Long.toHexString(ux);
        if (S == 0) {
            return (int)ux;
        }
        int sx = Coding.isNegativeCode(ux, S) ? ~((int)ux >>> S) : (int)ux - ((int)ux >>> S);
        assert (S != 1 || sx == ((int)ux >>> 1 ^ -((int)ux & 1)));
        return sx;
    }

    private static long encodeSign32(int sx, int S) {
        if (S == 0) {
            return Coding.toUnsigned32(sx);
        }
        int Smask = (1 << S) - 1;
        long ux = !Coding.hasNegativeCode(sx, S) ? (long)sx + Coding.toUnsigned32(sx) / (long)Smask : (long)((-sx << S) - 1);
        ux = Coding.toUnsigned32((int)ux);
        assert (sx == Coding.decodeSign32(ux, S)) : Long.toHexString(ux) + " -> " + Integer.toHexString(sx) + " != " + Integer.toHexString(Coding.decodeSign32(ux, S));
        return ux;
    }

    public static void writeInt(byte[] out, int[] outpos, int sx, int B, int H, int S) {
        long ux = Coding.encodeSign32(sx, S);
        assert (ux == Coding.toUnsigned32((int)ux));
        assert (ux < Coding.codeRangeLong(B, H)) : Long.toHexString(ux);
        int L = 256 - H;
        long sum = ux;
        int pos = outpos[0];
        for (int i = 0; i < B - 1 && sum >= (long)L; sum /= (long)H, ++i) {
            int b_i = (int)((long)L + (sum -= (long)L) % (long)H);
            out[pos++] = (byte)b_i;
        }
        out[pos++] = (byte)sum;
        outpos[0] = pos;
    }

    public static int readInt(byte[] in, int[] inpos, int B, int H, int S) {
        int L = 256 - H;
        long sum = 0L;
        long H_i = 1L;
        int pos = inpos[0];
        for (int i = 0; i < B; ++i) {
            int b_i = in[pos++] & 0xFF;
            sum += (long)b_i * H_i;
            H_i *= (long)H;
            if (b_i < L) break;
        }
        inpos[0] = pos;
        return Coding.decodeSign32(sum, S);
    }

    public static int readIntFrom(InputStream in, int B, int H, int S) throws IOException {
        int L = 256 - H;
        long sum = 0L;
        long H_i = 1L;
        for (int i = 0; i < B; ++i) {
            int b_i = in.read();
            if (b_i < 0) {
                throw new RuntimeException("unexpected EOF");
            }
            sum += (long)b_i * H_i;
            H_i *= (long)H;
            if (b_i < L) break;
        }
        assert (sum >= 0L && sum < Coding.codeRangeLong(B, H));
        return Coding.decodeSign32(sum, S);
    }

    private Coding(int B, int H, int S) {
        this(B, H, S, 0);
    }

    private Coding(int B, int H, int S, int del) {
        this.B = B;
        this.H = H;
        this.L = 256 - H;
        this.S = S;
        this.del = del;
        this.min = Coding.codeMin(B, H, S, B);
        this.max = Coding.codeMax(B, H, S, B);
        this.umin = Coding.codeMin(B, H, 0, B);
        this.umax = Coding.codeMax(B, H, 0, B);
        this.byteMin = new int[B];
        this.byteMax = new int[B];
        for (int nMax = 1; nMax <= B; ++nMax) {
            this.byteMin[nMax - 1] = Coding.codeMin(B, H, S, nMax);
            this.byteMax[nMax - 1] = Coding.codeMax(B, H, S, nMax);
        }
    }

    public boolean equals(Object x) {
        if (!(x instanceof Coding)) {
            return false;
        }
        Coding that = (Coding)x;
        if (this.B != that.B) {
            return false;
        }
        if (this.H != that.H) {
            return false;
        }
        if (this.S != that.S) {
            return false;
        }
        return this.del == that.del;
    }

    public int hashCode() {
        return (this.del << 14) + (this.S << 11) + (this.B << 8) + (this.H << 0);
    }

    private static synchronized Coding of(int B, int H, int S, int del) {
        Coding x0;
        Coding x1;
        if (codeMap == null) {
            codeMap = new HashMap();
        }
        if ((x1 = (Coding)codeMap.get(x0 = new Coding(B, H, S, del))) == null) {
            x1 = x0;
            codeMap.put(x0, x1);
        }
        return x1;
    }

    public static Coding of(int B, int H) {
        return Coding.of(B, H, 0, 0);
    }

    public static Coding of(int B, int H, int S) {
        return Coding.of(B, H, S, 0);
    }

    public boolean canRepresentValue(int x) {
        if (this.isSubrange()) {
            return this.canRepresentUnsigned(x);
        }
        return this.canRepresentSigned(x);
    }

    public boolean canRepresentSigned(int x) {
        return x >= this.min && x <= this.max;
    }

    public boolean canRepresentUnsigned(int x) {
        return x >= this.umin && x <= this.umax;
    }

    public int readFrom(byte[] in, int[] inpos) {
        return Coding.readInt(in, inpos, this.B, this.H, this.S);
    }

    public void writeTo(byte[] out, int[] outpos, int x) {
        Coding.writeInt(out, outpos, x, this.B, this.H, this.S);
    }

    public int readFrom(InputStream in) throws IOException {
        return Coding.readIntFrom(in, this.B, this.H, this.S);
    }

    public void writeTo(OutputStream out, int x) throws IOException {
        byte[] buf = new byte[this.B];
        int[] pos = new int[1];
        Coding.writeInt(buf, pos, x, this.B, this.H, this.S);
        out.write(buf, 0, pos[0]);
    }

    public void readArrayFrom(InputStream in, int[] a, int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            a[i] = this.readFrom(in);
        }
        for (int dstep = 0; dstep < this.del; ++dstep) {
            long state = 0L;
            for (int i = start; i < end; ++i) {
                state += (long)a[i];
                if (this.isSubrange()) {
                    state = this.reduceToUnsignedRange(state);
                }
                a[i] = (int)state;
            }
        }
    }

    public void writeArrayTo(OutputStream out, int[] a, int start, int end) throws IOException {
        if (end <= start) {
            return;
        }
        for (int dstep = 0; dstep < this.del; ++dstep) {
            int[] deltas = !this.isSubrange() ? Coding.makeDeltas(a, start, end, 0, 0) : Coding.makeDeltas(a, start, end, this.min, this.max);
            a = deltas;
            start = 0;
            end = deltas.length;
        }
        byte[] buf = new byte[256];
        int bufmax = buf.length - this.B;
        int[] pos = new int[]{0};
        int i = start;
        while (i < end) {
            while (pos[0] <= bufmax) {
                this.writeTo(buf, pos, a[i++]);
                if (i < end) continue;
            }
            out.write(buf, 0, pos[0]);
            pos[0] = 0;
        }
    }

    boolean isSubrange() {
        return this.max < Integer.MAX_VALUE && (long)this.max - (long)this.min + 1L <= Integer.MAX_VALUE;
    }

    boolean isFullRange() {
        return this.max == Integer.MAX_VALUE && this.min == Integer.MIN_VALUE;
    }

    int getRange() {
        assert (this.isSubrange());
        return this.max - this.min + 1;
    }

    Coding setB(int B) {
        return Coding.of(B, this.H, this.S, this.del);
    }

    Coding setH(int H) {
        return Coding.of(this.B, H, this.S, this.del);
    }

    Coding setS(int S) {
        return Coding.of(this.B, this.H, S, this.del);
    }

    Coding setL(int L) {
        return this.setH(256 - L);
    }

    Coding setD(int del) {
        return Coding.of(this.B, this.H, this.S, del);
    }

    Coding getDeltaCoding() {
        return this.setD(this.del + 1);
    }

    Coding getValueCoding() {
        if (this.isDelta()) {
            return Coding.of(this.B, this.H, 0, this.del - 1);
        }
        return this;
    }

    int reduceToUnsignedRange(long value) {
        if (value == (long)((int)value) && this.canRepresentUnsigned((int)value)) {
            return (int)value;
        }
        int range = this.getRange();
        assert (range > 0);
        if ((value %= (long)range) < 0L) {
            value += (long)range;
        }
        assert (this.canRepresentUnsigned((int)value));
        return (int)value;
    }

    int reduceToSignedRange(int value) {
        if (this.canRepresentSigned(value)) {
            return value;
        }
        return Coding.reduceToSignedRange(value, this.min, this.max);
    }

    static int reduceToSignedRange(int value, int min, int max) {
        int range = max - min + 1;
        assert (range > 0);
        int value0 = value;
        if ((value -= min) < 0 && value0 >= 0) assert ((value -= range) >= 0);
        if ((value %= range) < 0) {
            value += range;
        }
        assert (min <= (value += min) && value <= max);
        return value;
    }

    boolean isSigned() {
        return this.min < 0;
    }

    boolean isDelta() {
        return this.del != 0;
    }

    public int B() {
        return this.B;
    }

    public int H() {
        return this.H;
    }

    public int L() {
        return this.L;
    }

    public int S() {
        return this.S;
    }

    public int del() {
        return this.del;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public int umin() {
        return this.umin;
    }

    public int umax() {
        return this.umax;
    }

    public int byteMin(int b) {
        return this.byteMin[b - 1];
    }

    public int byteMax(int b) {
        return this.byteMax[b - 1];
    }

    public int compareTo(Object x) {
        Coding that = (Coding)x;
        int dkey = this.del - that.del;
        if (dkey == 0) {
            dkey = this.B - that.B;
        }
        if (dkey == 0) {
            dkey = this.H - that.H;
        }
        if (dkey == 0) {
            dkey = this.S - that.S;
        }
        return dkey;
    }

    public int distanceFrom(Coding that) {
        int diffHL;
        int diffB;
        int diffS;
        int diffdel = this.del - that.del;
        if (diffdel < 0) {
            diffdel = -diffdel;
        }
        if ((diffS = this.S - that.S) < 0) {
            diffS = -diffS;
        }
        if ((diffB = this.B - that.B) < 0) {
            diffB = -diffB;
        }
        if (this.H == that.H) {
            diffHL = 0;
        } else {
            int thisHL = this.getHL();
            int thatHL = that.getHL();
            diffHL = (thisHL *= thisHL) > (thatHL *= thatHL) ? Coding.ceil_lg2(1 + (thisHL - 1) / thatHL) : Coding.ceil_lg2(1 + (thatHL - 1) / thisHL);
        }
        int norm = 5 * (diffdel + diffS + diffB) + diffHL;
        assert (norm != 0 || this.compareTo(that) == 0);
        return norm;
    }

    private int getHL() {
        if (this.H <= 128) {
            return this.H;
        }
        if (this.L >= 1) {
            return 16384 / this.L;
        }
        return 32768;
    }

    static int ceil_lg2(int x) {
        assert (x - 1 >= 0);
        --x;
        int lg = 0;
        while (x != 0) {
            ++lg;
            x >>= 1;
        }
        return lg;
    }

    static int bitWidth(int i) {
        if (i < 0) {
            i ^= 0xFFFFFFFF;
        }
        int w = 0;
        int lo = i;
        if (lo < byteBitWidths.length) {
            return byteBitWidths[lo];
        }
        int hi = lo >>> 16;
        if (hi != 0) {
            lo = hi;
            w += 16;
        }
        if ((hi = lo >>> 8) != 0) {
            lo = hi;
            w += 8;
        }
        return w += byteBitWidths[lo];
    }

    static int[] makeDeltas(int[] values, int start, int end, int min, int max) {
        assert (max >= min);
        int count = end - start;
        int[] deltas = new int[count];
        int state = 0;
        if (min == max) {
            for (int i = 0; i < count; ++i) {
                int value = values[start + i];
                deltas[i] = value - state;
                state = value;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                int value = values[start + i];
                assert (value >= 0 && value + min <= max);
                int delta = value - state;
                assert ((long)delta == (long)value - (long)state);
                state = value;
                deltas[i] = delta = Coding.reduceToSignedRange(delta, min, max);
            }
        }
        return deltas;
    }

    boolean canRepresent(int minValue, int maxValue) {
        assert (minValue <= maxValue);
        if (this.del > 0) {
            if (this.isSubrange()) {
                return this.canRepresentUnsigned(maxValue) && this.canRepresentUnsigned(minValue);
            }
            return this.isFullRange();
        }
        return this.canRepresentSigned(maxValue) && this.canRepresentSigned(minValue);
    }

    boolean canRepresent(int[] values, int start, int end) {
        int max;
        int len = end - start;
        if (len == 0) {
            return true;
        }
        if (this.isFullRange()) {
            return true;
        }
        int min = max = values[start];
        for (int i = 1; i < len; ++i) {
            int value = values[start + i];
            if (max < value) {
                max = value;
            }
            if (min <= value) continue;
            min = value;
        }
        return this.canRepresent(min, max);
    }

    public double getBitLength(int value) {
        return (double)this.getLength(value) * 8.0;
    }

    public int getLength(int value) {
        if (this.isDelta() && this.isSubrange()) {
            if (!this.canRepresentUnsigned(value)) {
                return Integer.MAX_VALUE;
            }
            value = this.reduceToSignedRange(value);
        }
        if (value >= 0) {
            for (int n = 0; n < this.B; ++n) {
                if (value > this.byteMax[n]) continue;
                return n + 1;
            }
        } else {
            for (int n = 0; n < this.B; ++n) {
                if (value < this.byteMin[n]) continue;
                return n + 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    public int getLength(int[] values, int start, int end) {
        int len = end - start;
        if (this.B == 1) {
            return len;
        }
        if (this.L == 0) {
            return len * this.B;
        }
        if (this.isDelta()) {
            int[] deltas = !this.isSubrange() ? Coding.makeDeltas(values, start, end, 0, 0) : Coding.makeDeltas(values, start, end, this.min, this.max);
            values = deltas;
            start = 0;
            end = values.length;
        }
        int sum = len;
        for (int n = 1; n <= this.B; ++n) {
            int max = this.byteMax[n - 1];
            int min = this.byteMin[n - 1];
            int longer = 0;
            for (int i = 0; i < len; ++i) {
                int value = values[start + i];
                if (value >= 0) {
                    if (value <= max) continue;
                    ++longer;
                    continue;
                }
                if (value >= min) continue;
                ++longer;
            }
            if (longer == 0) break;
            if (n == this.B) {
                return Integer.MAX_VALUE;
            }
            sum += longer;
        }
        return sum;
    }

    public byte[] getMetaCoding(Coding dflt) {
        if (dflt == this) {
            return new byte[]{0};
        }
        int canonicalIndex = BandStructure.indexOf(this);
        if (canonicalIndex > 0) {
            return new byte[]{(byte)canonicalIndex};
        }
        return new byte[]{116, (byte)(this.del + 2 * this.S + 8 * (this.B - 1)), (byte)(this.H - 1)};
    }

    public static int parseMetaCoding(byte[] bytes, int pos, Coding dflt, CodingMethod[] res) {
        int op;
        if (1 <= (op = bytes[pos++] & 0xFF) && op <= 115) {
            Coding c = BandStructure.codingForIndex(op);
            assert (c != null);
            res[0] = c;
            return pos;
        }
        if (op == 116) {
            int dsb = bytes[pos++] & 0xFF;
            int H_1 = bytes[pos++] & 0xFF;
            int del = dsb % 2;
            int S = dsb / 2 % 4;
            int B = dsb / 8 + 1;
            int H = H_1 + 1;
            if (1 > B || B > 5 || 0 > S || S > 2 || 1 > H || H > 256 || 0 > del || del > 1 || B == 1 && H != 256 || B == 5 && H == 256) {
                throw new RuntimeException("Bad arb. coding: (" + B + "," + H + "," + S + "," + del);
            }
            res[0] = Coding.of(B, H, S, del);
            return pos;
        }
        return pos - 1;
    }

    public String keyString() {
        return "(" + this.B + "," + this.H + "," + this.S + "," + this.del + ")";
    }

    public String toString() {
        String str = "Coding" + this.keyString();
        return str;
    }

    String stringForDebug() {
        String minS = this.min == Integer.MIN_VALUE ? "min" : "" + this.min;
        String maxS = this.max == Integer.MAX_VALUE ? "max" : "" + this.max;
        String str = this.keyString() + " L=" + this.L + " r=[" + minS + "," + maxS + "]";
        if (this.isSubrange()) {
            str = str + " subrange";
        } else if (!this.isFullRange()) {
            str = str + " MIDRANGE";
        }
        if (verboseStringForDebug) {
            str = str + " {";
            int prev_range = 0;
            for (int n = 1; n <= this.B; ++n) {
                int range_n = Coding.saturate32((long)this.byteMax[n - 1] - (long)this.byteMin[n - 1] + 1L);
                assert (range_n == Coding.saturate32(Coding.codeRangeLong(this.B, this.H, n)));
                prev_range = range_n -= prev_range;
                String rngS = range_n == Integer.MAX_VALUE ? "max" : "" + range_n;
                str = str + " #" + n + "=" + rngS;
            }
            str = str + " }";
        }
        return str;
    }

    static {
        byteBitWidths = new byte[256];
        for (int b = 0; b < byteBitWidths.length; ++b) {
            Coding.byteBitWidths[b] = (byte)Coding.ceil_lg2(b + 1);
        }
        int i = 10;
        while (i >= 0) {
            assert (Coding.bitWidth(i) == Coding.ceil_lg2(i + 1));
            i = (i << 1) - (i >> 3);
        }
        verboseStringForDebug = false;
    }
}

