/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.ServerMain;
import com.sun.corba.se.impl.logging.ActivationSystemException;
import com.sun.corba.se.spi.activation.EndPointInfo;
import com.sun.corba.se.spi.activation.InvalidORBid;
import com.sun.corba.se.spi.activation.ORBAlreadyRegistered;
import com.sun.corba.se.spi.activation.ORBPortInfo;
import com.sun.corba.se.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.se.spi.activation.Server;
import com.sun.corba.se.spi.activation.ServerHeldDown;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.omg.CORBA.SystemException;

public class ServerTableEntry {
    private static final int DE_ACTIVATED = 0;
    private static final int ACTIVATING = 1;
    private static final int ACTIVATED = 2;
    private static final int RUNNING = 3;
    private static final int HELD_DOWN = 4;
    private static final long waitTime = 2000L;
    private static final int ActivationRetryMax = 5;
    private int state;
    private int serverId;
    private HashMap orbAndPortInfo;
    private Server serverObj;
    private ServerDef serverDef;
    private Process process;
    private int activateRetryCount = 0;
    private String activationCmd;
    private ActivationSystemException wrapper;
    private static String javaHome = System.getProperty("java.home");
    private static String classPath = System.getProperty("java.class.path");
    private static String fileSep = System.getProperty("file.separator");
    private static String pathSep = System.getProperty("path.separator");
    private boolean debug = false;

    private String printState() {
        String str = "UNKNOWN";
        switch (this.state) {
            case 0: {
                str = "DE_ACTIVATED";
                break;
            }
            case 1: {
                str = "ACTIVATING  ";
                break;
            }
            case 2: {
                str = "ACTIVATED   ";
                break;
            }
            case 3: {
                str = "RUNNING     ";
                break;
            }
            case 4: {
                str = "HELD_DOWN   ";
                break;
            }
        }
        return str;
    }

    public String toString() {
        return "ServerTableEntry[state=" + this.printState() + " serverId=" + this.serverId + " activateRetryCount=" + this.activateRetryCount + "]";
    }

    ServerTableEntry(ActivationSystemException wrapper, int serverId, ServerDef serverDef, int initialPort, String dbDirName, boolean verify, boolean debug) {
        this.wrapper = wrapper;
        this.serverId = serverId;
        this.serverDef = serverDef;
        this.debug = debug;
        this.orbAndPortInfo = new HashMap(255);
        this.activateRetryCount = 0;
        this.state = 1;
        this.activationCmd = javaHome + fileSep + "bin" + fileSep + "java " + serverDef.serverVmArgs + " " + "-Dioser=" + System.getProperty("ioser") + " " + "-D" + "org.omg.CORBA.ORBInitialPort" + "=" + initialPort + " " + "-D" + "com.sun.CORBA.activation.DbDir" + "=" + dbDirName + " " + "-D" + "com.sun.CORBA.POA.ORBActivated" + "=true " + "-D" + "com.sun.CORBA.POA.ORBServerId" + "=" + serverId + " " + "-D" + "com.sun.CORBA.POA.ORBServerName" + "=" + serverDef.serverName + " " + (verify ? "-Dcom.sun.CORBA.activation.ORBServerVerify=true " : "") + "-classpath " + classPath + (serverDef.serverClassPath.equals("") ? "" : pathSep) + serverDef.serverClassPath + " com.sun.corba.se.impl.activation.ServerMain " + serverDef.serverArgs + (debug ? " -debug" : "");
        if (debug) {
            System.out.println("ServerTableEntry constructed with activation command " + this.activationCmd);
        }
    }

    public int verify() {
        try {
            if (this.debug) {
                System.out.println("Server being verified w/" + this.activationCmd);
            }
            this.process = Runtime.getRuntime().exec(this.activationCmd);
            int result = this.process.waitFor();
            if (this.debug) {
                this.printDebug("verify", "returns " + ServerMain.printResult(result));
            }
            return result;
        }
        catch (Exception e) {
            if (this.debug) {
                this.printDebug("verify", "returns unknown error because of exception " + e);
            }
            return 4;
        }
    }

    private void printDebug(String method, String msg) {
        System.out.println("ServerTableEntry: method  =" + method);
        System.out.println("ServerTableEntry: server  =" + this.serverId);
        System.out.println("ServerTableEntry: state   =" + this.printState());
        System.out.println("ServerTableEntry: message =" + msg);
        System.out.println();
    }

    synchronized void activate() throws SystemException {
        this.state = 2;
        try {
            if (this.debug) {
                this.printDebug("activate", "activating server");
            }
            this.process = Runtime.getRuntime().exec(this.activationCmd);
        }
        catch (Exception e) {
            this.deActivate();
            if (this.debug) {
                this.printDebug("activate", "throwing premature process exit");
            }
            throw this.wrapper.unableToStartProcess();
        }
    }

    synchronized void register(Server server) {
        if (this.state == 2) {
            this.serverObj = server;
            if (this.debug) {
                this.printDebug("register", "process registered back");
            }
        } else {
            if (this.debug) {
                this.printDebug("register", "throwing premature process exit");
            }
            throw this.wrapper.serverNotExpectedToRegister();
        }
    }

    synchronized void registerPorts(String orbId, EndPointInfo[] endpointList) throws ORBAlreadyRegistered {
        if (this.orbAndPortInfo.containsKey(orbId)) {
            throw new ORBAlreadyRegistered(orbId);
        }
        int numListenerPorts = endpointList.length;
        EndPointInfo[] serverListenerPorts = new EndPointInfo[numListenerPorts];
        for (int i = 0; i < numListenerPorts; ++i) {
            serverListenerPorts[i] = new EndPointInfo(endpointList[i].endpointType, endpointList[i].port);
            if (!this.debug) continue;
            System.out.println("registering type: " + serverListenerPorts[i].endpointType + "  port  " + serverListenerPorts[i].port);
        }
        this.orbAndPortInfo.put(orbId, serverListenerPorts);
        if (this.state == 2) {
            this.state = 3;
            this.notifyAll();
        }
        if (this.debug) {
            this.printDebug("registerPorts", "process registered Ports");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void install() {
        Server localServerObj = null;
        ServerTableEntry serverTableEntry = this;
        synchronized (serverTableEntry) {
            if (this.state != 3) {
                throw this.wrapper.serverNotRunning();
            }
            localServerObj = this.serverObj;
        }
        if (localServerObj != null) {
            localServerObj.install();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstall() {
        Server localServerObj = null;
        Process localProcess = null;
        ServerTableEntry serverTableEntry = this;
        synchronized (serverTableEntry) {
            localServerObj = this.serverObj;
            localProcess = this.process;
            if (this.state != 3) {
                throw this.wrapper.serverNotRunning();
            }
            this.deActivate();
        }
        try {
            if (localServerObj != null) {
                localServerObj.shutdown();
                localServerObj.uninstall();
            }
            if (localProcess != null) {
                localProcess.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void holdDown() {
        this.state = 4;
        if (this.debug) {
            this.printDebug("holdDown", "server held down");
        }
        this.notifyAll();
    }

    synchronized void deActivate() {
        this.state = 0;
        if (this.debug) {
            this.printDebug("deActivate", "server deactivated");
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void checkProcessHealth() {
        if (this.state == 3) {
            try {
                int exitVal = this.process.exitValue();
            }
            catch (IllegalThreadStateException e1) {
                return;
            }
            ServerTableEntry serverTableEntry = this;
            synchronized (serverTableEntry) {
                this.orbAndPortInfo.clear();
                this.deActivate();
            }
        }
    }

    synchronized boolean isValid() {
        if (this.state == 1 || this.state == 4) {
            if (this.debug) {
                this.printDebug("isValid", "returns true");
            }
            return true;
        }
        try {
            int exitVal = this.process.exitValue();
        }
        catch (IllegalThreadStateException e1) {
            return true;
        }
        if (this.state == 2) {
            if (this.activateRetryCount < 5) {
                if (this.debug) {
                    this.printDebug("isValid", "reactivating server");
                }
                ++this.activateRetryCount;
                this.activate();
                return true;
            }
            if (this.debug) {
                this.printDebug("isValid", "holding server down");
            }
            this.holdDown();
            return true;
        }
        this.deActivate();
        return false;
    }

    synchronized ORBPortInfo[] lookup(String endpointType) throws ServerHeldDown {
        while (this.state == 1 || this.state == 2) {
            try {
                this.wait(2000L);
                if (this.isValid()) continue;
                break;
            }
            catch (Exception e) {
            }
        }
        ORBPortInfo[] orbAndPortList = null;
        if (this.state == 3) {
            orbAndPortList = new ORBPortInfo[this.orbAndPortInfo.size()];
            Iterator setORBids = this.orbAndPortInfo.keySet().iterator();
            try {
                int numElements = 0;
                while (setORBids.hasNext()) {
                    String orbId = (String)setORBids.next();
                    EndPointInfo[] serverListenerPorts = (EndPointInfo[])this.orbAndPortInfo.get(orbId);
                    int port = -1;
                    for (int i = 0; i < serverListenerPorts.length; ++i) {
                        if (this.debug) {
                            System.out.println("lookup num-ports " + serverListenerPorts.length + "   " + serverListenerPorts[i].endpointType + "   " + serverListenerPorts[i].port);
                        }
                        if (!serverListenerPorts[i].endpointType.equals(endpointType)) continue;
                        port = serverListenerPorts[i].port;
                        break;
                    }
                    orbAndPortList[numElements] = new ORBPortInfo(orbId, port);
                    ++numElements;
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            return orbAndPortList;
        }
        if (this.debug) {
            this.printDebug("lookup", "throwing server held down error");
        }
        throw new ServerHeldDown(this.serverId);
    }

    synchronized EndPointInfo[] lookupForORB(String orbId) throws ServerHeldDown, InvalidORBid {
        while (this.state == 1 || this.state == 2) {
            try {
                this.wait(2000L);
                if (this.isValid()) continue;
                break;
            }
            catch (Exception e) {
            }
        }
        EndPointInfo[] portList = null;
        if (this.state == 3) {
            try {
                EndPointInfo[] serverListenerPorts = (EndPointInfo[])this.orbAndPortInfo.get(orbId);
                portList = new EndPointInfo[serverListenerPorts.length];
                for (int i = 0; i < serverListenerPorts.length; ++i) {
                    if (this.debug) {
                        System.out.println("lookup num-ports " + serverListenerPorts.length + "   " + serverListenerPorts[i].endpointType + "   " + serverListenerPorts[i].port);
                    }
                    portList[i] = new EndPointInfo(serverListenerPorts[i].endpointType, serverListenerPorts[i].port);
                }
            }
            catch (NoSuchElementException e) {
                throw new InvalidORBid();
            }
            return portList;
        }
        if (this.debug) {
            this.printDebug("lookup", "throwing server held down error");
        }
        throw new ServerHeldDown(this.serverId);
    }

    synchronized String[] getORBList() {
        String[] orbList = new String[this.orbAndPortInfo.size()];
        Iterator setORBids = this.orbAndPortInfo.keySet().iterator();
        try {
            int numElements = 0;
            while (setORBids.hasNext()) {
                String orbId = (String)setORBids.next();
                orbList[numElements++] = orbId;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return orbList;
    }

    int getServerId() {
        return this.serverId;
    }

    boolean isActive() {
        return this.state == 3 || this.state == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void destroy() {
        block12: {
            Process localProcess;
            block11: {
                Server localServerObj = null;
                localProcess = null;
                ServerTableEntry serverTableEntry = this;
                synchronized (serverTableEntry) {
                    localServerObj = this.serverObj;
                    localProcess = this.process;
                    this.deActivate();
                }
                try {
                    if (localServerObj != null) {
                        localServerObj.shutdown();
                    }
                    if (this.debug) {
                        this.printDebug("destroy", "server shutdown successfully");
                    }
                }
                catch (Exception ex) {
                    if (!this.debug) break block11;
                    this.printDebug("destroy", "server shutdown threw exception" + ex);
                }
            }
            try {
                if (localProcess != null) {
                    localProcess.destroy();
                }
                if (this.debug) {
                    this.printDebug("destroy", "process destroyed successfully");
                }
            }
            catch (Exception ex) {
                if (!this.debug) break block12;
                this.printDebug("destroy", "process destroy threw exception" + ex);
            }
        }
    }
}

