/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import sun.misc.SharedSecrets;
import sun.reflect.FieldAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.FieldRepository;
import sun.reflect.generics.scope.ClassScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Field
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class type;
    private int modifiers;
    private transient String signature;
    private transient FieldRepository genericInfo;
    private byte[] annotations;
    private FieldAccessor fieldAccessor;
    private FieldAccessor overrideFieldAccessor;
    private Field root;
    private Class securityCheckCache;
    private Class securityCheckTargetClassCache;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private transient Map<Class, Annotation> declaredAnnotations;

    private String getGenericSignature() {
        return this.signature;
    }

    private GenericsFactory getFactory() {
        Class<?> c = this.getDeclaringClass();
        return CoreReflectionFactory.make(c, ClassScope.make(c));
    }

    private FieldRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = FieldRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Field(Class declaringClass, String name, Class type, int modifiers, int slot, String signature, byte[] annotations) {
        this.clazz = declaringClass;
        this.name = name;
        this.type = type;
        this.modifiers = modifiers;
        this.slot = slot;
        this.signature = signature;
        this.annotations = annotations;
    }

    Field copy() {
        Field res = new Field(this.clazz, this.name, this.type, this.modifiers, this.slot, this.signature, this.annotations);
        res.root = this;
        res.fieldAccessor = this.fieldAccessor;
        res.overrideFieldAccessor = this.overrideFieldAccessor;
        return res;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getGenericType();
        }
        return this.getType();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Field) {
            Field other = (Field)obj;
            return this.getDeclaringClass() == other.getDeclaringClass() && this.getName() == other.getName() && this.getType() == other.getType();
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int mod = this.getModifiers();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + Field.getTypeName(this.getType()) + " " + Field.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    public String toGenericString() {
        int mod = this.getModifiers();
        Type fieldType = this.getGenericType();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + (fieldType instanceof Class ? Field.getTypeName((Class)fieldType) : fieldType.toString()) + " " + Field.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    public Object get(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).get(obj);
    }

    public boolean getBoolean(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getBoolean(obj);
    }

    public byte getByte(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getByte(obj);
    }

    public char getChar(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getChar(obj);
    }

    public short getShort(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getShort(obj);
    }

    public int getInt(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getInt(obj);
    }

    public long getLong(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getLong(obj);
    }

    public float getFloat(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getFloat(obj);
    }

    public double getDouble(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(obj).getDouble(obj);
    }

    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).set(obj, value);
    }

    public void setBoolean(Object obj, boolean z) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setBoolean(obj, z);
    }

    public void setByte(Object obj, byte b) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setByte(obj, b);
    }

    public void setChar(Object obj, char c) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setChar(obj, c);
    }

    public void setShort(Object obj, short s) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setShort(obj, s);
    }

    public void setInt(Object obj, int i) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setInt(obj, i);
    }

    public void setLong(Object obj, long l) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setLong(obj, l);
    }

    public void setFloat(Object obj, float f) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setFloat(obj, f);
    }

    public void setDouble(Object obj, double d) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(obj).setDouble(obj, d);
    }

    private FieldAccessor getFieldAccessor(Object obj) throws IllegalAccessException {
        this.doSecurityCheck(obj);
        boolean ov = this.override;
        FieldAccessor a = ov ? this.overrideFieldAccessor : this.fieldAccessor;
        return a != null ? a : this.acquireFieldAccessor(ov);
    }

    private FieldAccessor acquireFieldAccessor(boolean overrideFinalCheck) {
        FieldAccessor tmp = null;
        if (this.root != null) {
            tmp = this.root.getFieldAccessor(overrideFinalCheck);
        }
        if (tmp != null) {
            if (overrideFinalCheck) {
                this.overrideFieldAccessor = tmp;
            } else {
                this.fieldAccessor = tmp;
            }
        } else {
            tmp = reflectionFactory.newFieldAccessor(this, overrideFinalCheck);
            this.setFieldAccessor(tmp, overrideFinalCheck);
        }
        return tmp;
    }

    private FieldAccessor getFieldAccessor(boolean overrideFinalCheck) {
        return overrideFinalCheck ? this.overrideFieldAccessor : this.fieldAccessor;
    }

    private void setFieldAccessor(FieldAccessor accessor, boolean overrideFinalCheck) {
        if (overrideFinalCheck) {
            this.overrideFieldAccessor = accessor;
        } else {
            this.fieldAccessor = accessor;
        }
        if (this.root != null) {
            this.root.setFieldAccessor(accessor, overrideFinalCheck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSecurityCheck(Object obj) throws IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class caller = Reflection.getCallerClass(4);
            Class<?> targetClass = obj == null || !Modifier.isProtected(this.modifiers) ? this.clazz : obj.getClass();
            Field field = this;
            synchronized (field) {
                if (this.securityCheckCache == caller && this.securityCheckTargetClassCache == targetClass) {
                    return;
                }
            }
            Reflection.ensureMemberAccess(caller, this.clazz, obj, this.modifiers);
            field = this;
            synchronized (field) {
                this.securityCheckCache = caller;
                this.securityCheckTargetClassCache = targetClass;
            }
        }
    }

    static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        return (T)this.declaredAnnotations().get(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations().values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    private synchronized Map<Class, Annotation> declaredAnnotations() {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = AnnotationParser.parseAnnotations(this.annotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        }
        return this.declaredAnnotations;
    }
}

